unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, arscmode, ExtCtrls, Math;

type
  TForm1 = class(TForm)
    btTest: TButton;
    eCapt: TEdit;
    eX1: TEdit;
    eY1: TEdit;
    eZ1: TEdit;
    eX2: TEdit;
    eY2: TEdit;
    eZ2: TEdit;
    btFlag: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    eId: TEdit;
    Label7: TLabel;
    Button1: TButton;
    Label8: TLabel;
    Bevel1: TBevel;
    rb1: TRadioButton;
    rb2: TRadioButton;
    egid: TEdit;
    Label9: TLabel;
    btOpen: TButton;
    btClose: TButton;
    procedure btTestClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure btFlagClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure btCloseClick(Sender: TObject);
    procedure btOpenClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  {Command codes:
    01 - test
    02 - open another grid
    03 - close program
    11 - set point   12 - delete point
    21 - set zone    22 - delete zone
    31 - set actor   32 - delete actor

   Command results:
    0 - unknown error
    1 - not in Scene Mode
    2 - unknown command
    3 - invalid data format
    999 - ok
    1000 - test ok
  }

  TComData = record
   Id: Byte;
   x1, y1, z1, x2, y2, z2: SmallInt;
   Data: Integer;
   Text: array[0..200] of Char; // null-terminated string  (200 characters + trailing null)
  end;

var
  Form1: TForm1;
  ComData: TComData;
  PBuffer: PChar;
  t: PChar;

implementation

{$R *.dfm}

function SendCommand(Command: Byte; data: TComData): Integer;
var temp: TCopyDataStruct;
    hw: HWND;
begin
 hw:=FindWindow(nil,'Little Grid Builder - Scene Mode');
 temp.dwData:=Command;
 temp.cbData:=SizeOf(TComData);
 temp.lpData:=@data;
 Result:=SendMessage(hw,WM_COPYDATA,0,Integer(@temp));
end;

procedure TForm1.btTestClick(Sender: TObject);
var a: Integer;
begin
 a:=SendCommand(01,ComData);
 If a=1000 then
  MessageBox(handle,'Communication OK!','',MB_ICONINFORMATION+MB_OK)
 else
  MessageBox(handle,PChar('Communication Error!'#13#13'Return value: '+IntToStr(a)),'',MB_ICONERROR+MB_OK);

 //if CommTest then MessageBox(handle,'Communication OK.','Test',MB_ICONINFORMATION+MB_OK)
 //else MessageBox(handle,'Communication timed out!','Test',MB_ICONERROR+MB_OK)
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 CommClose;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 //CommSetGlobalTimeout(5000);
 //CommOpen;
end;

procedure TForm1.btFlagClick(Sender: TObject);
var temp: TCText;
    hw: HWND;
begin
 ComData.x1:=StrToIntDef(eX1.Text,0);
 ComData.y1:=StrToIntDef(eY1.Text,0);
 ComData.z1:=StrToIntDef(eZ1.Text,0);
 ComData.x2:=StrToIntDef(eX2.Text,0);
 ComData.y2:=StrToIntDef(eY2.Text,0);
 ComData.z2:=StrToIntDef(eZ2.Text,0);
 ComData.Id:=StrToIntDef(eId.Text,0);
 StrpCopy(ComData.Text,'bleble'); //eCapt.Text);
 Label8.Caption:=IntToStr(SendCommand(11,ComData));

 //StrpCopy(temp,eCapt.Text);
 //CommSetFlag(StrToIntDef(eId.Text,0),
 // StrToIntDef(eX1.Text,0),StrToIntDef(eY1.Text,0),StrToIntDef(eZ1.Text,0),temp);
//end;

procedure TForm1.Button1Click(Sender: TObject);
begin
 ComData.Id:=StrToIntDef(eId.Text,0);
 SendCommand(12,ComData);
 
 //CommDelFlag(StrToIntDef(eId.Text,0));
end;
{$o-}
procedure TForm1.Button2Click(Sender: TObject);
var hw: HWND;
    test: Integer;
    s: String;
    data: TCopyDataStruct;
begin
 hw:=FindWindow(nil,'Little Grid Builder - Scene Mode');
 s:='abkazekstartejhotnw';
 data.dwData:=350;
 data.cbData:=20;
 data.lpData:=@s[1];
 //SendMessage(hw,SM_NEWFLAGPOS,10,20);
 test:=SendMessage(hw,WM_COPYDATA,0,Integer(@data));
 btTest.Caption:=IntToStr(test);
end;

procedure TForm1.btCloseClick(Sender: TObject);
begin
 SendCommand(03,ComData);
end;

procedure TForm1.btOpenClick(Sender: TObject);
begin
 ComData.Id:=IfThen(rb1.Checked,1,2);
 ComData.Data:=StrToIntDef(egid.Text,0);
 SendCommand(02,ComData);
end;

end.
