//***************************************************************************
// LBA Package Editor - editing hqr, ile, obl, vox packages from 
//                      Little Big Adventure 1 & 2
//
// Copyright (C) 2003/2005 Zink
//
// e-mail: zink@poczta.onet.pl
//
// This source code is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This source code is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License (License.txt) for more details.
//***************************************************************************

unit Progress;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Gauges;

type
  TProgForm = class(TForm)
    Gauge1: TGauge;
    Bevel1: TBevel;
    Label1: TLabel;
    Button1: TButton;
    Label2: TLabel;
    Label3: TLabel;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure Setup(Name: String; MaxVal: Integer; AllowCancel: Boolean = True);
    procedure Update(Val: Integer);
  end;

var
  ProgForm: TProgForm;
  IntReq: Boolean;
  MaxValStr: String;
  StartTime: TDateTime;

implementation

uses LBAPackEd1;

{$R *.dfm}

procedure TProgForm.FormShow(Sender: TObject);
begin
 Form1.Enabled:=False;
end;

procedure TProgForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 Form1.Enabled:=True;
end;

procedure TProgForm.Button1Click(Sender: TObject);
begin
 IntReq:=True;
end;

procedure TProgForm.Setup(Name: String; MaxVal: Integer; AllowCancel: Boolean = True);
begin
 IntReq:=False;
 StartTime:=GetTime;
 Button1.Visible:=AllowCancel; 
 Label1.Caption:=Name;
 Gauge1.MaxValue:=MaxVal;
 MaxValStr:=' / '+IntToStr(MaxVal);
 Label3.Caption:='0'+MaxValStr;
 Show;
end;

procedure TProgForm.Update(Val: Integer);
//var ActTime, DispTime, ElTime: TDateTime;
begin
 //ActTime:=GetTime;
 //ElTime:=ActTime-StartTime;
// If Val<>0 then
 // DispTime:=(ElTime*Gauge1.MaxValue/Val)-ElTime+0.00001;
 Gauge1.Progress:=Val;
 Label3.Caption:=IntToStr(Val)+MaxValStr;
// Label2.Caption:='ETA: '+TimeToStr(DispTime);
 Application.ProcessMessages;
end;

end.
