//******************************************************************************
// Little Big Architect: Builder - editing grid files containing rooms in
//                                 Little Big Adventure 1 & 2
//
// BEngine unit.
// Contains routines used for displaying and editing rooms.
//
// Copyright Zink
// e-mail: zink@poczta.onet.pl
// See the GNU General Public License (License.txt) for details.
//******************************************************************************

unit BEngine;

interface

uses DePack, Engine, Grids, Libraries, Classes, ProgBar, SysUtils, Windows,
     ExtCtrls, Graphics, Controls, Math, Bricks;

type
 TBreakMapItem = record
  Typ, Id: Integer;
 end;

 //TBitBrick = array[0..47,0..37] of TColor; //0 = transparent

 //TSelArray = array of array of array of Boolean;

 TDrawMode = (dmNormal, dmRemember, dmMerge);

const
 Lba1Invisible: TMapItem = (Idx: (Lt: 0; Brk: 1); BrkNr: 0; Frame: [foSelect]);
 EmptyItem: TMapItem = (Idx: (Lt: 0; Brk: 0); BrkNr: -1; Frame: []);

var
 HighX: Integer = 63; //grid dimensions
 HighY: Integer = 24;
 HighZ: Integer = 63;
 ImageW: Integer = 3100; //pixels
 ImageH: Integer = 1950;
 Off_X: Integer = 1530;  //pixels
 Off_Y: Integer = 380;
 ScrollX: Integer = 0; //pixels
 ScrollY: Integer = 0;
 MaxLayer: Integer = 24;
 //bitBuffers: array of TBitBrick;
 BuffMap: array of SmallInt; {16 bit signed}
 Map: TGridMap;
 //BreakMap: array[0..63,0..24,0..63] of array of TBreakMapItem; //used in Scene only - always full size
 Coords: array[0..2,0..3] of Integer;
 CoIndex, CoLayer: Integer;
 FneCoords: array[0..2] of Integer;
 FneDone: Boolean;
 LayoutMap: array of Integer;
 Lba2Invisible: TMapItem;
 TransparentBrick: DWord = 0;

 LtSel: Integer = 1;
 PlacePos: TPoint3d = (x: -1000; y: -1000; z: -1000);
 PlaceObj: TPiece;
 BufObj: TPiece;
 FrDrawRgn: TRect;
 BadLibraryMessage: Boolean = False;

 ThumbCounter: Integer = 0;

procedure DrawNet(X, Y: Integer);
procedure UpdateClip(Src: TBitmap; Dest: TPaintBox);
procedure DrawMap(x, y: Integer; Dest: TBitmap;
 StartX: Integer = 0; StartY: Integer = 0; StartZ: Integer = 0);
procedure DrawMapA(dx: Integer = 0; dy: Integer = 0);
procedure DrawPiece(x, y, width, height: Integer; DrawMode: TDrawMode = dmNormal;
 ThumbRepnt: Boolean = True; DrawObjs: Boolean = True; DrawSel: Boolean = True;
 UpdClip: Boolean = True;
 StartX: Integer = 0; StartY: Integer = 0; StartZ: Integer = 0);
procedure DrawPieceBrk(x, y, z, dx, dy, dz: Integer; Mode: TDrawMode = dmNormal;
 Helper: Boolean = False; ThumbRepaint: Boolean = True);
procedure ScrollMap(dx, dy: Integer);
Procedure BufferBricks(Lib: TLibrary; Brk: TPackEntries);
Procedure CreateThumbnail(x1: Byte = 0; y1: Byte = 0; x2: Byte = 151; y2: Byte = 95);
Procedure UpdateThumbnail(x1, y1, z1, x2, y2, z2: Integer);
Procedure UpdateThumbBack;
Function FindLayout(x, y, z: Integer): TBox;
procedure GetBrick(X, Y, L: Integer; var gX, gZ: Integer);
Function PixelOfScreenVal(X, Y: Integer; Full, Inv: Boolean): Byte;
Function PixelOfScreen(X, Y: Integer): TColor;
Function GetPCursor(mX, mY: Integer; PointOnly: Boolean): TBox;
Procedure MakeLayoutMap;
Procedure PaintLayout(x, y, Nr: Integer; dest: TCanvas);
procedure PaintLayouts;
Procedure InvPlacingEnd;
//Procedure DrawFlag(x, y, z: Word);

implementation

uses Main, Open, OpenSim, Spin, Sett, Clipping, Scene;

procedure UpdateClip(Src: TBitmap; Dest: TPaintBox);
begin
 //Dest.Canvas.CopyRect(Src.Canvas.ClipRect,Src.Canvas,Src.Canvas.ClipRect);
 With Src.Canvas.ClipRect do
  BitBlt(Dest.Canvas.Handle, Left, Top, Right-Left, Bottom-Top,
          Src.Canvas.Handle, Left, Top, SRCCOPY);
end;

procedure DrawNet(X, Y: Integer);
var a: Integer;
begin
 bufMain.Canvas.Pen.Style:= psSolid;
 for a:=0 to HighX+1 do begin
  bufMain.Canvas.MoveTo(a*24+X+24,a*12+Y+14-(HighY+1)*15);
  bufMain.Canvas.LineTo(a*24+X+24,a*12+Y+14);
  bufMain.Canvas.LineTo(a*24+X+24-(HighZ+1)*24,a*12+Y+14+(HighZ+1)*12);
 end;
 for a:=1 to HighY+1 do begin
  bufMain.Canvas.MoveTo((HighX+1)*24+X+24,(HighX+1)*12+Y+14-a*15);
  bufMain.Canvas.LineTo(X+24,Y+14-a*15);
  bufMain.Canvas.LineTo(-(HighZ+1)*24+X+24,(HighZ+1)*12+Y+14-a*15);
 end;
 for a:=0 to HighZ+1 do begin
  bufMain.Canvas.MoveTo(-a*24+X+24,a*12+Y+14-(HighY+1)*15);
  bufMain.Canvas.LineTo(-a*24+X+24,a*12+Y+14);
  bufMain.Canvas.LineTo(-a*24+X+24+(HighX+1)*24,a*12+Y+14+(HighX+1)*12);
 end;
end;

//this is the main drawing procedure
procedure DrawMap(x, y: Integer; Dest: TBitmap;
 StartX: Integer = 0; StartY: Integer = 0; StartZ: Integer = 0);
var a, b, c, pX, pY, bx, by, i: Integer;
    px1, py1, pz1, px2, py2, pz2, cx1, cy1, cx2, cy2: Integer;
    CurFrame, CurFrameA, SelFrame, MinFrames, MoveFrame, MoveCopyFrame, MvObject,
    HelpFrame, Help3D, NormFrame, NormFrameNew, Shapes, PArea, Inv, PlaceDown: Boolean;
    ShowTracks, ShowZones, ShowActors: Boolean;
    mi: TMapItem;
    Id: TBreakMapItem;
begin
 Dest.Canvas.Pen.Width:= 1;
 If (StartX = 0) and (StartY = 0) and (StartZ = 0) then begin
  Dest.Canvas.Brush.Style:= bsSolid;
  Dest.Canvas.Brush.Color:= clBlack;
  Dest.Canvas.FillRect(Dest.Canvas.ClipRect);
 end;
 With Form1 do begin
  If ((SceneMode and btScNet.Down) or (not SceneMode and btNet.Down))
  and (StartX = 0) and (StartY = 0) and (StartZ = 0) then begin
   Dest.Canvas.Pen.Color:= clWinNet;
   DrawNet(x,y);
  end;

  cx1:= Dest.Canvas.ClipRect.Left - 48;// + SceneClipL;
  cy1:= Dest.Canvas.ClipRect.Top - 37;
  cx2:= Dest.Canvas.ClipRect.Right - 1;// + SceneClipR;
  cy2:= Dest.Canvas.ClipRect.Bottom - 1;// + SceneClipR;

  MvObject:= btPlace.Down or InvPlacing or FVMoving or FHMoving or ObjCopied;
  px1:= PlacePos.x;
  py1:= PlacePos.y;
  pz1:= PlacePos.z;
  px2:= px1 + PlaceObj.x - 1;
  py2:= py1 + PlaceObj.y - 1;
  pz2:= pz1 + PlaceObj.z - 1;

  Inv:= ((SceneMode and btScShowInv.Down) or (not SceneMode and btShowInv.Down)) or btInv.Down;
  MinFrames:= (btSelect.Down or btInv.Down) and not (FHMoving or FVMoving);
  MoveFrame:= (aPlaced.Checked or btInv.Down or InvPlacing)
              and (not ObjCopied or FHMoving or FVMoving);
  MoveCopyFrame:= ObjCopied and not (FHMoving or FVMoving);
  HelpFrame:= aHelper.Checked and MvObject and (not ObjCopied or FHMoving or FVMoving);
  Help3D:= HelpFrame and a3DHelper.Checked;
  NormFrame:= ((SceneMode and btScFrames.Down) or (not SceneMode and btFrames.Down))
              and not UseNewFrames;
  NormFrameNew:= ((SceneMode and btScFrames.Down) or (not SceneMode and btFrames.Down))
                 and UseNewFrames;
  Shapes:= mViewShapes.Checked;
  CurFrameA:= aCursor.Checked;
  PlaceDown:= btPlace.Down;

  ShowTracks:= btScTracks.Down;
  ShowZones:=  btScZones.Down;
  ShowActors:= btScActors.Down;

  //pX:= x; pY:= y;
  //Inc(pX, (StartX - StartZ) * 24);
  //Inc(pY, (StartX + StartZ) * 12 - StartY * 15);
  for a:= StartX to HighX do begin
   for b:= StartY to HighY do begin
    for c:= StartZ to HighZ do begin
     pX:= x + (a - c) * 24;
     pY:= y + (a + c) * 12 - b * 15;
     If (pX>=cx1) and (pY>=cy1) and (pX<=cx2) and (pY<=cy2) then begin
      PArea:= (a>=px1) and (a<=px2) and (c>=pz1) and (c<=pz2);
      If MvObject and PArea and (b>=py1) and (b<=py2)
      and (PlaceDown or (foSelect in PlaceObj.Map[a-px1,b-py1,c-pz1].Frame)) then begin
       mi:= PlaceObj.Map[a-px1,b-py1,c-pz1];
       If MoveCopyFrame then BackFrame(pX,pY,Dest.Canvas,clSelect);
       If MoveFrame then BackFrame(pX,pY,Dest.Canvas,clPlaced);
       If not InvPlacing then begin
        {If BuffMap[mi.BrkNr]=-1 then} BufferBrick(mi.BrkNr);
        BrkBuff.Draw(Dest.Canvas,pX,pY,BuffMap[mi.BrkNr]);
        //DrawBitBrick(bitBuffers[BuffMap[mi.BrkNr]],pX,pY,Dest);
       end;
       If MoveCopyFrame then FrontFrameC(pX,pY,Dest.Canvas,clSelect);
       If MoveFrame then FrontFrameC(pX,pY,Dest.Canvas,clPlaced);
      end
      else begin
       mi:= Map[a,b,c];
       If b <= MaxLayer then begin
        If (foNormal in mi.Frame) then begin
         If NormFrame then BackFrame(pX,pY,Dest.Canvas,clMainImg)
         else if NormFrameNew then BackFrameLine(pX,pY,Dest.Canvas,clMainImg,mi.FrLines);
         If Shapes then ShapeBFrame(pX,pY,Dest.Canvas,clShapes,mi.Shape);
        end;
        If (foSelect in mi.Frame) then begin
         SelFrame:=MinFrames and not (ObjCopied or (btInv.Down and (foNormal in mi.Frame)))
                   and (a>=Select.x1) and (b>=Select.y1) and (c>=Select.z1)
                   and (a<=Select.x2) and (b<=Select.y2) and (c<=Select.z2);
         CurFrame:=CurFrameA and MinFrames and not SelFrame and not MoveAllowed
                   and (not btInv.Down or not (foNormal in mi.Frame))
                   and (a>=PCursor.x1) and (b>=PCursor.y1) and (c>=PCursor.z1)
                   and (a<=PCursor.x2) and (b<=PCursor.y2) and (c<=PCursor.z2);
         If SelFrame then BackFrame(pX,pY,Dest.Canvas,clSelect);
         If CurFrame then BackFrame(pX,pY,Dest.Canvas,clCursor);
        end;
        If (foNormal in mi.Frame) then begin
         If mi.BrkNr<>TransparentBrick then begin
          {If BuffMap[mi.BrkNr]=-1 then} BufferBrick(mi.BrkNr);
          BrkBuff.Draw(Dest.Canvas,pX,pY,BuffMap[mi.BrkNr]);
          //DrawBitBrick(bitBuffers[BuffMap[mi.BrkNr]],pX,pY,Dest);
         end;
         If NormFrame then FrontFrame(pX,pY,Dest.Canvas,clMainImg)
         else if NormFrameNew then FrontFrameLine(pX,pY,Dest.Canvas,clMainImg,mi.FrLines);
         If Shapes then ShapeFFrame(pX,pY,Dest.Canvas,clShapes,mi.Shape);
        end;
        {If SceneMode then begin
         for i:= 0 to High(BreakMap[a, b, c]) do begin
          Id:= BreakMap[a,b,c,i];
          case Id.Typ of
           1: If ShowTracks then DrawTrack(Id.Id,x,y,Dest.Canvas);
           //3: If ShowActors then DrawActor(Id.Id,x,y,Dest.Canvas);
           //If ShowZones and (Id.Zone > -1) then
           // DrawZone(Id.Zone,x,y,Dest.Canvas,True);
          end;
         end;
        end;}
        If Inv and (foSelect in mi.Frame) and not (foNormal in mi.Frame) then
         FrontFrameC(pX,pY,Dest.Canvas,clInvBrk);
        If (foSelect in mi.Frame) then begin
         If SelFrame then FrontFrameC(pX,pY,Dest.Canvas,clSelect);
         If CurFrame then FrontFrameC(pX,pY,Dest.Canvas,clCursor);
        end;
       end;
       If HelpFrame and ((PArea and (b<py1) and ((a=px2) or (c=pz2))) or
        Help3D and (((b>=py1) and (b<=py2)) and
             (((c<pz1) and (a>=px1) and (a<=px2) and ((a=px2) or (b=py2)))
          or  ((a<px1) and (c>=pz1) and (c<=pz2) and ((c=pz2) or (b=py2)))))) then
        FrontFrameC(pX,pY,Dest.Canvas,clHelper);
      end;
     end;
     //Dec(pX,24); Inc(pY,12);
    end;
    //Inc(pX,(HighZ+1)*24); Dec(pY,(HighZ+1)*12+15);
   end;
   //Inc(pX,24); Inc(pY,(HighY+1)*15+12);
  end;

  {If btScActors.Down then
   for a:=0 to High(Actors) do begin
    //If Actors[a].rX+Actors[a].Width >
    DrawActor(a,x,y,Dest.Canvas);
    for a:=
   end;}
  If btScZones.Down then
   for a:=0 to High(Zones) do
    DrawZone(a,x,y,Dest.Canvas,True);
 end;
end;

procedure DrawSceneObjects(DrawSel: Boolean = True); //Actors and Tracks
var a, b, cx1, cy1, cx2, cy2: Integer;
    DrawTracks, DrawActors: Boolean;
    AA: TSceneActor;
    TT: TSceneTrack;
begin
 DrawTracks:= Form1.btScTracks.Down;
 DrawActors:= Form1.btScActors.Down;
 cx1:= bufMain.Canvas.ClipRect.Left   - Off_X + ScrollX;
 cy1:= bufMain.Canvas.ClipRect.Top    - Off_Y + ScrollY;
 cx2:= bufMain.Canvas.ClipRect.Right  - Off_X + ScrollX;
 cy2:= bufMain.Canvas.ClipRect.Bottom - Off_Y + ScrollY;
 If DrawTracks or DrawActors then begin
  for a:= 0 to High(ObjectList) do
   If (ObjectList[a].typ = 1) and DrawTracks then begin
    TT:= Tracks[ObjectList[a].id];
    If (TT.gY <= MaxLayer) and (TT.rX+12 >= cx1) and (TT.rY >= cy1)
    and (TT.rX-22 <= cx2) and (TT.rY-64 <= cy2) then
     RedrawTrack(ObjectList[a].id,False,False);
   end
   else if (ObjectList[a].typ = 3) and DrawActors then begin
    AA:= Actors[ObjectList[a].id];
    If (AA.gY <= MaxLayer) and (AA.rX+AA.Width >= cx1) and (AA.rY+AA.Height >= cy1)
    and (AA.rX <= cx2) and (AA.rY-30 <= cy2) then
     RedrawActor(ObjectList[a].id,False,False);
   end;
  If DrawSel then DrawSelection;
 end;
end;

procedure DrawMapA(dx: Integer = 0; dy: Integer = 0);
begin
 If not Form1.pbGrid.Visible then Exit;
 DrawMap(Off_X-Form1.HScr.Position-dx,Off_Y-Form1.VScr.Position-dy,bufMain);
 If SceneMode then DrawSceneObjects;
 Form1.pbThumbPaint(Form1);
 UpdateImage(bufMain,Form1.pbGrid);
end;

procedure DrawPiece(x, y, width, height: Integer; DrawMode: TDrawMode = dmNormal;
 ThumbRepnt: Boolean = True; DrawObjs: Boolean = True; DrawSel: Boolean = True;
 UpdClip: Boolean = True;
 StartX: Integer = 0; StartY: Integer = 0; StartZ: Integer = 0);
var NewClip: HRGN;
begin
 If not Form1.pbGrid.Visible then Exit;
 If DrawMode = dmMerge then
  NewClip:= CreateRectRgn(Min(x-Form1.HScr.Position,FrDrawRgn.Left),
                          Min(y-Form1.VScr.Position,FrDrawRgn.Top),
                          Max(x+width-Form1.HScr.Position,FrDrawRgn.Right),
                          Max(y+height-Form1.VScr.Position,FrDrawRgn.Bottom))
 else
  NewClip:= CreateRectRgn(x-Form1.HScr.Position,y-Form1.VScr.Position,
                          x+width-Form1.HScr.Position,y+height-Form1.VScr.Position);

 SelectClipRgn(bufMain.Canvas.Handle,NewClip);
 If DrawMode = dmRemember then FrDrawRgn:= bufMain.Canvas.ClipRect
 else begin
  DrawMap(Off_X-Form1.HScr.Position,Off_Y-Form1.VScr.Position,bufMain,
          StartX, StartY, StartZ);
  If SceneMode then begin
   If DrawObjs then DrawSceneObjects(DrawSel);
   If DrawSel then DrawSelection;
  end; 
  If UpdClip then UpdateClip(bufMain,Form1.pbGrid);
  If ThumbRepnt then Form1.pbThumbPaint(Form1);
 end;
 {Form1.pbGrid.Canvas.FrameRect(         //for testing only
  Rect(x-Form1.HScr.Position,y-Form1.VScr.Position,
  x+width-Form1.HScr.Position,y+height-Form1.VScr.Position)); }
 SelectClipRgn(bufMain.Canvas.Handle,0);
 DeleteObject(NewClip);
end;

procedure DrawPieceBrk(x, y, z, dx, dy, dz: Integer; Mode: TDrawMode = dmNormal;
 Helper: Boolean = False; ThumbRepaint: Boolean = True);
begin
 If Helper and Form1.aHelper.Checked then begin
  dy:=dy+y; y:=0;
  If Form1.a3DHelper.Checked then begin
   dx:=dx+x; x:=0;
   dz:=dz+z; z:=0;
  end;
 end;
 DrawPiece((x-z-dz+1)*24+Off_X,(x+z)*12-(y+dy-1)*15+Off_Y-1,(dx+dz)*24+1,dy*15+(dx+dz)*12+1,
  Mode, ThumbRepaint);
end;

procedure ScrollMap(dx, dy: Integer); // + left; - right
var NewClip: HRGN;
    h, w, a: Integer;
begin
 With Form1 do begin
  If not pbGrid.Visible then Exit;
  If not HScr.Enabled then dx:= 0;
  If not VScr.Enabled then dy:= 0;
  If (dx > HScr.Max-ScrollX-HScr.PageSize+1) then dx:= HScr.Max-ScrollX-HScr.PageSize+1;
  If (dx < - ScrollX) then dx:= - ScrollX;
  If (dy > VScr.Max-ScrollY-VScr.PageSize+1) then dy:= VScr.Max-ScrollY-VScr.PageSize+1;
  If (dy < - ScrollY) then dy:= - ScrollY;
  If (dx = 0) and (dy = 0) then Exit;
  If (dx >= bufMain.Width) or (dy >= bufMain.Height) then DrawMapA(dx,dy)
  else begin
   h:= bufMain.Height;
   w:= bufMain.Width;
   BitBlt(bufMain.Canvas.Handle,Max(0,-dx),Max(0,-dy),w-dx,h-dy,
          bufMain.Canvas.Handle,Max(dx,0),Max(dy,0),SRCCOPY);
   for a:= 0 to 1 do begin
    If a = 0 then NewClip:= CreateRectRgn(IfThen(dx>0,w-dx),0,IfThen(dx>0,w,-dx),h)
    else NewClip:= CreateRectRgn(IfThen(dx<0,-dx),IfThen(dy>0,h-dy),IfThen(dx<0,w,w-dx),IfThen(dy>0,h,-dy));
    SelectClipRgn(bufMain.Canvas.Handle,NewClip);
    DrawMap(Off_X-ScrollX-dx, Off_Y-ScrollY-dy, bufMain);
    SelectClipRgn(bufMain.Canvas.Handle,0);
    DeleteObject(NewClip);
   end;
   If HScr.Enabled then HScr.Position:= ScrollX + dx;
   If VScr.Enabled then VScr.Position:= ScrollY + dy;
   If SceneMode then DrawSceneObjects;
   UpdateImage(bufMain,pbGrid);
  end;
 end;
end;

Procedure BufferBricks(Lib: TLibrary; Brk: TPackEntries);
var a, b, BrkNum: Integer;      //only check if layouts and bricks are consistent
begin
 Form1.BrkBuff.Clear;
 SetLength(BuffMap,Length(Brk)+1);
 for a:=1 to High(BuffMap) do BuffMap[a]:=-1;
 BuffMap[0]:=-2;
 for a:=1 to High(Lib) do begin
  for b:=0 to High(Lib[a].Map) do begin
   BrkNum:=Lib[a].Map[b].Index-1;
   If High(Brk)<BrkNum then begin
    MessageBox(ProgBarForm.Handle,'One or more Layouts refer to a Brick that doesn''t exist! This usually happens if you select a Library from LBA 2 and Brick package from LBA 1. No files will be opened.',ProgramName,MB_ICONERROR+MB_OK);
    ProgBarForm.CloseSpecial;
    Abort;
   end;
  end;
 end;
end;

//exchanges R with B by the way
Function Average(v: array of TColor): TColor;
var a, c: Integer;
    r, g, b: Integer;
begin
 Result:=0;
 r:=0; g:=0; b:=0;
 c:=0;
 for a:=0 to 3 do
  If v[a]>clBlack then begin
   r:=r+(v[a] and $FF);
   g:=g+((v[a] div 256) and $FF);
   b:=b+((v[a] div (256*256)) and $FF);
   Inc(c);
  end;
 If c>0 then Result:=(b div c)+((g div c)*256)+((r div c)*256*256);
end;

Procedure CreateThumbnail(x1: Byte = 0; y1: Byte = 0; x2: Byte = 151; y2: Byte = 95);
var a, b: Integer;
begin
 If x1 < 0 then x1:= 0;
 If y1 < 0 then y1:= 0;
 If x2 > 151 then x2:= 151;
 If y2 > 95 then y2:= 95;
 for b:=y1 to y2 do
  for a:=x1 to x2 do begin
   DWord(Pointer(Integer(bufThumb.ScanLine[b])+a*3)^):=
    Average([PixelOfScreen((a*2)*ImageW div 304-Off_X-24,(b*2)*ImageH div 192-Off_Y),
    PixelOfScreen((a*2+1)*ImageW div 304-Off_X-24,(b*2)*ImageH div 192-Off_Y),
    PixelOfScreen((a*2)*ImageW div 304-Off_X-24,(b*2+1)*ImageH div 192-Off_Y),
    PixelOfScreen((a*2+1)*ImageW div 304-Off_X-24,(b*2+1)*ImageH div 192-Off_Y)]);
  end;
end;

Procedure UpdateThumbnail(x1, y1, z1, x2, y2, z2: Integer);
var rX1, rY1, rX2, rY2: Integer;
begin
 rX1:=(x1-z2)*24+Off_X;
 rY1:=(x1+z1)*12-y2*15+Off_Y-1;
 rX2:=(x2-z1+2)*24+Off_X+1;
 rY2:=(x2+z2+2)*12-(y1-1)*15+Off_Y-1;
 CreateThumbnail((rX1*152) div ImageW,(rY1*96) div ImageH,
                 (rX2*152) div ImageW+1,(rY2*96) div ImageH+1);
end;

Procedure UpdateThumbBack;
begin
 If Form1.ThumbTimer.Enabled then ThumbCounter:=0
 else Form1.ThumbTimer.Enabled:=True;
end;

Function FindLayout(x, y, z: Integer): TBox;
var lt: Integer;
begin
 Result:= BoxPoint(-1,-1,-1);
 lt:= Map[x,y,z].Idx.Lt;
 If lt > 0 then begin
  Result:= BoxPoint(x,y,z);
  while (Result.x1 > 0)     and (Map[Result.x1-1,y,z].Idx.Lt = lt) do Dec(Result.x1);
  while (Result.x2 < HighX) and (Map[Result.x2+1,y,z].Idx.Lt = lt) do Inc(Result.x2);
  while (Result.y1 > 0)     and (Map[x,Result.y1-1,z].Idx.Lt = lt) do Dec(Result.y1);
  while (Result.y2 < HighY) and (Map[x,Result.y2+1,z].Idx.Lt = lt) do Inc(Result.y2);
  while (Result.z1 > 0)     and (Map[x,y,Result.z1-1].Idx.Lt = lt) do Dec(Result.z1);
  while (Result.z2 < HighZ) and (Map[x,y,Result.z2+1].Idx.Lt = lt) do Inc(Result.z2);
 end
 else if Map[x,y,z].Idx.Brk = 1 then begin
  Result:= BoxPoint(x,y,z);
  while (Result.x1>0)     and (Map[Result.x1-1,y,z].Idx.Lt=0) and (Map[Result.x1-1,y,z].Idx.Brk=1) do Dec(Result.x1);
  while (Result.x2<HighX) and (Map[Result.x2+1,y,z].Idx.Lt=0) and (Map[Result.x2+1,y,z].Idx.Brk=1) do Inc(Result.x2);
  while (Result.y1>0)     and (Map[x,Result.y1-1,z].Idx.Lt=0) and (Map[x,Result.y1-1,z].Idx.Brk=1) do Dec(Result.y1);
  while (Result.y2<HighY) and (Map[x,Result.y2+1,z].Idx.Lt=0) and (Map[x,Result.y2+1,z].Idx.Brk=1) do Inc(Result.y2);
  while (Result.z1>0)     and (Map[x,y,Result.z1-1].Idx.Lt=0) and (Map[x,y,Result.z1-1].Idx.Brk=1) do Dec(Result.z1);
  while (Result.z2<HighZ) and (Map[x,y,Result.z2+1].Idx.Lt=0) and (Map[x,y,Result.z2+1].Idx.Brk=1) do Inc(Result.z2);
 end;
end;

procedure GetBrick(X, Y, L: Integer; var gX, gZ: Integer);
begin
 gX:=((X+2+((Y+L*15)*2)) div 48);
 gZ:=((-X+1+((Y+L*15)*2)) div 48);
end;

Function PixelOfScreenVal(X, Y: Integer; Full, Inv: Boolean): Byte;
var gX, gZ, oX, oY, oY2, MaxLayer: Integer;
    mi: TMapItem;
begin
 Result:= 0;
 FneDone:= False;
 MaxLayer:= TryToConvert(Form1.seToLayer);

 If (X>-HighZ*24-24-3) and (X<HighX*24+24+3) //granice pionowe
 and (X>(-Y-Off_Y)*2+32) and (X<(Y+Off_Y)*2-32)
 and (X>(Y-Off_X)*2-41) and (X<(-Y-Off_X+ImageW)*2-55) then begin
  Y:=Y*2+HighY*30+30;
  for CoLayer:=HighY downto 0 do begin
   Dec(Y,30);
   If not Full and (CoLayer>MaxLayer) then Continue;
   gX:=(X+2+Y) div 48;
   gZ:=(-X+1+Y) div 48;
   oX:=X-(gX-gZ)*24+24;
   oY:=(Y div 2)-(gX+gZ)*12;
   oY2:=oY*2;
   If (oY2<-oX+22) or (oY2<oX-25) then Break;
   Coords[0,0]:=gX;  // grid X
   Coords[0,1]:=gZ;  // grid Y
   Coords[0,2]:=oX;  // offset X
   Coords[0,3]:=oY;  // offset Y
   If ((oX<24) and (oY2>=22-oX) and (oY2<=51-oX))
   or ((oX>=24) and (oY2>=oX-25) and (oY2<=oX+4)) then begin
    If oX<24 then begin
     Coords[1,0]:=gX-1;
     Coords[1,1]:=gZ;
     Coords[1,2]:=oX+24;
    end
    else begin
     Coords[1,0]:=gX;
     Coords[1,1]:=gZ-1;
     Coords[1,2]:=oX-24;
    end;
    Coords[1,3]:=oY+12;
    If ((oX<24) and (oY2>=-22-oX) and (oY2<=oX+6))
    or ((oX>=24) and (oY2>=oX-25) and (oY2<=54-oX)) then begin
     Coords[2,0]:=gX-1;
     Coords[2,1]:=gZ-1;
     Coords[2,2]:=oX;
     Coords[2,3]:=oY+24;
    end
    else Coords[2,0]:=-1;
   end
   else begin
    Coords[1,0]:=-1;
    Coords[2,0]:=-1;
   end;

   For CoIndex:=0 to 2 do begin
    If (Coords[CoIndex,0]<0) or (Coords[CoIndex,0]>HighX) or (Coords[CoIndex,1]<0) or (Coords[CoIndex,1]>HighZ) then Continue;
    mi:=Map[Coords[CoIndex,0],CoLayer,Coords[CoIndex,1]];
    If not FneDone and (foSelect in mi.Frame) and not (Inv and (foNormal in mi.Frame)) then begin
     FneCoords[0]:=Coords[CoIndex,0];
     FneCoords[1]:=CoLayer;
     FneCoords[2]:=Coords[CoIndex,1];
     FneDone:=True;
    end;
    If not Inv then begin
     If mi.BrkNr<1 then Continue;
     Result:=PixelOfBrick(Coords[CoIndex,2],Coords[CoIndex,3],mi.BrkNr-1);
     If Result>0 then Exit;
    end
    else if FneDone then Exit;
   end;
  end;
 end;
 If not FneDone then FneCoords[0]:=-1;
end;

Function PixelOfScreen(X, Y: Integer): TColor;
begin
 Result:= Palette[PixelOfScreenVal(X,Y,True,False)];
end;

Function GetPCursor(mX, mY: Integer; PointOnly: Boolean): TBox;
var a: Integer;
    Fnt, FullMap, Inv: Boolean;
begin
 Fnt:= Form1.btSelFnt.Down or PointOnly; //PointOnly in SceneMode only :)
 FullMap:= not ((    SceneMode and Form1.btScToLayer.Down)
             or (not SceneMode and Form1.btToLayer.Down));
 Inv:= ((    SceneMode and Form1.btScShowInv.Down)
     or (not SceneMode and Form1.btShowInv.Down)) or Form1.btInv.Down;
 a:= PixelOfScreenVal(mX - Off_X + ScrollX - 24,
                      mY - Off_Y + ScrollY,
                      FullMap, Inv);
 If (Fnt and (a > 0)) or ((not Fnt or Inv) and (FneCoords[0] > -1)) then begin
  If Fnt then begin
   FneCoords[0]:= Coords[CoIndex,0];
   FneCoords[1]:= CoLayer;
   FneCoords[2]:= Coords[CoIndex,1];
  end;
  If PointOnly or ((Form1.btSelect.Down and Form1.btSelBrk.Down)
  or (Form1.btInv.Down and Form1.btInvBrk.Down)) then
   Result:= BoxPoint(FneCoords[0],FneCoords[1],FneCoords[2])
  else if Form1.btSelCol.Down then
   Result:= Box(FneCoords[0],0,FneCoords[2],FneCoords[0],HighY,FneCoords[2])
  else if ((Form1.btSelect.Down and Form1.btSelObj.Down)
  or (Form1.btInv.Down and Form1.btInvObj.Down)) and not Selecting then
   Result:= FindLayout(FneCoords[0],FneCoords[1],FneCoords[2]);
 end
 else Result:= BoxPoint(-1,-1,-1);
end;

Procedure MakeLayoutMap;
var a: Integer;
begin
 SetLength(LayoutMap,Length(VLibrary));
 LayoutMap[0]:= 0;
 for a:=1 to High(VLibrary) do
  LayoutMap[a]:= LayoutMap[a-1] + GetLtHeight(VLibrary[a]) + 3;
end;

Procedure PaintLayout(x, y, Nr: Integer; dest: TCanvas);
var a, dX, dY, dZ, pX, pY: Integer;
    Lt: TLayout;
begin
 If Length(VLibrary) < 1 then Exit;
 Lt:= VLibrary[Nr];
 for a:= 0 to Lt.X*Lt.Y*Lt.Z - 1 do begin
  dX:= a mod Lt.X;
  dY:= (a div Lt.X) mod Lt.Y;
  dZ:= (a div Lt.X) div Lt.Y;
  GridToPosVar(dX,dY,dZ,(Lt.Z-1)*24+x,(Lt.Y-1)*15+1+y,pX,pY);
  If Form1.cbFramesL.Checked then BackFrame(pX,pY,dest,clPanel);
  If Lt.Map[a].Index > 0 then begin
   If Lt.Map[a].Index <> TransparentBrick then begin
    If BuffMap[Lt.Map[a].Index]= -1 then BufferBrick(Lt.Map[a].Index);
    Form1.BrkBuff.Draw(Dest,pX,pY,BuffMap[Lt.Map[a].Index]);
   end;
  end;
  If Form1.cbFramesL.Checked then FrontFrame(pX,pY,dest,clPanel);
 end;
end;

procedure PaintLayouts;
var a: Integer;
begin
 If Length(VLibrary) < 1 then Exit;
 With Form1 do begin
  imgLts.Canvas.Brush.Color:= clBtnFace;
  imgLts.Canvas.FillRect(imgLts.Canvas.ClipRect);
  MakeLayoutMap;
  for a:=1 to High(VLibrary) do begin
   If LayoutMap[a]-LScr.Position<0 then Continue;
   If LayoutMap[a-1]-LScr.Position>imgLts.Height then Continue;
   If a=LtSel then begin
    imgLts.Canvas.Brush.Color:=clSkyBlue;
    imgLts.Canvas.FillRect(Rect(0,LayoutMap[a-1]-LScr.Position-1,
     imgLts.Width,LayoutMap[a]-LScr.Position-2));
   end;
   PaintLayout(0,LayoutMap[a-1]-LScr.Position,a,imgLts.Canvas);
   imgLts.Canvas.Pen.Color:=clBtnShadow;
   imgLts.Canvas.MoveTo(0,LayoutMap[a]-LScr.Position-2);
   imgLts.Canvas.LineTo(imgLts.Width,LayoutMap[a]-LScr.Position-2);
  end;
  UpdateImage(imgLts,Form1.pbLts);
 end;
end;

Procedure InvPlacingEnd;
begin
 InvPlacing:=False;
 DrawPieceBrk(PlacePos.x,PlacePos.y,PlacePos.z,PlaceObj.X,PlaceObj.Y,PlaceObj.Z,dmNormal,True);
 Form1.btInvNew.Caption:='Create';
 Form1.seX.Enabled:=True;
 Form1.seY.Enabled:=True;
 Form1.seZ.Enabled:=True;
end;

end.
