unit CompDialog;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TCompForm = class(TForm)
    Label1: TLabel;
    rbComp0: TRadioButton;
    rbComp1: TRadioButton;
    rbComp2: TRadioButton;
    btOK: TButton;
    btCancel: TButton;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  CompForm: TCompForm;

function SaveCompDialog(Lba2: Boolean; OrigComp: Word; out Comp: Word): Boolean;

implementation

uses Sett, Main;

{$R *.dfm}

function SaveCompDialog(Lba2: Boolean; OrigComp: Word; out Comp: Word): Boolean;
var ShowDialog: Boolean;
begin
 ShowDialog:=False;
 Result:=True;
 If Lba2 then begin
  If SetForm.cbUseComp2.Checked then begin
   case RadioToIndex(Setform,'rbComp2%d',0,3) of
    1: Comp:=1;
    2: Comp:=2;
    3: ShowDialog:=True;
    else Comp:=OrigComp;
   end;
  end
  else Comp:=0;
 end
 else begin
  If SetForm.cbUseComp1.Checked then begin
   case RadioToIndex(Setform,'rbComp1%d',0,2) of
    1: Comp:=1;
    2: ShowDialog:=True;
    else Comp:=OrigComp;
   end;
  end
  else Comp:=0;
 end;

 If ShowDialog then begin
  CompForm:=TCompForm.Create(Form1);
  try
   CompForm.rbComp2.Visible:=Lba2;
   Case OrigComp of
    1: CompForm.rbComp1.Checked:=True;
    2: If Lba2 then CompForm.rbComp2.Checked:=True else CompForm.rbComp0.Checked:=True;
    else CompForm.rbComp0.Checked:=True;
   end;
   If CompForm.ShowModal=mrOK then
    comp:=RadioToIndex(CompForm,'rbComp%d',0,2)
   else Result:=False;
  except
   Result:=False;
  end;
  CompForm.Free;
 end;
end;

end.
