//******************************************************************************
// Little Big Architect: Builder - editing grid files containing rooms in
//                                 Little Big Adventure 1 & 2
//
// Main unit.
// Main program unit. Contains main form's events.
//
// Copyright Zink
// e-mail: zink@poczta.onet.pl
// See the GNU General Public License (License.txt) for details.
//******************************************************************************

unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, DePack, Engine, ExtCtrls, Spin, Buttons, StrUtils,
  BEngine, ImgList, ActnList, ToolWin, Math, jpeg, Menus, Grids,
  Clipping, Bricks, Scenario;

type 
  TForm1 = class(TForm)
    DlgOpen: TOpenDialog;
    DlgSave: TSaveDialog;
    BrkBuff: TImageList;
    ActionList: TActionList;
    aOpen: TAction;
    aNew: TAction;
    aExit: TAction;
    aSettings: TAction;
    aExport: TAction;
    aSaveAs: TAction;
    Splitter1: TSplitter;
    paLayout: TPanel;
    LScr: TScrollBar;
    pbLts: TPaintBox;
    imgLts: TImage;
    paMain: TPanel;
    paGrid: TPanel;
    pbGrid: TPaintBox;
    VScr: TScrollBar;
    HScr: TScrollBar;
    paHint: TPanel;
    Label8: TLabel;
    aHints: TAction;
    aHelper: TAction;
    aOpenSim: TAction;
    Timer: TTimer;
    aPlaced: TAction;
    frClipping: TClipFrame;
    paTools: TPanel;
    Bevel2: TBevel;
    pbThumb: TPaintBox;
    aCursor: TAction;
    aUndo: TAction;
    aRedo: TAction;
    imgAxes: TImage;
    paCoords: TPanel;
    lbCoords: TLabel;
    paAdv: TPanel;
    Label1: TLabel;
    Label13: TLabel;
    seAX: TSpinEdit;
    Label14: TLabel;
    seAY: TSpinEdit;
    Label15: TLabel;
    seAZ: TSpinEdit;
    btAlX0: TSpeedButton;
    btAlZ2: TSpeedButton;
    btAlY1: TSpeedButton;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Edit1: TMenuItem;
    View1: TMenuItem;
    New1: TMenuItem;
    Opensimple1: TMenuItem;
    Openadvanced1: TMenuItem;
    Saveas1: TMenuItem;
    N1: TMenuItem;
    Exporttobitmap1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    Undo1: TMenuItem;
    Redo1: TMenuItem;
    Undo2: TMenuItem;
    Hintbox1: TMenuItem;
    Buttons: TImageList;
    ThumbTimer: TTimer;
    imgFlag: TImage;
    Button1: TButton;
    aSave: TAction;
    Save1: TMenuItem;
    N4: TMenuItem;
    paSplash: TPanel;
    paDummy: TPanel;
    Image1: TImage;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    lbVersion: TLabel;
    Label7: TLabel;
    est1: TMenuItem;
    mViewShapes: TMenuItem;
    a3DHelper: TAction;
    imgActor: TImage;
    FrameList: TImageList;
    mAbout: TMenuItem;
    pcControls: TPageControl;
    tsNormal: TTabSheet;
    tsScene: TTabSheet;
    GroupBox4: TGroupBox;
    btInv: TSpeedButton;
    btSelect: TSpeedButton;
    btPlace: TSpeedButton;
    btHand: TSpeedButton;
    btUndo: TSpeedButton;
    btRedo: TSpeedButton;
    btDelete: TSpeedButton;
    seToLayer: TSpinEdit;
    ToolOpts: TPageControl;
    SelOpts: TTabSheet;
    GroupBox5: TGroupBox;
    btSelBrk: TSpeedButton;
    btSelCol: TSpeedButton;
    btSelObj: TSpeedButton;
    btSelFnt: TSpeedButton;
    btSelFne: TSpeedButton;
    cbCursor: TCheckBox;
    cbHelper1: TCheckBox;
    CheckBox1: TCheckBox;
    CheckBox5: TCheckBox;
    PlaceOpts: TTabSheet;
    GroupBox3: TGroupBox;
    Label6: TLabel;
    sePlace: TSpinEdit;
    cbFramesP: TCheckBox;
    cbFramesL: TCheckBox;
    cbHelper: TCheckBox;
    CheckBox6: TCheckBox;
    InvOpts: TTabSheet;
    GroupBox7: TGroupBox;
    btInvBrk: TSpeedButton;
    btInvObj: TSpeedButton;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    GroupBox8: TGroupBox;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    btinvNew: TButton;
    seX: TSpinEdit;
    seY: TSpinEdit;
    seZ: TSpinEdit;
    CheckBox2: TCheckBox;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    GroupBox6: TGroupBox;
    cbScZone0: TCheckBox;
    cbScZone1: TCheckBox;
    cbScZone2: TCheckBox;
    cbScZone3: TCheckBox;
    cbScZone4: TCheckBox;
    cbScZone5: TCheckBox;
    cbScZone6: TCheckBox;
    btSelAll: TBitBtn;
    btSelNone: TBitBtn;
    btScHand: TSpeedButton;
    btScEdit: TSpeedButton;
    btFrames: TSpeedButton;
    btNet: TSpeedButton;
    btToLayer: TSpeedButton;
    btCoords: TSpeedButton;
    btShowInv: TSpeedButton;
    btScShowInv: TSpeedButton;
    btScCoords: TSpeedButton;
    btScNet: TSpeedButton;
    btScFrames: TSpeedButton;
    btScToLayer: TSpeedButton;
    seScToLayer: TSpinEdit;
    btScTracks: TSpeedButton;
    btScZones: TSpeedButton;
    btScActors: TSpeedButton;
    btScClip: TSpeedButton;
    lbEditingEnabled: TLabel;
    btScAddTrack: TSpeedButton;
    btScAddActor: TSpeedButton;
    aOpenScen: TAction;
    aExportScen: TAction;
    N5: TMenuItem;
    mOpenScen: TMenuItem;
    ExporttoaScenario1: TMenuItem;
    N6: TMenuItem;
    mScenProp: TMenuItem;
    aScenProp: TAction;
    N7: TMenuItem;
    procedure pbGridMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure pbGridMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure pbGridMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure VScrScroll(Sender: TObject; ScrollCode: TScrollCode;
      var ScrollPos: Integer);
    procedure FormResize(Sender: TObject);
    procedure pbGridPaint(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btToLayerClick(Sender: TObject);
    procedure aOpenExecute(Sender: TObject);
    procedure aSettingsExecute(Sender: TObject);
    procedure pbThumbPaint(Sender: TObject);
    procedure aExportExecute(Sender: TObject);
    procedure pbThumbMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure pbThumbMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure aExitExecute(Sender: TObject);
    procedure pbLtsPaint(Sender: TObject);
    procedure LScrChange(Sender: TObject);
    procedure pbLtsMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Splitter1CanResize(Sender: TObject; var NewSize: Integer;
      var Accept: Boolean);
    procedure btHandClick(Sender: TObject);
    procedure aHintsExecute(Sender: TObject);
    procedure btHandMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure aSaveAsExecute(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure aNewExecute(Sender: TObject);
    procedure aOpenSimExecute(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure btinvNewClick(Sender: TObject);
    procedure FormMouseWheel(Sender: TObject; Shift: TShiftState;
      WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
    procedure aUndoExecute(Sender: TObject);
    procedure aRedoExecute(Sender: TObject);
    procedure cbCoordsClick(Sender: TObject);
    procedure lbCoordsClick(Sender: TObject);
    procedure btDeleteClick(Sender: TObject);
    procedure btAlX0Click(Sender: TObject);
    procedure seAXChange(Sender: TObject);
    procedure seToLayerChange(Sender: TObject);
    procedure ThumbTimerTimer(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure aSaveExecute(Sender: TObject);
    procedure mViewShapesClick(Sender: TObject);
    procedure mAboutClick(Sender: TObject);
    procedure cbScTracksClick(Sender: TObject);
    procedure btSelAllClick(Sender: TObject);
    procedure btScHandClick(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure aOpenScenExecute(Sender: TObject);
    procedure aExportScenExecute(Sender: TObject);
    procedure aScenPropExecute(Sender: TObject);
    procedure btSelObjClick(Sender: TObject);
    procedure VScrChange(Sender: TObject);
  private
    procedure CopyData(var Msg: TWMCopyData); message WM_COPYDATA;
  public
    procedure AppException(Sender: TObject; E: Exception);
  end;

const
 crHand = 22;
 ProgramName = 'Little Grid Builder';
 MaxUndo = 20; //Observe that large undo limit values can significantly increase
               //memory usage
var
  Form1: TForm1;
  bufMain: TBitmap;
  bufThumb: TBitmap;

  Panning: Boolean = False;
  StartPoint: TPoint;
  GStartPoint: TPoint; //start point for the whole moving (reset on the mouse down)
  PCursor: TBox = (x1: -1; y1: -1; z1: -1; x2: -1; y2: -1; z2: -1);
  LastPCursor: TBox = (x1: -1; y1: -1; z1: -1; x2: -1; y2: -1; z2: -1);
  Select: TBox = (x1: -1; y1: -1; z1: -1; x2: -1; y2: -1; z2: -1);
  LastSelect: TBox = (x1: -1; y1: -1; z1: -1; x2: -1; y2: -1; z2: -1);
  SelStart: TBox = (x1: -1; y1: -1; z1: -1; x2: -1; y2: -1; z2: -1);
  LastPlacePos: TPoint3d = (x: -1000; y: -1000; z: -1000);
  LastLtPos: Integer = 100;
  LtAlwaysOn: Boolean = False;
  Modified: Boolean = False;

  Placing: Boolean = False;
  StartVert: Integer;
  VMoving: Boolean = False;
  Selecting: Boolean = False;
  MoveAllowed: Boolean = False;
  FHMoving: Boolean = False;
  FVMoving: Boolean = False;
  MvOrigin: TPoint;
  InvPlacing: Boolean = False;
  ObjCopied: Boolean = False;

  SceneMvType: Byte = 0; //0 - none, 1 - moving track, 3 - moving actor
  SceneVertMoving: Boolean;
  SceneMvId: Byte;
  ScenePrevBtn: TSpeedButton;

  KeyHandled: Boolean = False;
  ZoneSelecting: Boolean = False;

  UndoArray: array[1..MaxUndo] of TGridMap;
  RedoMap: TGridMap;
  LastUndo: Integer = 0;
  FirstRedo: Integer = 0;

procedure SetUndo;

implementation

uses ProgBar, Open, Sett, Hints, OpenSim, Scene, About, ScenProp;

{$R *.dfm}

procedure TForm1.pbGridMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var a, rX, rY, rZ: Integer;
    NewType, NewId: Byte;
begin
 If SceneMode then begin
  Panning:= btScHand.Down or (Button = mbMiddle);
  If BackCommEnabled then begin
   If btScEdit.Down then begin
    If PositionInside(X - Off_X + ScrollX, Y - Off_Y + ScrollY, SelType, SelId)
    then begin
     SceneMvType:= SelType;
     SceneMvId:= SelId;
     SceneVertMoving:= Button = mbRight;
     If (SelType = 3) and (Button = mbLeft) and (ssCtrl in Shift) then begin
      If Length(Actors) < 256 then begin
       If SendBackCommand(35, SelId,
           Actors[SelId].x, Actors[SelId].y, Actors[SelId].z, 0, 0, 0) then begin
        SetActor(Length(Actors), Actors[SceneMvId].x, Actors[SceneMvId].y,
         Actors[SceneMvId].z, IntToStr(Length(Actors)), Actors[SceneMvId].SpriteIndex,
         Actors[SceneMvId].cX1, Actors[SceneMvId].cY1,
         Actors[SceneMvId].cX2, Actors[SceneMvId].cY2);
        SelId:= High(Actors);
        SceneMvId:= SelId;
       end
      end
      else MessageBox(Handle,'No more Actors can be created','Little Big Architect',MB_ICONWARNING+MB_OK);
     end;
    end
    else begin
     NewId:= GetObjectAtCursor(X,Y,btScTracks.Down,btScActors.Down,False,NewType);
     SelectObject(NewType,NewId);
    end;
   end
   else if btScAddTrack.Down and (Button = mbLeft) then begin
    If Length(Tracks) < 256 then begin
     PCursor:= GetPCursor(X, Y, True);
     If (PCursor.x1 > -1) and BoxIsPoint(PCursor) then begin
      MouseToScene(X-Off_X+HScr.Position-24, Y-Off_Y+VScr.Position, rX, rY, rZ);
      SendBackCommand(13, Length(Tracks), rX, rY, rZ, 0, 0, 0);
      //SetTrack(Length(Tracks), rX, rY, rZ, IntToStr(Length(Tracks)));
     end;
    end
    else MessageBox(Handle,'No more Tracks can be created','Little Big Architect',MB_ICONWARNING+MB_OK);
   end
   else if btScAddActor.Down and (Button = mbLeft) then begin
    If Length(Actors) < 256 then begin
     PCursor:= GetPCursor(X, Y, True);
     If (PCursor.x1 > -1) and BoxIsPoint(PCursor) then begin
      MouseToScene(X-Off_X+HScr.Position-24, Y-Off_Y+VScr.Position, rX, rY, rZ);
      SendBackCommand(33, Length(Actors), rX, rY, rZ, 0, 0, 0);
      //SetActor(Length(Actors), rX, rY, rZ, IntToStr(Length(Actors)),0,0,0,0,0);
     end;
    end
    else MessageBox(Handle,'No more Actors can be created','Little Big Architect',MB_ICONWARNING+MB_OK);
   end;
  end;
 end
 else begin
  Panning:= btHand.Down or (Button = mbMiddle);
  Placing:= (btPlace.Down or InvPlacing) and (Button = mbLeft);
  VMoving:= (btPlace.Down or InvPlacing) and (Button = mbRight);
  Selecting:= (btSelect.Down or btInv.Down) and not MoveAllowed and (Button <> mbMiddle);
  If Selecting then begin
   ObjCopied:= False;
   Select:= PCursor; SelStart:= Select;
   If LastSelect.x1 > -1 then
    DrawPieceBrk(LastSelect.x1,LastSelect.y1,LastSelect.z1,LastSelect.x2-LastSelect.x1+1,
     LastSelect.y2-LastSelect.y1+1,LastSelect.z2-LastSelect.z1+1,dmRemember);
    DrawPieceBrk(Select.x1,Select.y1,Select.z1,Select.x2-Select.x1+1,
    Select.y2-Select.y1+1,Select.z2-Select.z1+1,dmMerge);
   LastSelect:= Select;
  end;
  FHMoving:= (btSelect.Down or btInv.Down) and MoveAllowed and (Button = mbLeft);
  FVMoving:= (btSelect.Down or btInv.Down) and MoveAllowed and (Button = mbRight);
  If FHMoving or FVMoving then begin
   MvOrigin:= GridToPos(Select.x1,Select.y1,Select.z1,-X,-Y);
   SetUndo;
   If not (ssCtrl in Shift) then PutPiece(PlacePos.x,PlacePos.y,PlacePos.z,BufObj,False);
   DrawPieceBrk(Select.x1,Select.y1,Select.z1,Select.x2-Select.x1+1,
    Select.y2-Select.y1+1,Select.z2-Select.z1+1,dmNormal,True);
  end;
  StartVert:= StrToIntDef(sePlace.Text,0);
 end;
 StartPoint:= Point(X,Y);
 LastSnapDelta:= Point3d(128,128,128);
 UpdateCoords(X - Off_X + ScrollX - 24, Y - Off_Y + ScrollY);
end;

procedure TForm1.pbGridMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var gX, gZ, PlaceLayer, a, rX, rY: Integer;
begin
 If not ((ssMiddle in Shift) or (ssLeft in Shift)) then Panning:= False;
 If not ((ssLeft in Shift) or (ssRight in Shift)) then SceneMvType:= 0;
 If (SceneMode and btScHand.Down) then PutHint(55) //Left hold and move + shift
 else if not SceneMode and btHand.Down then PutHint(5); //Left hold and move
 If Panning then begin
  ScrollMap(-(X-StartPoint.X), -(Y-StartPoint.Y));
  StartPoint:= Point(X,Y);
  Form1.pbThumbPaint(Form1);
 end;
 If SceneMode then begin
  If btScEdit.Down then PutHint(75)
  else if btScAddTrack.Down then PutHint(76);
  If ((X <> StartPoint.X) or (Y <> StartPoint.Y)) then begin
   MoveObject(SceneMvType, SceneMvId, X - StartPoint.X, Y - StartPoint.Y, SceneVertMoving);
   StartPoint:= Point(X, Y);
   If not btScHand.Down then begin
    PCursor:= GetPCursor(X, Y, True);
    UpdateCoords(X-Off_X+ScrollX-24, Y-Off_Y+ScrollY);
   end;
  end;
 end
 else begin
  If btPlace.Down or InvPlacing then begin
   PutHint(4);
   If Placing or VMoving then begin
    sePlace.Value:= StartVert + ((StartPoint.Y-Y) div 15);
    PlaceLayer:= StrToIntDef(sePlace.Text,0);
    gX:= PlacePos.x;
    gZ:= PlacePos.z;
   end
   else begin
    PlaceLayer:= StrToIntDef(sePlace.Text,0);
    GetBrick(X-Off_X+HScr.Position-24,Y-Off_Y+VScr.Position,PlaceLayer,gX,gZ);
   end;
   If ((PlacePos.x<>gX) or (PlacePos.y<>PlaceLayer) or (PlacePos.z<>gZ))
   and (gX>=0) and (gX<=HighX) and (gZ>=0) and (gZ<=HighZ) then begin
    DrawPieceBrk(PlacePos.x,PlacePos.y,PlacePos.z,PlaceObj.X,PlaceObj.Y,PlaceObj.Z,dmRemember,True);
    PlacePos:= Point3d(gX,PlaceLayer,gZ);
    DrawPieceBrk(gX,0,gZ,PlaceObj.X,PlaceObj.Y+PlaceLayer,PlaceObj.Z,dmMerge);
    //DrawMapA;
    UpdateCoords;
   end;
  end
  else if btSelect.Down or btInv.Down then begin
   If FHMoving then begin
    PutHint(20);
    GetBrick(X+MvOrigin.X+12,Y+MvOrigin.Y+12,Select.y1,gX,gZ);
    If (gX>=0) and (gX<=HighX) and (gZ>=0) and (gZ<=HighZ) then
     PlacePos:= Point3d(gX,Select.y1,gZ);
   end
   else if FVMoving then begin
    PlacePos:= Point3d(Select.x1,Select.y1+((StartPoint.Y-Y+7) div 15),Select.z1);
    If PlacePos.y<0 then PlacePos.y:=0
    else if PlacePos.y>HighY then PlacePos.y:=HighY;
   end
   else begin
    PutHint(15);
    PCursor:= GetPCursor(X, Y, False);
    If BoxEmpty(SelStart) then SelStart:= PCursor;
    If Selecting then begin
     If not BoxEmpty(PCursor) and not btSelObj.Down then
      Select:= Box(Min(SelStart.x1,PCursor.x1),Min(SelStart.y1,PCursor.y1),
                   Min(SelStart.z1,PCursor.z1),Max(SelStart.x2,PCursor.x2),
                   Max(SelStart.y2,PCursor.y2),Max(SelStart.z2,PCursor.z2));
    end
    else begin
     If BoxContains(Select,FneCoords[0],FneCoords[1],FneCoords[2]) then begin
      pbGrid.Cursor:= crSizeAll;
      MoveAllowed:= True;
      PutHint(16);
     end
     else begin
      pbGrid.Cursor:= crDefault;
      MoveAllowed:= False;
     end;
    end;
   end;
   If (FHMoving or FVMoving) and ((PlacePos.x<>LastPlacePos.x) or (PlacePos.y<>LastPlacePos.y) or (PlacePos.z<>LastPlacePos.z)) then begin
    UpdateCoords;
    DrawPieceBrk(LastPlacePos.x,LastPlacePos.y,LastPlacePos.z,PlaceObj.X,PlaceObj.Y,PlaceObj.Z,dmRemember,True);
    DrawPieceBrk(PlacePos.x,PlacePos.y,PlacePos.z,PlaceObj.X,PlaceObj.Y,PlaceObj.Z,dmMerge,True,False);
    LastPlacePos:= PlacePos;
   end
   else if (PCursor.x1<>LastPCursor.x1) or (PCursor.y1<>LastPCursor.y1) or (PCursor.z1<>LastPCursor.z1)
        or (PCursor.x2<>LastPCursor.x2) or (PCursor.y2<>LastPCursor.y2) or (PCursor.z2<>LastPCursor.z2) then begin
    UpdateCoords;
    If Selecting then begin
     DrawPieceBrk(LastSelect.x1,LastSelect.y1,LastSelect.z1,LastSelect.x2-LastSelect.x1+1,
      LastSelect.y2-LastSelect.y1+1,LastSelect.z2-LastSelect.z1+1,dmRemember);
     DrawPieceBrk(Select.x1,Select.y1,Select.z1,Select.x2-Select.x1+1,
      Select.y2-Select.y1+1,Select.z2-Select.z1+1,dmMerge,False,False);
     LastSelect:= Select;
    end
    else begin
     DrawPieceBrk(LastPCursor.x1,LastPCursor.y1,LastPCursor.z1,LastPCursor.x2-LastPCursor.x1+1,
      LastPCursor.y2-LastPCursor.y1+1,LastPCursor.z2-LastPCursor.z1+1,dmRemember);
     DrawPieceBrk(PCursor.x1,PCursor.y1,PCursor.z1,PCursor.x2-PCursor.x1+1,
      PCursor.y2-PCursor.y1+1,PCursor.z2-PCursor.z1+1,dmMerge,False,False);
    end;
    LastPCursor:= PCursor;
   end;
  end;
 end;
end;

procedure TForm1.pbGridMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var a, b, c: Integer;
begin
 Panning:= False;
 SceneMvType:= 0;
 If Placing then begin
  SetUndo;
  PutPiece(PlacePos.x,PlacePos.y,PlacePos.z,PlaceObj,False);
  If frClipping.btReset.Down then ChangePlaceObj(True);
  Modified:= True;
  If InvPlacing then InvPlacingEnd;
 end;
 Placing:=False;
 VMoving:=False;
 If Selecting and not BoxEmpty(Select) then begin
  PlaceObj:=CopyPiece(Select.x1,Select.y1,Select.z1,Select.x2-Select.x1+1,Select.y2-Select.y1+1,Select.z2-Select.z1+1);
  PlacePos:=Point3d(Select.x1,Select.y1,Select.z1);
  BufObj.X:=PlaceObj.X;
  BufObj.Y:=PlaceObj.Y;
  BufObj.Z:=PlaceObj.Z;
  SetLength(BufObj.Map,BufObj.X,BufObj.Y,BufObj.Z);
  for c:=0 to BufObj.Z-1 do
   for b:=0 to BufObj.Y-1 do
    for a:=0 to BufObj.X-1 do
     If btInv.Down and (foNormal in Map[a+Select.x1,b+Select.y1,c+Select.z1].Frame) then
      BufObj.Map[a,b,c]:=Map[a+Select.x1,b+Select.y1,c+Select.z1]
     else BufObj.Map[a,b,c]:=EmptyItem;
  ObjCopied:=True;
 end;
 Selecting:= False;
 If FHMoving or FVMoving then begin
  BufObj:=CopyPiece(PlacePos.x,PlacePos.y,PlacePos.z,PlaceObj.X,PlaceObj.Y,PlaceObj.Z);
  PutPiece(PlacePos.x,PlacePos.y,PlacePos.z,PlaceObj);
  Modified:=True;
  Select:=Box(PlacePos.x,PlacePos.y,PlacePos.z,PlacePos.x+PlaceObj.X-1,
   PlacePos.y+PlaceObj.Y-1,PlacePos.z+PlaceObj.Z-1);
  LastSelect:=Select;
  PCursor:=Box(-1,-1,-1,-1,-1,-1);
  FVMoving:=False;
  FHMoving:=False;
  DrawPieceBrk(Select.x1,Select.y1,Select.z1,Select.x2-Select.x1+1,
   Select.y2-Select.y1+1,Select.z2-Select.z1+1,dmNormal,True);
 end;
end;

procedure TForm1.VScrScroll(Sender: TObject; ScrollCode: TScrollCode;
  var ScrollPos: Integer);
begin
 If ScrollCode = scEndScroll then Exit;
 If (Sender as TScrollBar).Name = 'HScr' then ScrollMap(ScrollPos - HScr.Position,0)
 else if (Sender as TScrollBar).Name= 'VScr' then ScrollMap(0,ScrollPos - VScr.Position);
 Form1.pbThumbPaint(Form1);
end;

procedure TForm1.FormResize(Sender: TObject);
//var a, b: Integer;
begin
 {a:=imgBuffer.Width;
 b:=imgBuffer.Height;}
 SetDimensions(bufMain,pbGrid.Width,pbGrid.Height);
 SetDimensions(imgLts,pbLts.Width,pbLts.Height);
 If not pbGrid.Visible then Exit;
 ActiveControl:= nil;
 If ImageW > pbGrid.Width then begin
  HScr.Enabled:= True;
  HScr.Max:= ImageW;
  HScr.PageSize:= pbGrid.Width;
 end
 else begin
  HScr.Position:= 0;
  HScr.Enabled:= False;
 end;
 If ImageH > pbGrid.Height then begin
  VScr.Enabled:= True;
  VScr.Max:= ImageH;
  VScr.PageSize:= pbGrid.Height;
 end
 else begin
  VScr.Position:= 0;
  VScr.Enabled:= False;
 end;

 DrawMapA;
 {If a<pbGrid.Width then DrawFragment(a+HScr.Position,VScr.Position,
  pbGrid.Width+HScr.Position,pbGrid.Height+VScr.Position);
 If b<pbGrid.Height then DrawFragment(HScr.Position,b+VScr.Position,
  pbGrid.Width-a+HScr.Position,pbGrid.Height+VScr.Position);}
 If LayoutMap[High(LayoutMap)] > pbLts.Height - 2 then begin
  LScr.Enabled:= True;
  LScr.Max:= LayoutMap[High(LayoutMap)] - 2;
  LScr.PageSize:= pbLts.Height;
 end
 else begin
  LScr.Position:= 0;
  LScr.Enabled:= False;
 end;
 PaintLayouts;
 SetClipWndPos;
 SetCoordsPos;
end;

procedure TForm1.pbGridPaint(Sender: TObject);
begin
 UpdateImage(bufMain,pbGrid);
end;

{procedure TForm1.AppMessage(var Msg: TMsg; var Handled: Boolean);
begin
 Handled:=SceneMessage(Msg);
end;}

procedure TForm1.CopyData(var Msg: TWMCopyData);
begin
 If not SceneMode then Msg.Result:= 1 else SceneMessage(Msg);
end;

procedure TForm1.FormCreate(Sender: TObject);
var a: Integer;
begin
 paSplash.BringToFront;
 bufMain.Canvas.Brush.Color:= clBlack;
 bufMain.Canvas.Pen.Color:= clWhite;
 bufThumb.Canvas.Brush.Color:= clBlack;
 imgLts.Canvas.Brush.Color:= clBtnFace;
 bufMain.Canvas.Pen.Color:= clRed;
 bufMain.Canvas.Font.Style:= [fsBold];
 bufMain.Canvas.Font.Name:= 'Courier New';
 bufMain.Canvas.Font.Size:= 20;
 paLayout.DoubleBuffered:= True;
 paGrid.DoubleBuffered:= True;
 frClipping.DoubleBuffered:= True;
 paCoords.DoubleBuffered:= True;
 Screen.Cursors[crHand]:= LoadCursor(hInstance,'Z1_CRHAND');
 btHandClick(Self);
end;

procedure TForm1.btToLayerClick(Sender: TObject);
begin
 {If Sender is TSpeedButton then begin
  If (Sender as TSpeedButton).Name = 'btFrames' then btScFrames.Down:= btFrames.Down
  else if (Sender as TSpeedButton).Name = 'btScFrames' then btFrames.Down:= btScFrames.Down
  else if (Sender as TSpeedButton).Name = 'btNet' then btScNet.Down:= btNet.Down
  else if (Sender as TSpeedButton).Name = 'btScNet' then btNet.Down:= btScNet.Down
  else if (Sender as TSpeedButtno).Name = 'btCoords' then btScCoords.Down:= btCoords.Down
  else if (Sender as TSpeedButton).Name = 'btScCoords' then btCoords.Down:= btScCoords.Down
  else if (Sender as TSpeedButton).Name = 'btShowInv' then btScShowInv.Down:= btShowInv.Down
  else if (Sender as TSpeedButton).Name = 'btScShowInv' then btShowInv.Down:= btScShowInv.Down
  else if (Sender as TSpeedButton).Name = 'btToLayer' then btScToLayer.Down:= btToLayer.Down
  else if (Sender as TSpeedButton).Name = 'btScToLayer' then btToLayer.Down:= btScToLayer.Down;
 end;}

 If Sender = btToLayer then seToLayerChange(seToLayer)
                       else seToLayerChange(seScToLayer);
 DrawMapA;
 PaintLayouts;
 frClipping.pbImage.Repaint;
 a3DHelper.Enabled:= aHelper.Checked;
end;

procedure TForm1.btSelObjClick(Sender: TObject);
begin
 //DrawMapA;
end;

procedure TForm1.aSettingsExecute(Sender: TObject);
begin
 SetForm.ShowSettings;
end;

procedure TForm1.pbThumbPaint(Sender: TObject);
begin
 bufThumb.Canvas.BrushCopy(Rect(152-29,0,152,22),imgAxes.Picture.Bitmap,Rect(0,0,28,22),clFuchsia);
 UpdateImage(bufThumb,pbThumb);
 If HScr.Enabled or VScr.Enabled then begin
  pbThumb.Canvas.Brush.Color:=clRed;
  pbThumb.Canvas.FrameRect(Bounds(Trunc((HScr.Position*152)/ImageW),Trunc((VScr.Position*96)/ImageH),
   Trunc((pbGrid.Width*152)/ImageW),Trunc((pbGrid.Height*96)/ImageH)));
 end;  
end;

procedure TForm1.aExportExecute(Sender: TObject);
var f: File; //Buff: TBitmap;
    a: Word;
    b: Dword;
    c: Byte;
    d, e: Integer;
begin
 DlgSave.Title:='Export current image as bitmap';
 DlgSave.FileName:='';
 DlgSave.Filter:='Bitmaps (*.bmp)|*.bmp';
 DlgSave.InitialDir:=LastExpDir;
 If DlgSave.Execute then begin
  ProgBarForm.ShowSpecialBar('Exporting...',Form1,True,Off_Y,1949+Off_Y);

  AssignFile(f,DlgSave.FileName);
  Rewrite(f,1);
  //== Bitmap file header ==
  a:=19778;   BlockWrite(f,a,2); // Bitmap identifier (ASCII "BM")
  b:=6046078; BlockWrite(f,b,4); // File size
  b:=0;       BlockWrite(f,b,4); // Reserved
  b:=1078;    BlockWrite(f,b,4); // Offset to the bitmap data
  //== Bitmap info header ==
  b:=40;      BlockWrite(f,b,4); // Size of the bitmap info header structure
  b:=3100;    BlockWrite(f,b,4); // Bitmap width
  b:=1950;    BlockWrite(f,b,4); // Bitmap height
  a:=1;       BlockWrite(f,a,2); // Number of planes
  a:=8;       BlockWrite(f,a,2); // Bits per pixel
  b:=0;       BlockWrite(f,b,4); // Compression
  b:=6045000; BlockWrite(f,b,4); // Size of the image
  b:=0;       BlockWrite(f,b,4); // X - pixels per meter
  b:=0;       BlockWrite(f,b,4); // Y - pixels per meter
  b:=0;       BlockWrite(f,b,4); // Number of used colours
  b:=0;       BlockWrite(f,b,4); // Number of important colours
  //== RGB Quad ==
  for a:=0 to 255 do begin
   c:=(Palette[a] shr 16) and $ff; // R
   BlockWrite(f,c,1);
   c:=(Palette[a] shr 8) and $ff;  // G
   BlockWrite(f,c,1);
   c:=Palette[a] and $ff;          // B
   BlockWrite(f,c,1);
   c:=0;                           // Reserved
   BlockWrite(f,c,1);
  end;
  // Bitmap data
  for e:=1949-Off_Y downto -Off_Y do begin
   for d:=-Off_X-24 to 3099-Off_X-24 do begin
    c:=PixelOfScreenVal(d,e,True,False);
    BlockWrite(f,c,1);
   end;
   ProgBarForm.UpdateBar(1949-e);
  end;

  CloseFile(f);
  ProgBarForm.CloseSpecial;
  Beep;
  PutMessage(29);
  LastExpDir:=ExtractFilePath(DlgSave.FileName);
 end;
end;

procedure TForm1.pbThumbMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
 pbThumbMouseMove(Self,Shift,X,Y);
end;

procedure TForm1.pbThumbMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var NewX, NewY: Integer;
begin
 PutHint(56);
 If ssLeft in Shift then begin
  NewX:= Trunc((X+1)*(ImageW/152) - pbGrid.Width/2);
  NewY:= Trunc((Y+1)*(ImageH/96) - pbGrid.Height/2);
  ScrollMap(NewX-HScr.Position, NewY-VScr.Position);
  HScr.Position:= NewX;
  VScr.Position:= NewY;
  Form1.pbThumbPaint(Self);
 end;
end;

procedure TForm1.aExitExecute(Sender: TObject);
begin
 Close;
end;

procedure TForm1.pbLtsPaint(Sender: TObject);
begin
 If pbGrid.Visible then UpdateImage(imgLts,pbLts);
end;

procedure TForm1.LScrChange(Sender: TObject);
begin
 PaintLayouts;
end;

procedure TForm1.pbLtsMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var a: Integer;
begin
 for a:=0 to High(LayoutMap) do
  If LayoutMap[a]>Y+LScr.Position+1 then Break;
 LtSel:=a;
 PaintLayouts;
 ChangePlaceObj;
end;

procedure TForm1.Splitter1CanResize(Sender: TObject; var NewSize: Integer;
  var Accept: Boolean);
begin
 pbLts.Visible:=NewSize>50;
 pbLts.Width:=paLayout.Width-LScr.Width-4;
 If btPlace.Down then begin
  If NewSize>50 then LastLtPos:=NewSize else LastLtPos:=1;
 end
 else begin
  LtAlwaysOn:=NewSize>50;
  If NewSize>50 then LastLtPos:=NewSize else LastLtPos:=100;
 end;
end;

procedure TForm1.btHandClick(Sender: TObject);
begin
 ResetControls(False);
 pbGrid.Cursor:= crDefault;
 ToolOpts.Visible:= True;
 frClipping.Visible:= False;
 paAdv.Visible:= False;
 cbCoordsClick(Self);
 If not (btPlace.Down or LtAlwaysOn) then begin
  pbLts.Visible:= False;
  paLayout.Width:= 1;
 end;
 If not btInv.Down and InvPlacing then InvPlacingEnd;
 If not (btSelect.Down or btInv.Down) then ObjCopied:=False;
 If btHand.Down then begin
  pbGrid.Cursor:=crHand;
  ToolOpts.Visible:=False;
 end
 else if btSelect.Down then
  ToolOpts.ActivePage:=SelOpts
 else if btPlace.Down then begin
  If (LastLtPos>1) then begin
   paLayout.Width:=LastLtPos;
   pbLts.Width:=paLayout.Width-LScr.Width-4;
   pbLts.Visible:=True;
  end;
  ChangePlaceObj;
  ToolOpts.ActivePage:=PlaceOpts;
  InitClipping;
 end
 else if btInv.Down then
  ToolOpts.ActivePage:=InvOpts;
 FormResize(Self);
end;

procedure TForm1.aHintsExecute(Sender: TObject);
begin
 paHint.Visible:=aHints.Checked;
 FormResize(Self);
end;

procedure TForm1.btHandMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
 If Sender is TSpeedButton then PutHint(StrToIntDef((Sender as TSpeedButton).Hint,-1))
 else if Sender is TButton then PutHint(StrToIntDef((Sender as TButton).Hint,-1))
 else if Sender is TBitBtn then PutHint(StrToIntDef((Sender as TBitBtn).Hint,-1))
 else if Sender is TPaintBox then PutHint(StrToIntDef((Sender as TPaintBox).Hint,-1))
 else if Sender is TCheckBox then PutHint(StrToIntDef((Sender as TCheckBox).Hint,-1))
 else if Sender is TSpinEdit then PutHint(StrToIntDef((Sender as TSpinEdit).Hint,-1))
 else if Sender is TLabel then PutHint(StrToIntDef((Sender as TLabel).Hint,-1))
 else PutHint(-1);
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var tmp: Byte;
begin
 DrawPieceBrk(Select.x1,Select.y1,Select.z1,
  Select.x2-Select.x1+1,Select.y2-Select.y1+1,Select.z2-Select.z1+1,dmRemember);
 If SceneMode and BackCommEnabled and not Assigned(ScenePrevBtn) then begin
  If btScHand.Down then ScenePrevBtn:= btScHand
  else if btScEdit.Down then ScenePrevBtn:= btScEdit
  else if btScAddActor.Down then ScenePrevBtn:= btScAddActor
  else ScenePrevBtn:= btScAddTrack;
 end;
 KeyHandled:= True;
 case Key of
   46: If SceneMode then begin  //Del
        If btScEdit.Down and (SelType >= 1) and (SelType <= 3) then begin
         tmp:= SelType;
         SelType:= 0;
         SendBackCommand(tmp*10+2, SelId, 0,0,0,0,0,0);
        end;
       end
       else if (btSelect.Down or btInv.Down) and not BoxEmpty(Select) then begin
        DelPiece(Select);
        ObjCopied:= False;
        Modified:= True;
        DrawPieceBrk(Select.x1,Select.y1,Select.z1,Select.x2-Select.x1+1,
         Select.y2-Select.y1+1,Select.z2-Select.z1+1);
        Key:= 0;
       end;
   99: begin Inc(Select.x1); Inc(Select.x2); end; //x
  103: begin Dec(Select.x1); Dec(Select.x2); end;
   97: begin Inc(Select.z1); Inc(Select.z2); end; //z
  105: begin Dec(Select.z1); Dec(Select.z2); end;
  104: begin Inc(Select.y1); Inc(Select.y2); end; //y
   98: begin Dec(Select.y1); Dec(Select.y2); end;
   16: If SceneMode and BackCommEnabled then begin
        If ssCtrl in Shift then btScAddActor.Down:= True
        else btScAddTrack.Down:= True;
        btScHandClick(Sender);
       end;
   17: If SceneMode and BackCommEnabled and (ssShift in Shift) then begin
        btScAddActor.Down:= True;
        btScHandClick(Sender);
       end;
  //else Label8.Caption:= IntToStr(Key);
  else KeyHandled:= False;
 end;
 If KeyHandled and not SceneMode then begin
  DrawPieceBrk(Select.x1,Select.y1,Select.z1,
   Select.x2-Select.x1+1,Select.y2-Select.y1+1,Select.z2-Select.z1+1,dmMerge);
  UpdateCoords;
 end;
end;

procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
begin
 If KeyHandled then Key:= #0;
 KeyHandled:= False;
end;

procedure TForm1.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 If SceneMode and Assigned(ScenePrevBtn) then begin
  case Key of
   16: begin
        ScenePrevBtn.Down:= True;
        btScHandClick(Sender);
        ScenePrevBtn:= nil;
       end;
   17: If ssShift in Shift then begin
        btScAddTrack.Down:= True;
        btScHandClick(Sender);
       end;
  end;
 end
 else ScenePrevBtn:= nil;
end;

procedure TForm1.aSaveExecute(Sender: TObject);
begin
 SaveGrid(CurrentFile,CurrentIndex);
end;

procedure TForm1.aSaveAsExecute(Sender: TObject);
var ext: ShortString;
begin
 ext:= LowerCase(ExtractFileExt(CurrentFile));
 If GridNow then begin
  DlgSave.Title:= 'Save grid';
  If (ext <> '.hqr') and (CurrentFile <> '') then DlgSave.FileName:= CurrentFile
  else begin
   If Grid.Lba2 then DlgSave.FileName:= Format('(lib=%d)',[CurrentLibIndex+1])
   else DlgSave.FileName:= Format('(lib=%d)',[GriToBll1[CurrentLibIndex]+1]);
  end;
  DlgSave.Filter:='LBA 1 grid file (*.gr1)|*.gr1|'+
                  'LBA 2 grid file (*.gr2)|*.gr2';
  If Grid.Lba2 then DlgSave.FilterIndex:= 2 else DlgSave.FilterIndex:= 1;
  DlgSave.InitialDir:= LastSaveDir;
  If DlgSave.Execute then
   SaveGrid(ChangeFileExt(DlgSave.FileName,IfThen(DlgSave.FilterIndex=1,'.gr1','.gr2')));
 end
 else begin
  DlgSave.Title:='Save grid fragment';
  If ext<>'.hqr' then DlgSave.FileName:= CurrentFile
  else DlgSave.FileName:= Format('(lib=%d)',[CurrentLibIndex+1]);
  DlgSave.Filter:= 'LBA 2 grid fragment (*.grf)|*.grf';
  DlgSave.InitialDir:= LastSaveDir;
  If DlgSave.Execute then
   SaveGrid(ChangeFileExt(DlgSave.FileName,'.grf'));
 end;
end;

procedure TForm1.aExportScenExecute(Sender: TObject);
var SceneRes: Boolean;
    path: String;
begin
 If SceneMode then begin
  SceneRes:= False;
  If BackCommEnabled then begin
   ProgBarForm.ShowSpecial('Communicating with scenario editor...',Form1,True);
   If SendBackCommand(101,0,0,0,0,0,0,0) then begin
    path:= IncludeTrailingPathDelimiter(GetEnvironmentVariable('TEMP'))
           + 'TemporaryScenario7865.hqs';
    If FileExists(path) then begin
     VScen:= OpenPack(path);
     DeleteFile(path);
     SceneRes:= True;
    end
    else MessageBox(Handle,'Temporary file does not exist!','LBArchitect',MB_ICONERROR+MB_OK);
   end;
   ProgBarForm.CloseSpecial;
  end
  else MessageBox(Handle,'Backward communication is not enabled!','LBArchitect',MB_ICONERROR+MB_OK);
 end
 else SceneRes:= True;

 If SceneRes
 or (MessageBox(Handle,'There was an error during communication with the Scene editor program.'#13
                    + 'It means that Builder could not read full information about the Scene you are editing at the moment.'#13
                    + 'You can save the Scenario now, but it will NOT contain the Scene data.'#13
                    + 'If you want not to lose the modified Scene, you will have to save it in the Scene editor.'#13#13
                    + 'Do you want to save the Scenario without the Scene data?','LBARchitect',MB_ICONWARNING+MB_YESNO)
    = IDYES) then begin
  DlgSave.Title:= 'Export to a Scenario';
  DlgSave.FileName:= ChangeFileExt(ExtractFileName(CurrentFile),'.hqs');
  DlgSave.Filter:= 'High Quality Scenarios (*.hqs)|*.hqs';
  DlgSave.DefaultExt:= '.hqs';
  DlgSave.InitialDir:= LastScenDir;
  If DlgSave.Execute then begin
   LastScenDir:= ExtractFilePath(DlgSave.FileName);
   SaveScenario(DlgSave.FileName);
  end;
 end;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 CheckModified;
end;

procedure TForm1.aNewExecute(Sender: TObject);
begin
 SetModeNew;
 If OpenForm.ShowModal = mrOK then begin
  CheckModified;
  EnableControls(False);
  btNet.Down:= True;
  Screen.Cursor:= crHourGlass;
  SetLength(VScen,0);
  OpenFiles(True);
  ProgBarForm.ShowSpecial('Loading files...', Form1, True);
  Grid.Lba2:= OpenForm.rb12.Checked
          or (OpenForm.rb13.Checked and (ExtIs(LibPath,'bl2') or IsBkg(LibPath)));
  Grid.LibIndex:= StrToIntDef(OpenForm.eLibIndex.Text, 0);
  Grid.FragIndex:= StrToIntDef(OpenForm.eFragIndex.Text, 0);
  SetMapsLengths(63, 24, 63);
  ClearMap;
  FindLba2Invisible(VLibrary);
  OpenFinalize(True);
 end;
end;

procedure TForm1.aOpenSimExecute(Sender: TObject);
begin
 If SimpleForm.ShowModal = mrOK then begin
  CheckModified;
  EnableControls(False);
  Screen.Cursor:= crHourGlass;
  ProgBarForm.ShowSpecial('Loading files...',Form1,True);
  OpenSimpleFiles;
  DataToMap;
  OpenFinalize;
 end;
end;

procedure TForm1.aOpenExecute(Sender: TObject);
begin
 SetModeOpen;
 If OpenForm.ShowModal = mrOK then begin
  CheckModified;
  EnableControls(False);
  Screen.Cursor:= crHourGlass;
  SetLength(VScen,0);
  OpenFiles;
  ProgBarForm.ShowSpecial('Loading files...',Form1,True);
  DataToMap;
  OpenFinalize;
 end;
end;

procedure TForm1.aOpenScenExecute(Sender: TObject);
begin
 DlgOpen.Title:= 'Open Scenario';
 DlgOpen.FileName:= '';
 DlgOpen.Filter:= 'High Quality Scenarios (*.hqs)|*.hqs';
 DlgOpen.InitialDir:= LastScenDir;
 If DlgOpen.Execute then begin
  CheckModified;
  EnableControls(False);
  LastScenDir:= ExtractFilePath(DlgOpen.FileName);
  //ProgBarForm.ShowSpecial('Loading files...',Form1,True);
  If OpenScenario(DlgOpen.FileName) then OpenFinalize;
 end;
end;

procedure TForm1.TimerTimer(Sender: TObject);
begin
 Timer.Enabled:=False;
 Label8.Caption:='';
end;

procedure TForm1.AppException(Sender: TObject; E: Exception);
begin
 If ProgBarForm.Visible or not Enabled then ProgBarForm.CloseSpecial;
 if SetForm.Visible then SetForm.Close;
 Screen.Cursor:= crDefault;
 MessageBox(handle,PChar(ProgramName+' have risen an exception called: "'+E.Message+'" and may be unstable. Please save your work and restart the program as soon as possible.'),ProgramName,MB_ICONWARNING+MB_OK);
end;

procedure TForm1.btinvNewClick(Sender: TObject);
var a, b, c: Integer;
    Invisible: TMapItem;
begin
 If InvPlacing then InvPlacingEnd
 else begin
  If Grid.Lba2 then begin
   if Lba2Invisible.Idx.Lt>0 then Invisible:=Lba2Invisible
   else begin
    MessageBox(Handle,'It seems that current library doesn''t contain any invisible bricks, sorry.',ProgramName,MB_ICONINFORMATION+MB_OK);
    Exit;
   end;
  end
  else Invisible:=Lba1Invisible;
  Form1.seX.Enabled:=False;
  Form1.seY.Enabled:=False;
  Form1.seZ.Enabled:=False;
  PlaceObj.X:=TryToConvert(seX);
  PlaceObj.Y:=TryToConvert(seY);
  PlaceObj.Z:=TryToConvert(seZ);
  SetLength(PlaceObj.Map,PlaceObj.X,PlaceObj.Y,PlaceObj.Z);
  for c:=0 to PlaceObj.Z-1 do
   for b:=0 to PlaceObj.Y-1 do
    for a:=0 to PlaceObj.X-1 do
     PlaceObj.Map[a,b,c]:=Invisible;
  InvPlacing:=True;
  btInvNew.Caption:='Cancel';
 end;
end;

procedure TForm1.FormMouseWheel(Sender: TObject; Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
var Delta: Integer;
begin
 Delta:= Sign(WheelDelta) * WheelSpeed;
 MousePos:= Form1.ScreenToClient(MousePos);
 If (MousePos.X > 0) and (MousePos.Y > 0)
 and (MousePos.X <= paLayout.Width) and (MousePos.Y <= paLayout.Height) then begin
  If SetForm.cbWInvY.Checked then Delta:= - Delta;
  If Abs(WheelDelta) > WheelAverage then Delta:= Delta * 3;
  LScr.Position:= LScr.Position + Delta;
 end
 else begin
  If Abs(WheelDelta) <= WheelAverage then begin
   If SetForm.cbWInvY.Checked then Delta:= - Delta;
   ScrollMap(0,Delta);
  end
  else begin
   If SetForm.cbWInvX.Checked then Delta:= - Delta;
   ScrollMap(Delta,0);
  end;
  pbThumbPaint(Self);
 end;
end;

function CopyMap(Src: TGridMap): TGridMap;
var a, b: Integer;
begin
 Result:=Copy(Src);
 for a:=0 to High(Src) do begin
  Result[a]:=Copy(Src[a]);
  for b:=0 to High(Src[a]) do
   Result[a,b]:=Copy(Src[a,b]);
 end;
end;

procedure SetUndo;
var a: Integer;
    temp: TGridMap;
begin
 If LastUndo<MaxUndo then
  Inc(LastUndo)
 else begin
  temp:=UndoArray[1];
  for a:=1 to MaxUndo-1 do
   UndoArray[a]:=UndoArray[a+1];
  UndoArray[MaxUndo]:=temp;
 end;
 UndoArray[LastUndo]:= CopyMap(Map);
 Form1.aRedo.Enabled:= False;
 Form1.aUndo.Enabled:= True;
end;

procedure TForm1.aUndoExecute(Sender: TObject);
begin
 ObjCopied:=False;
 If not aRedo.Enabled then begin
  RedoMap:= CopyMap(Map);
  FirstRedo:= LastUndo;
 end;
 Map:=CopyMap(UndoArray[LastUndo]);
 If LastUndo>0 then
  Dec(LastUndo);
 If LastUndo<1 then aUndo.Enabled:=False;
 aRedo.Enabled:=True;
 Select:=Box(-1,-1,-1,-1,-1,-1);
 DrawMapA;
 UpdateThumbBack;
end;

procedure TForm1.aRedoExecute(Sender: TObject);
begin
 ObjCopied:=False;
 Inc(LastUndo);
 If LastUndo<FirstRedo then
  Map:=CopyMap(UndoArray[LastUndo+1])
 else begin
  Map:=CopyMap(RedoMap);
  aRedo.Enabled:=False;
 end;
 aUndo.Enabled:=True;
 Select:=Box(-1,-1,-1,-1,-1,-1);
 DrawMapA;
 UpdateThumbBack;
end;

procedure TForm1.cbCoordsClick(Sender: TObject);
begin
 If SceneMode then paCoords.Visible:= btScCoords.Down and not btScHand.Down
              else paCoords.Visible:= btCoords.Down and not btHand.Down;
 paCoords.Realign;
 SetCoordsPos;
end;

procedure TForm1.lbCoordsClick(Sender: TObject);
begin
 If SceneMode then btScCoords.Down:= False
 else btCoords.Down:= False;
 cbCoordsClick(Sender);
end;

procedure TForm1.btDeleteClick(Sender: TObject);
var layer, temp, a, b: Integer;
begin
 layer:= TryToConvert(seToLayer);
 If not TryStrToInt(seToLayer.Text,temp) or (temp<>layer) then Exit;
 If SetForm.cbAskLayer.Checked and (MessageBox(Handle,PChar(Format('Delete all contents of layer %d?',[layer])),ProgramName,MB_OKCANCEL)<>ID_OK) then Exit;
 SetUndo;
 For b:=0 to HighZ do
  for a:=0 to HighX do
   Map[a,layer,b]:= EmptyItem;
 DrawMapA;
 UpdateThumbBack;
end;

procedure TForm1.btAlX0Click(Sender: TObject);
var c: Integer;
begin
 If Sender is TSpeedButton then begin
  c:=StrToInt((Sender as TSpeedButton).Name[6]);
  Invert[c]:=not Invert[c];
 end;
 If Invert[0] then btAlX0.Glyph.LoadFromResourceName(0,'ALTOPLEFT')
 else btAlX0.Glyph.LoadFromResourceName(0,'ALBTMRIGHT');
 If Invert[1] then btAlY1.Glyph.LoadFromResourceName(0,'ALBOTTOM')
 else btAlY1.Glyph.LoadFromResourceName(0,'ALTOP');
 If Invert[2] then btAlZ2.Glyph.LoadFromResourceName(0,'ALTOPRIGHT')
 else btAlZ2.Glyph.LoadFromResourceName(0,'ALBTMLEFT');
 SetClipExpand;
end;

procedure TForm1.seAXChange(Sender: TObject);
begin
 ExpandChanged:=True;
 SetClipExpand;
end;

procedure TForm1.seToLayerChange(Sender: TObject);
begin
 If Sender = seToLayer then seScToLayer.Text:= seToLayer.Text
 else seToLayer.Text:= seScToLayer.Text;
 If (SceneMode and btScToLayer.Down)
 or (not SceneMode and btToLayer.Down) then begin
  MaxLayer:= TryToConvert(seToLayer);
  DrawMapA;
 end
 else MaxLayer:= HighY;
end;

procedure TForm1.ThumbTimerTimer(Sender: TObject);
begin
 ThumbTimer.Enabled:=False;
 CreateThumbnail(0,ThumbCounter,151,ThumbCounter);
 Inc(ThumbCounter);
 If ThumbCounter>=95 then begin
  pbThumb.Repaint;
  ThumbCounter:=0;
 end
 else
  ThumbTimer.Enabled:=True;
end;
{$o-}
procedure TForm1.Button1Click(Sender: TObject);
var a, b, c, d, f, g, h, i, max, pX, pY, BrkNum: Integer;
    e: array of Integer;
    t1, t2: TTime;
begin
 //SetMapsLengths(sX.Value-1,sY.Value-1,sZ.Value-1);
 //DrawMapA;

 {for a:=0 to pbGrid.Width-1 do
  for b:=0 to pbGrid.Height-1 do begin
   pX:=a+HScr.Position-Off_X-24;
   pY:=b+VScr.Position-Off_Y;
   If (pX=-HighZ*24-24-3) then pbGrid.Canvas.Pixels[a,b]:=clFuchsia
   else if (pX=HighX*24+24+3) then pbGrid.Canvas.Pixels[a,b]:=clBlue
   else if (pX=(-pY-Off_Y)*2+32) then pbGrid.Canvas.Pixels[a,b]:=clYellow
   else if (pX=2*pY+Off_Y*2-32) then pbGrid.Canvas.Pixels[a,b]:=clLime
   else if (pX=(pY-Off_X)*2-41) then pbGrid.Canvas.Pixels[a,b]:=clAqua
   else if (pX=(-pY-Off_X+ImageW)*2-55) then pbGrid.Canvas.Pixels[a,b]:=clRed;
  end; }

 {Button1.Caption:='';
 SetLength(e,0);
 //for a:=0 to 255 do
 // c[a]:=0;
 max:=0;
 for b:=Off_Y downto -Off_Y+400 do
  for a:=63 downto -64 do begin
   g:=0;
   for f:=0 to HighZ do
    for d:=0 to HighY do
     for c:=0 to HighX do begin
      GridToPosVar(c,d,f,a*24-1,b,pX,pY);
      If (Map[c,d,f].BrkNr>0)
      and (pX>-48) and (pY>-38) and (pX<640) and (pY<480) then
       Inc(g);
     end;
   If g>max then max:=g;
  end;

 Button1.Caption:=IntToStr(max); }

 {for a:=1 to High(Lib) do begin
  for b:=0 to High(Lib[a].Map) do begin
   BrkNum:=Lib[a].Map[b].Index-1;
   If BuffMap[BrkNum+1]=-1 then begin
    Buffer.Canvas.FillRect(Rect(0,0,48,38));
    If Brk[BrkNum].Comp>0 then UnpackSelf(Brk[BrkNum]);
    PaintBrickFromString(Brk[BrkNum].Data,Point(0,0),Palette,Buffer.Canvas,False,True);
    BuffMap[BrkNum+1]:= Form1.BrkBuff.AddMasked(Buffer,clFuchsia);
   end;
  end;
 end;}

  //Button1.Caption:=IntToStr(pZ);

 //speed test
 t1:= GetTime;

 for a:=0 to 10000 do begin
  //FrontFrameC(0,0, Temp1.Canvas,clYellow); //220
  //FrontFrame(0,0,Temp1.Canvas,clYellow);
  //BrkBuff.Draw(Temp1.Canvas,0,0,30);  //1450
  //DrawBrickImg(Brk,Temp1.Canvas,0,0);
  //BrkTemp.Canvas.MoveTo(0,0); Temp1.Canvas.LineTo(40,20); //350
  BrkTemp.Canvas.PolyLine([Point(0,0),Point(40,20)]); //300
 end;

 t2:= GetTime;

 MessageBox(Handle,PChar(FloatToStr(DateTimeToTimeStamp(t2-t1).Time)),'',MB_OK);

end;
{$o+}
procedure TForm1.mViewShapesClick(Sender: TObject);
begin
 If mViewShapes.Checked then
  if SceneMode then btScFrames.Down:= False else btFrames.Down:= False;
 btToLayerClick(Self);
end;

procedure TForm1.mAboutClick(Sender: TObject);
begin
 fmAbout.ShowModal;
end;

procedure TForm1.cbScTracksClick(Sender: TObject);
var a: Integer;
begin
 If ZoneSelecting then Exit;
 for a:= 0 to 6 do
  ZoneEnabledTypes[a]:= (FindComponent('cbScZone' + IntToStr(a)) as TCheckBox).Checked;
 DisplayActorClipping:= btScClip.Down;
 If ((SelType = 1) and not btScTracks.Down)
 or ((SelType = 2) and not btScZones.Down)
 or ((SelType = 3) and not btScActors.Down) then SelType:= 0;
 DrawMapA;
end;

procedure TForm1.btSelAllClick(Sender: TObject);
var a: Integer;
    b: Boolean;
begin
 ZoneSelecting:= True;
 b:= (Sender as TBitBtn).Name = 'btSelAll';
 for a:=0 to 6 do
  (FindComponent('cbScZone' + IntToStr(a)) as TCheckBox).Checked:= b;
 ZoneSelecting:= False;
 cbScTracksClick(Self);
end;

procedure TForm1.btScHandClick(Sender: TObject);
begin
 pbGrid.Cursor:= crDefault;
 cbCoordsClick(Self);
 If btScHand.Down then pbGrid.Cursor:= crHand
 {else if btScEdit.Down then begin

 end};
 //FormResize(Self);
end;

procedure TForm1.aScenPropExecute(Sender: TObject);
begin
 fmScenProp.SetInfo(Grid.Lba2, VScen, HQSInfo.InfoText, ScenDescription);
 fmScenProp.ShowModal;
 HQSInfo.InfoText:= fmScenProp.eShortDesc.Text;
 ScenDescription:= fmScenProp.mLongDesc.Lines.Text;
end;

procedure TForm1.VScrChange(Sender: TObject);
begin
 If HScr.Enabled then ScrollX:= HScr.Position else ScrollX:= 0;
 If VScr.Enabled then ScrollY:= VScr.Position else ScrollY:= 0;
end;

initialization
 bufMain:= TBitmap.Create;
 bufMain.pixelformat:= pf24bit;
 bufMain.Transparent:= False;
 bufThumb:= TBitmap.Create;
 bufThumb.PixelFormat:= pf24bit;
 bufThumb.Transparent:= False;
 bufThumb.Width:= 152;
 bufThumb.Height:= 96;

finalization
 If Assigned(bufMain) then bufMain.Free;
 If Assigned(bufThumb) then bufThumb.Free;

end.
