//******************************************************************************
// Little Big Architect: Builder - editing grid files containing rooms in
//                                 Little Big Adventure 1 & 2
//
// Sett unit.
// Contains file opening dialog (simple) routines.
//
// Copyright Zink
// e-mail: zink@poczta.onet.pl
// See the GNU General Public License (License.txt) for details.
//******************************************************************************

unit Sett;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, IniFiles, Engine, Math, ComCtrls, ExtCtrls, Buttons,
  DFSClrBn, PathEdit;

type
  TSetForm = class(TForm)
    Button1: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    GroupBox1: TGroupBox;
    Label3: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    GroupBox2: TGroupBox;
    Label4: TLabel;
    TabSheet3: TTabSheet;
    cbReset: TCheckBox;
    cbAskLayer: TCheckBox;
    TabSheet4: TTabSheet;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    eWSpeed: TEdit;
    eWAverage: TEdit;
    cbWInvX: TCheckBox;
    cbWInvY: TCheckBox;
    TabSheet5: TTabSheet;
    GroupBox4: TGroupBox;
    cbUseComp1: TCheckBox;
    Label27: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    cbUseComp2: TCheckBox;
    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    Label33: TLabel;
    paComp2: TPanel;
    rbComp20: TRadioButton;
    rbComp21: TRadioButton;
    rbComp22: TRadioButton;
    rbComp23: TRadioButton;
    paComp1: TPanel;
    rbComp10: TRadioButton;
    rbComp11: TRadioButton;
    rbComp12: TRadioButton;
    TabSheet6: TTabSheet;
    GroupBox5: TGroupBox;
    Label36: TLabel;
    Label37: TLabel;
    Label38: TLabel;
    Label39: TLabel;
    cbScZone0: TdfsColorButton;
    cbScZone2: TdfsColorButton;
    cbScZone3: TdfsColorButton;
    cbScZone1: TdfsColorButton;
    Label40: TLabel;
    Label41: TLabel;
    Label42: TLabel;
    cbScZone5: TdfsColorButton;
    cbScZone6: TdfsColorButton;
    cbScZone4: TdfsColorButton;
    GroupBox6: TGroupBox;
    Label5: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label34: TLabel;
    btRestCol: TButton;
    cbMainImg: TdfsColorButton;
    cbPanel: TdfsColorButton;
    cbHelper: TdfsColorButton;
    cbInvBrk: TdfsColorButton;
    cbCursor: TdfsColorButton;
    cbWinNet: TdfsColorButton;
    cbPlaced: TdfsColorButton;
    cbSelect: TdfsColorButton;
    cbShapes: TdfsColorButton;
    cbNewFrames: TCheckBox;
    rbNewFrEdge: TRadioButton;
    rbNewFrObj: TRadioButton;
    cbSaveSuperCompat: TCheckBox;
    Label6: TLabel;
    peSprites1: TPathEdit;
    peSprites2: TPathEdit;
    peBrk: TPathEdit;
    peBll: TPathEdit;
    peGri: TPathEdit;
    peBkg: TPathEdit;
    GroupBox7: TGroupBox;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    cbDispCur: TCheckBox;
    cbDispSel: TCheckBox;
    GroupBox3: TGroupBox;
    rbRangeSep: TRadioButton;
    rbRangeCon: TRadioButton;
    cbRangeHide: TCheckBox;
    cbDispBrk: TCheckBox;
    rbAtCursor: TRadioButton;
    rbSelected: TRadioButton;
    GroupBox8: TGroupBox;
    Label21: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    cbScenePix: TCheckBox;
    cbSceneBrk: TCheckBox;
    cbSceneClip: TCheckBox;
    Label22: TLabel;
    Label26: TLabel;
    cbSceneSel: TCheckBox;
    Label43: TLabel;
    peRess1: TPathEdit;
    Label44: TLabel;
    Label45: TLabel;
    Label35: TLabel;
    Label46: TLabel;
    peRess2: TPathEdit;
    cbSceneSnap: TCheckBox;
    Label47: TLabel;
    procedure cbMainImgChange(Sender: TObject);
    procedure cbResetClick(Sender: TObject);
    procedure btRestColClick(Sender: TObject);
    procedure cbDispBrkClick(Sender: TObject);
    procedure cbUseComp1Click(Sender: TObject);
    procedure cbNewFramesClick(Sender: TObject);
    procedure peBrkPathChange(Sender: TObject; var Path: TFileName);
  private
    { Private declarations }
  public
    Procedure ShowSettings;
  end;

var
  SetForm: TSetForm;

  BrkSpec: Boolean = False;
  BllSpec: Boolean = False;
  GriSpec: Boolean = False;
  BkgSpec: Boolean = False;

  clMainImg, clWinNet, clPanel, clPlaced, clCursor, clSelect, clHelper,
  clInvBrk, clShapes: TColor;
  clScZone: array[0..6] of TColor; 

  LastExpDir, LastSaveDir, LastScenDir: String;
  WheelSpeed, WheelAverage: Integer;
  UseNewFrames: Boolean;

function RadioToIndex(Form: TForm; NameMask: String; Min, Max: Integer): Integer;
procedure LoadSettings;
procedure SaveSettings;
procedure UpdateColours;

implementation

uses Open, Main, BEngine, OpenSim, Clipping, Grids;

{$R *.dfm}

Procedure TSetForm.ShowSettings;
begin
 eWSpeed.Text:= IntToStr(WheelSpeed);
 eWAverage.Text:= IntToStr(WheelAverage);
 ShowModal;
 WheelSpeed:= StrToIntDef(eWSpeed.Text,5);
 WheelAverage:= StrToIntDef(eWAverage.Text,180);
 LoadGriToBllTables();
end;

Procedure CheckPathSpec;
begin
 BrkSpec:= SetForm.peBrk.Path <> '';
 BllSpec:= SetForm.peBll.Path <> '';
 GriSpec:= SetForm.peGri.Path <> '';
 BkgSpec:= SetForm.peBkg.Path <> '';
end;

procedure UpdateColours;
begin
 clMainImg:= SetForm.cbMainImg.Color;
 clWinNet:=  SetForm.cbWinNet.Color;
 clPanel:=   SetForm.cbPanel.Color;
 clPlaced:=  SetForm.cbPlaced.Color;
 clCursor:=  SetForm.cbCursor.Color;
 clSelect:=  SetForm.cbSelect.Color;
 clHelper:=  SetForm.cbHelper.Color;
 clInvBrk:=  SetForm.cbInvBrk.Color;
 clShapes:=  SetForm.cbShapes.Color;
 clScZone[0]:= SetForm.cbScZone0.Color;
 Form1.cbScZone0.Color:= clScZone[0];
 clScZone[1]:= SetForm.cbScZone1.Color;
 Form1.cbScZone1.Color:= clScZone[1];
 clScZone[2]:= SetForm.cbScZone2.Color;
 Form1.cbScZone2.Color:= clScZone[2];
 clScZone[3]:= SetForm.cbScZone3.Color;
 Form1.cbScZone3.Color:= clScZone[3];
 clScZone[4]:= SetForm.cbScZone4.Color;
 Form1.cbScZone4.Color:= clScZone[4];
 clScZone[5]:= SetForm.cbScZone5.Color;
 Form1.cbScZone5.Color:= clScZone[5];
 clScZone[6]:= SetForm.cbScZone6.Color;
 Form1.cbScZone6.Color:= clScZone[6];
end;

function RadioToIndex(Form: TForm; NameMask: String; Min, Max: Integer): Integer;
var a: Integer;
begin
 Result:=-1;
 for a:=Min to Max do
  If (Form.FindComponent(Format(NameMask,[a])) as TRadioButton).Checked then begin
   Result:=a;
   Exit;
  end;
end;

Procedure IndexToRadio(Form: TForm; NameMask: String; Index: Integer);
begin
 If Index>-1 then
  (Form.FindComponent(Format(NameMask,[Index])) as TRadioButton).Checked:=True;
end;

procedure LoadSettings;
var f: TIniFile;
    a: Integer;
    AppPath: String;
begin
 AppPath:= ExtractFilePath(Application.ExeName);
 f:= TIniFile.Create(AppPath + 'Builder.ini');
 SetForm.peBrk.Path:=      f.ReadString('Paths','lba_brk','');
 SetForm.peBll.Path:=      f.ReadString('Paths','lba_bll','');
 SetForm.peGri.Path:=      f.ReadString('Paths','lba_gri','');
 SetForm.peBkg.Path:=      f.ReadString('Paths','lba_bkg','');
 SetForm.peSprites1.Path:= f.ReadString('Paths','sprites1','');
 SetForm.peRess1.Path:=    f.ReadString('Paths','ress1','');
 SetForm.peSprites2.Path:= f.ReadString('Paths','sprites2','');
 SetForm.peRess2.Path:=    f.ReadString('Paths','ress2','');
 CheckPathSpec;
 for a:=0 to 3 do
  FindRadio(a,f.ReadInteger('Open',Format('CB%d',[a]),1)).Checked:= True;
 If OpenForm.rb11.Checked or OpenForm.rb12.Checked then
  OpenForm.laCombo.ItemIndex:= f.ReadInteger('Open','Layout',-1);
 If OpenForm.rb21.Checked or OpenForm.rb22.Checked then
  OpenForm.grCombo.ItemIndex:= f.ReadInteger('Open','Grid',-1);
 CheckEnabled;
 OpenForm.brText.Caption:= f.ReadString( 'Open','BrkPath', '');
 OpenForm.paText.Caption:= f.ReadString( 'Open','PalPath', '');
 LibPath:=                 f.ReadString( 'Open','BllPath', '');
 LibIndex:=                f.ReadInteger('Open','BllIndex',0);
 If LibPath <> '' then begin
  If LowerCase(ExtractFileExt(LibPath)) <> '.hqr' then
   OpenForm.laText.Caption:= LibPath
  else if LibIndex >= 0 then
   OpenForm.laText.Caption:= LibPath+', entry ' + IntToStr(LibIndex + 1);
 end;
 GridPath:=  f.ReadString( 'Open','GriPath', '');
 GridIndex:= f.ReadInteger('Open','GriIndex',0);
 {If GridPath <> '' then begin
  If LowerCase(ExtractFileExt(GridPath)) <> '.hqr' then
   OpenForm.grText.Caption:= GridPath
  else if GridIndex >= 0 then
   OpenForm.grText.Caption:= GridPath+', entry '+IntToStr(GridIndex + 1);
 end; }
 OpenForm.cbAutoLib.Checked:= f.ReadBool(  'Open','AutoLibrary',     True);
 OpenForm.eLibIndex.Text:=    f.ReadString('Open','NewGridLibIndex', '0');
 OpenForm.eFragIndex.Text:=   f.ReadString('Open','NewGrigFragIndex','0');

 If f.ReadInteger('OpenSim','CB',1) = 1 then SimpleForm.rb21.Checked:= True
 else SimpleForm.rb22.Checked:= True;
 SimpleForm.grSimCombo.ItemIndex:= f.ReadInteger('OpenSim','RoomIndex',   -1);
 Form1.aHints.Checked:=            f.ReadBool(   'General','Hints',       True);
 Form1.aHintsExecute(Form1);
 Form1.aPlaced.Checked:=           f.ReadBool(   'General','PlacedFrames',False);
 Form1.cbFramesL.Checked:=         f.ReadBool(   'General','LayoutFrames',False);
 Form1.btNet.Down:=                f.ReadBool(   'General','Net',         True);
 Form1.btScNet.Down:=              f.ReadBool(   'General','SceneNet',    True);
 Form1.aHelper.Checked:=           f.ReadBool(   'General','Helper',      True);
 Form1.a3DHelper.Enabled:= Form1.aHelper.Checked;
 Form1.a3DHelper.Checked:=         f.ReadBool(   'General','3DHelper',    True);
 case f.ReadInteger('General','SelMode',0) of
  0: Form1.btSelBrk.Down:= True;
  1: Form1.btSelCol.Down:= True;
  else Form1.btSelObj.Down:= True;
 end;
 Form1.cbCursor.Checked:= f.ReadBool(   'General','ShowCursor',True);
 LtAlwaysOn:=             f.ReadBool(   'General','LtAlwaysOn',False);
 LastLtPos:=              f.ReadInteger('General','LastLtPos', 100);
 If LtAlwaysOn then begin
  Form1.paLayout.Width:= LastLtPos;
  Form1.pbLts.Width:= Form1.paLayout.Width - Form1.LScr.Width - 4;
 end;
 If f.ReadInteger('General','SelMethod',0) = 0 then Form1.btSelFnt.Down:= True
 else Form1.btSelFne.Down:= True;
 If f.ReadInteger('General','InvSelMode',0) = 0 then Form1.btInvBrk.Down:= True
 else Form1.btInvObj.Down:= True;
 SetForm.cbMainImg.Color:= f.ReadInteger('Colours','MainImg',  clWhite);
 SetForm.cbWinNet.Color:=  f.ReadInteger('Colours','WinNet',   clLime);
 SetForm.cbPanel.Color:=   f.ReadInteger('Colours','Panel',    clWhite);
 SetForm.cbPlaced.Color:=  f.ReadInteger('Colours','Placed',   clMoneyGreen);
 SetForm.cbCursor.Color:=  f.ReadInteger('Colours','Cursor',   clSkyBlue);
 SetForm.cbSelect.Color:=  f.ReadInteger('Colours','Select',   clFuchsia);
 SetForm.cbHelper.Color:=  f.ReadInteger('Colours','Helper',   clSkyBlue);
 SetForm.cbInvBrk.Color:=  f.ReadInteger('Colours','Invisible',clSilver);
 SetForm.cbShapes.Color:=  f.ReadInteger('Colours','Shapes',   clYellow);

 LastExpDir:=  f.ReadString('General','LastExportDir', AppPath);
 LastSaveDir:= f.ReadString('General','LastSaveDir',   AppPath);
 LastScenDir:= f.ReadString('General','LastScenDir',   AppPath);
 Minimized:=   f.ReadBool(  'General','InsMinimized', False);
 Advanced:=    f.ReadBool(  'General','InsAdvanced',  False);
 Form1.frClipping.btMinClick(Form1);
 Form1.frClipping.btReset.Down:= f.ReadBool('General','ResetAfterPlacing',True);
 SetForm.cbAskLayer.Checked:=    f.ReadBool('General','AskDelLayer',      True);
 Form1.btCoords.Down:=           f.ReadBool('General','ShowCoords',       True);
 Form1.btScCoords.Down:=         f.ReadBool('General','SceneCoords',      True);
 Form1.frClipping.btResetClick(Form1.frClipping.btReset);
 (Form1.frClipping.FindComponent('btPos'+IntToStr(f.ReadInteger('General','ClipPos',1))) as TSpeedButton).Down:= True;
 WheelSpeed:=   f.ReadInteger('General','WheelSpeed',  20);
 WheelAverage:= f.ReadInteger('General','WheelAverage',180);
 SetForm.cbDispCur.Checked:=   f.ReadBool('Coords','DispCursor',    True);
 SetForm.cbDispSel.Checked:=   f.ReadBool('Coords','DispSelection', True);
 SetForm.cbDispBrk.Checked:=   f.ReadBool('Coords','DispBrick',     True);
 SetForm.rbAtCursor.Checked:=  f.ReadBool('Coords','BrickAtCursor', True);
 SetForm.rbSelected.Checked:=  f.ReadBool('Coords','BrickSelected', False);
 //SetForm.cbDispScene.Checked:= f.ReadBool('Coords','DispScene',     True);
 SetForm.cbScenePix.Checked:=  f.ReadBool('Coords','ScenePixels',   True);
 SetForm.cbSceneBrk.Checked:=  f.ReadBool('Coords','SceneBricks',   False);
 SetForm.cbSceneClip.Checked:= f.ReadBool('Coords','SceneClip',     True);
 SetForm.cbSceneSel.Checked:=  f.ReadBool('Coords','SceneSelected', True);
 //SetForm.cbSceneCom.Checked:=  f.ReadBool('Coords','SceneCombined', False);
 SetForm.rbRangeSep.Checked:=  f.ReadBool('Coords','RangeSeparated',True);
 SetForm.rbRangeCon.Checked:=  f.ReadBool('Coords','RangeConnected',False);
 SetForm.cbRangeHide.Checked:= f.ReadBool('Coords','RangeHide',     True);
 SetForm.cbDispBrkClick(SetForm);
 SetForm.cbUseComp1.Checked:=  f.ReadBool('Saving','UseCompression1',True);
 SetForm.cbUseComp2.Checked:=  f.ReadBool('Saving','UseCompression2',True);
 SetForm.cbUseComp1Click(SetForm);
 IndexToRadio(SetForm,'rbComp1%d',f.ReadInteger('Saving','CompMode1',0));
 IndexToRadio(SetForm,'rbComp2%d',f.ReadInteger('Saving','CompMode2',0));
 SetForm.cbNewFrames.Checked:= f.ReadBool('General','UseNewFrames',True);
 If f.ReadBool('General','NewFramesEdge',False) then SetForm.rbNewFrEdge.Checked:= True
 else SetForm.rbNewFrObj.Checked:= True;
 UseNewFrames:= SetForm.cbNewFrames.Checked;
 SetForm.cbSaveSuperCompat.Checked:= f.ReadBool('General','SaveSuperCompat',True);
 //--- scene mode ---
 SetForm.cbScZone0.Color:=  f.ReadInteger('SceneCols','Zone0',8716164);
 SetForm.cbScZone1.Color:=  f.ReadInteger('SceneCols','Zone1',33023);
 SetForm.cbScZone2.Color:=  f.ReadInteger('SceneCols','Zone2',15712159);
 SetForm.cbScZone3.Color:=  f.ReadInteger('SceneCols','Zone3',16711935);
 SetForm.cbScZone4.Color:=  f.ReadInteger('SceneCols','Zone4',7143423);
 SetForm.cbScZone5.Color:=  f.ReadInteger('SceneCols','Zone5',255);
 SetForm.cbScZone6.Color:=  f.ReadInteger('SceneCols','Zone6',16733525);
 UpdateColours;
 Form1.btScTracks.Down:=    f.ReadBool(   'SceneVisible','Tracks',True);
 Form1.btScZones.Down:=     f.ReadBool(   'SceneVisible','Zones', True);
 Form1.btScActors.Down:=    f.ReadBool(   'SceneVisible','Actors',True);
 Form1.cbScZone0.Checked:=  f.ReadBool(   'SceneVisible','ZType0',True);
 Form1.cbScZone1.Checked:=  f.ReadBool(   'SceneVisible','ZType1',True);
 Form1.cbScZone2.Checked:=  f.ReadBool(   'SceneVisible','ZType2',True);
 Form1.cbScZone3.Checked:=  f.ReadBool(   'SceneVisible','ZType3',True);
 Form1.cbScZone4.Checked:=  f.ReadBool(   'SceneVisible','ZType4',True);
 Form1.cbScZone5.Checked:=  f.ReadBool(   'SceneVisible','ZType5',True);
 Form1.cbScZone6.Checked:=  f.ReadBool(   'SceneVisible','ZType6',True);
 Form1.cbScTracksClick(Form1);
 SetForm.cbSceneSnap.Checked:= f.ReadBool('SceneOptions','Snap',True);

 f.Free;
end;

procedure SaveSettings;
var f: TIniFile;
    a, b: Integer;
begin
 f:=TIniFile.Create(ExtractFilePath(Application.ExeName)+'Builder.ini');
 try
  f.WriteString('Paths','lba_brk',SetForm.peBrk.Path);
  f.WriteString('Paths','lba_bll',SetForm.peBll.Path);
  f.WriteString('Paths','lba_gri',SetForm.peGri.Path);
  f.WriteString('Paths','lba_bkg',SetForm.peBkg.Path);
  f.WriteString('Paths','sprites1' ,SetForm.peSprites1.Path);
  f.WriteString('Paths','ress1' ,SetForm.peRess1.Path);
  f.WriteString('Paths','sprites2' ,SetForm.peSprites2.Path);
  f.WriteString('Paths','ress2' ,SetForm.peRess2.Path);
  f.WriteInteger('Open','Layout',OpenForm.laCombo.ItemIndex);
  f.WriteInteger('Open','Grid',OpenForm.grCombo.ItemIndex);
  for a:=0 to 3 do
   for b:=1 to 3 do
    If FindRadio(a,b).Checked then
     f.WriteInteger('Open',Format('CB%d',[a]),b);
  f.WriteString( 'Open','BrkPath',         OpenForm.brText.Caption);
  f.WriteString( 'Open','PalPath',         OpenForm.paText.Caption);
  f.WriteString( 'Open','BllPath',         LibPath);
  f.WriteInteger('Open','BllIndex',        LibIndex);
  f.WriteString( 'Open','GriPath',         GridPath);
  f.WriteInteger('Open','GriIndex',        GridIndex);
  f.WriteBool(   'Open','AutoLibrary',     OpenForm.cbAutoLib.Checked);
  f.WriteString( 'Open','NewGridLibIndex', OpenForm.eLibIndex.Text);
  f.WriteString( 'Open','NewGrigFragIndex',OpenForm.eFragIndex.Text);
  f.WriteInteger('OpenSim','CB',           IfThen(SimpleForm.rb21.Checked,1,2));
  f.WriteInteger('OpenSim','RoomIndex',    SimpleForm.grSimCombo.ItemIndex);
  f.WriteBool(   'General','Hints',        Form1.aHints.Checked);
  f.WriteBool(   'General','PlacedFrames', Form1.aPlaced.Checked);
  f.WriteBool(   'General','LayoutFrames', Form1.cbFramesL.Checked);
  f.WriteBool(   'General','Net',          Form1.btNet.Down);
  f.WriteBool(   'General','SceneNet',     Form1.btScNet.Down);
  f.WriteBool(   'General','Helper',       Form1.aHelper.Checked);
  f.WriteBool(   'General','3DHelper',     Form1.a3DHelper.Checked);
  f.WriteInteger('General','SelMode',      IfThen(Form1.btSelBrk.Down,0,IfThen(Form1.btSelCol.Down,1,2)));
  f.WriteBool(   'General','ShowCursor',   Form1.cbCursor.Checked);
  f.WriteBool(   'General','LtAlwaysOn',   LtAlwaysOn);
  f.WriteInteger('General','LastLtPos',    LastLtPos);
  f.WriteInteger('General','SelMethod',    IfThen(Form1.btSelFnt.Down,0,1));
  f.WriteInteger('General','InvSelMode',   IfThen(Form1.btInvBrk.Down,0,1));
  f.WriteInteger('Colours','MainImg',      SetForm.cbMainImg.Color);
  f.WriteInteger('Colours','WinNet',       SetForm.cbWinNet.Color);
  f.WriteInteger('Colours','Panel',        SetForm.cbPanel.Color);
  f.WriteInteger('Colours','Placed',       SetForm.cbPlaced.Color);
  f.WriteInteger('Colours','Cursor',       SetForm.cbCursor.Color);
  f.WriteInteger('Colours','Select',       SetForm.cbSelect.Color);
  f.WriteInteger('Colours','Helper',       SetForm.cbHelper.Color);
  f.WriteInteger('Colours','Invisible',    SetForm.cbInvBrk.Color);
  f.WriteInteger('Colours','Shapes',       SetForm.cbShapes.Color);
  f.WriteString( 'General','LastExportDir',LastExpDir);
  f.WriteString( 'General','LastSaveDir',  LastSaveDir);
  f.WriteString( 'General','LastScenDir',  LastScenDir);
  f.WriteBool(   'General','InsMinimized', Minimized);
  f.WriteBool(   'General','InsAdvanced',  Advanced);
  f.WriteBool(   'General','ResetAfterPlacing',Form1.frClipping.btReset.Down);
  f.WriteBool(   'General','AskDelLayer',  SetForm.cbAskLayer.Checked);
  f.WriteBool(   'General','ShowCoords',   Form1.btCoords.Down);
  f.WriteBool(   'General','SceneCoords',  Form1.btScCoords.Down);
  f.WriteInteger('General','ClipPos',      IfThen(Form1.frClipping.btPos1.Down,1,
   IfThen(Form1.frClipping.btPos2.Down,2,IfThen(Form1.frClipping.btPos3.Down,3,4))));
  f.WriteInteger('General','WheelSpeed',   WheelSpeed);
  f.WriteInteger('General','WheelAverage', WheelAverage);
  f.WriteBool(   'Coords','DispCursor',     SetForm.cbDispCur.Checked);
  f.WriteBool(   'Coords','DispSelection',  SetForm.cbDispSel.Checked);
  f.WriteBool(   'Coords','DispBrick',      SetForm.cbDispBrk.Checked);
  f.WriteBool(   'Coords','BrickAtCursor',  SetForm.rbAtCursor.Checked);
  f.WriteBool(   'Coords','BrickSelected',  SetForm.rbSelected.Checked);
  //f.WriteBool(   'Coords','DispScene',      SetForm.cbDispScene.Checked);
  f.WriteBool(   'Coords','ScenePixels',    SetForm.cbScenePix.Checked);
  f.WriteBool(   'Coords','SceneBricks',    SetForm.cbSceneBrk.Checked);
  f.WriteBool(   'Coords','SceneClip',      SetForm.cbSceneClip.Checked);
  f.WriteBool(   'Coords','SceneSelected',  SetForm.cbSceneSel.Checked);
  //f.WriteBool(   'Coords','SceneCombined',  SetForm.cbSceneCom.Checked);
  f.WriteBool(   'Coords','RangeSeparated', SetForm.rbRangeSep.Checked);
  f.WriteBool(   'Coords','RangeConnected', SetForm.rbRangeCon.Checked);
  f.WriteBool(   'Coords','RangeHide',      SetForm.cbRangeHide.Checked);
  f.WriteBool(   'Saving','UseCompression1',SetForm.cbUseComp1.Checked);
  f.WriteBool(   'Saving','UseCompression2',SetForm.cbUseComp2.Checked);
  f.WriteInteger('Saving','CompMode1',      RadioToIndex(SetForm,'rbComp1%d',0,2));
  f.WriteInteger('Saving','CompMode2',      RadioToIndex(SetForm,'rbComp2%d',0,3));
  f.WriteBool(   'General','UseNewFrames',  SetForm.cbNewFrames.Checked);
  f.WriteBool(   'General','NewFramesEdge', SetForm.rbNewFrEdge.Checked);
  f.WriteBool(   'General','SaveSuperCompat',SetForm.cbSaveSuperCompat.Checked);
  //--- scene mode ---
  f.WriteInteger('SceneCols','Zone0',SetForm.cbScZone0.Color);
  f.WriteInteger('SceneCols','Zone1',SetForm.cbScZone1.Color);
  f.WriteInteger('SceneCols','Zone2',SetForm.cbScZone2.Color);
  f.WriteInteger('SceneCols','Zone3',SetForm.cbScZone3.Color);
  f.WriteInteger('SceneCols','Zone4',SetForm.cbScZone4.Color);
  f.WriteInteger('SceneCols','Zone5',SetForm.cbScZone5.Color);
  f.WriteInteger('SceneCols','Zone6',SetForm.cbScZone6.Color);
  f.WriteBool(   'SceneVisible','Tracks',Form1.btScTracks.Down);
  f.WriteBool(   'SceneVisible','Zones', Form1.btScZones.Down);
  f.WriteBool(   'SceneVisible','Actors',Form1.btScActors.Down);
  f.WriteBool(   'SceneVisible','ZType0',Form1.cbScZone0.Checked);
  f.WriteBool(   'SceneVisible','ZType1',Form1.cbScZone1.Checked);
  f.WriteBool(   'SceneVisible','ZType2',Form1.cbScZone2.Checked);
  f.WriteBool(   'SceneVisible','ZType3',Form1.cbScZone3.Checked);
  f.WriteBool(   'SceneVisible','ZType4',Form1.cbScZone4.Checked);
  f.WriteBool(   'SceneVisible','ZType5',Form1.cbScZone5.Checked);
  f.WriteBool(   'SceneVisible','ZType6',Form1.cbScZone6.Checked);
  f.WriteBool(   'SceneOptions','Snap',SetForm.cbSceneSnap.Checked);

 except
  MessageBox(Form1.Handle,'Can''t save settings!','Little Big Architect',MB_ICONWARNING+MB_OK);
 end;
 f.Free;
end;

procedure TSetForm.cbMainImgChange(Sender: TObject);
begin
 If SetForm.Visible then begin
  UpdateColours;
  DrawMapA;
  PaintLayouts;
 end;
end;

procedure TSetForm.cbResetClick(Sender: TObject);
begin
 Form1.frClipping.btResetClick(Sender);
end;

procedure TSetForm.btRestColClick(Sender: TObject);
begin
 SetForm.cbMainImg.Color:=clWhite;
 SetForm.cbWinNet.Color:=clLime;
 SetForm.cbPanel.Color:=clWhite;
 SetForm.cbPlaced.Color:=clMoneyGreen;
 SetForm.cbCursor.Color:=clSkyBlue;
 SetForm.cbSelect.Color:=clFuchsia;
 SetForm.cbHelper.Color:=clSkyBlue;
 SetForm.cbInvBrk.Color:=clSilver;
 SetForm.cbShapes.Color:=clYellow;
 cbMainImgChange(Self);
end;

procedure TSetForm.cbDispBrkClick(Sender: TObject);
begin
 rbAtCursor.Enabled:= cbDispBrk.Checked;
 rbSelected.Enabled:= cbDispBrk.Checked;
 //cbScenePix.Enabled:= cbDispScene.Checked;
 //cbSceneBrk.Enabled:= cbDispScene.Checked;
 //cbSceneCom.Enabled:= cbDispScene.Checked;
 cbRangeHide.Enabled:= rbRangeCon.Checked;
end;

procedure TSetForm.cbUseComp1Click(Sender: TObject);
begin
 rbComp10.Enabled:= cbUseComp1.Checked;
 rbComp11.Enabled:= cbUseComp1.Checked;
 rbComp12.Enabled:= cbUseComp1.Checked;
 rbComp20.Enabled:= cbUseComp2.Checked;
 rbComp21.Enabled:= cbUseComp2.Checked;
 rbComp22.Enabled:= cbUseComp2.Checked;
 rbComp23.Enabled:= cbUseComp2.Checked;
end;

procedure TSetForm.cbNewFramesClick(Sender: TObject);
begin
 UseNewFrames:= cbNewFrames.Checked;
 If Form1.pbGrid.Visible and UseNewFrames then SetAllFrameLines;
 DrawMapA;
end;

procedure TSetForm.peBrkPathChange(Sender: TObject; var Path: TFileName);
begin
 CheckPathSpec;
end;

end.
