unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, ComCtrls, ShellApi, DePack, Editing, FileCtrl, Math,
  CommCtrl, Projects, ActnList, ToolWin, Building, Settings, ImgList;

type
  TListView = class(ComCtrls.TListView)
  private
    procedure WMNotify(var Message: TWMNotify); message WM_NOTIFY;
  end; 

  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    mOpen: TMenuItem;
    mSave: TMenuItem;
    mSaveAs: TMenuItem;
    N1: TMenuItem;
    lvList: TListView;
    Actions1: TMenuItem;
    mCompile: TMenuItem;
    N4: TMenuItem;
    mProjectOpts: TMenuItem;
    mEdit: TMenuItem;
    mSettings: TMenuItem;
    StatusBar1: TStatusBar;
    mDropExisting: TPopupMenu;
    Droppingonanexistingline1: TMenuItem;
    N5: TMenuItem;
    mDropReplaceLine: TMenuItem;
    mDropInsertLine: TMenuItem;
    mNew: TMenuItem;
    mListMenu: TPopupMenu;
    mClearCell: TMenuItem;
    mClearRows: TMenuItem;
    mDeleteRows: TMenuItem;
    mMoveToTop: TMenuItem;
    N6: TMenuItem;
    mMoveUp: TMenuItem;
    mMoveDown: TMenuItem;
    mMoveToBottom: TMenuItem;
    mSetBlank: TMenuItem;
    N7: TMenuItem;
    dlOpen: TOpenDialog;
    dlSave: TSaveDialog;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ActionList1: TActionList;
    aOpenProject: TAction;
    aNewProject: TAction;
    aSaveProject: TAction;
    aSaveProjectAs: TAction;
    aProjectOptions: TAction;
    aBuildProject: TAction;
    N8: TMenuItem;
    mManualEdit: TMenuItem;
    mNewMenu: TPopupMenu;
    mAddRow: TMenuItem;
    mInsertRow: TMenuItem;
    aAddLine: TAction;
    aInsertLine: TAction;
    aSettings: TAction;
    mDropFillColumn: TMenuItem;
    N9: TMenuItem;
    MenuImages: TImageList;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    ToolButton9: TToolButton;
    aUndo: TAction;
    aRedo: TAction;
    N2: TMenuItem;
    Addemptyrow1: TMenuItem;
    N3: TMenuItem;
    Deleteselectedrows1: TMenuItem;
    N10: TMenuItem;
    Undo1: TMenuItem;
    Redo1: TMenuItem;
    ToolButton10: TToolButton;
    ToolButton11: TToolButton;
    ToolButton12: TToolButton;
    ToolButton13: TToolButton;
    aDelSelected: TAction;
    procedure FormCreate(Sender: TObject);
    procedure lvListDrawItem(Sender: TCustomListView; Item: TListItem;
      Rect: TRect; State: TOwnerDrawState);
    procedure lvListCustomDraw(Sender: TCustomListView; const ARect: TRect;
      var DefaultDraw: Boolean);
    procedure lvListKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure mDropInsertLineClick(Sender: TObject);
    procedure mClearCellClick(Sender: TObject);
    procedure lvListMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure mMoveToTopClick(Sender: TObject);
    procedure lvListResize(Sender: TObject);
    procedure aProjectOptionsClick(Sender: TObject);
    procedure mSettingsClick(Sender: TObject);
    procedure aOpenProjectClick(Sender: TObject);
    procedure aSaveProjectClick(Sender: TObject);
    procedure aSaveProjectAsClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure aNewProjectExecute(Sender: TObject);
    procedure aBuildProjectExecute(Sender: TObject);
    procedure aAddLineExecute(Sender: TObject);
    procedure aSettingsExecute(Sender: TObject);
    procedure aUndoExecute(Sender: TObject);
    procedure aRedoExecute(Sender: TObject);
    procedure aDelSelectedExecute(Sender: TObject);
    procedure mEditClick(Sender: TObject);
  private
    { Private declarations }
  public
    procedure AppMessage(var Msg: TMsg; var Handled: Boolean);
    procedure AppException(Sender: TObject; E: Exception);
    Procedure AppShowHint(var HintStr: String; var CanShow: Boolean;
     var HintInfo: THintInfo);
    procedure WMDropFiles(hDrop: THandle; hWindow: HWnd); 
  end;

var
  Form1: TForm1;

function ProjectSaveAs(): Boolean;

implementation

{$R *.dfm}

//Poprawka do TListView (by Tocbac & Pawe Maniawski)
procedure TListView.WMNotify(var Message: TWMNotify);
var Item: Integer;
    NewWidth: LongInt;
begin
 if ((Message.NMHdr^.code = HDN_ITEMCHANGEDW) or
     (Message.NMHdr^.code = HDN_ITEMCHANGEDA)) then begin
  Item := PHDNotify(Pointer(Message.NMHdr))^.Item;
  NewWidth := ListView_GetColumnWidth(Handle, Item);
  if ((Column[Item].MinWidth > 0) and (NewWidth < Column[Item].MinWidth)) then
   NewWidth := Column[Item].MinWidth;
  if ((Column[Item].MaxWidth > 0) and (NewWidth > Column[Item].MaxWidth)) then
   NewWidth := Column[Item].MaxWidth;
  Column[Item].Width := NewWidth;
 end;
 inherited;
end;

function CheckModified(): Boolean;
begin
 Result:= True;
 If ProjectModified then
  Case MessageBox(Form1.Handle,'Current Project has been modified. Save the changes?','Little Stage Designer',MB_ICONQUESTION + MB_YESNOCANCEL)
  of
   ID_YES: If CurrentProject = '' then Result:= ProjectSaveAs()
                                  else SaveProject(CurrentProject);
   ID_CANCEL: Result:= False;
  end;
end;

//obsuga Drag & Drop

procedure TForm1.WMDropFiles(hDrop: THandle; hWindow: HWnd);
var
  TotalNumberOfFiles, nFileLength: Integer;
  pszFileName: PChar;
  DropPoint, ListPoint: TPoint;
  Temp: TListItem;
begin
  //liczba zrzuconych plikw
  TotalNumberOfFiles:= DragQueryFile(hDrop,$FFFFFFFF,nil,0);
  If TotalNumberOfFiles = 1 then begin
   nFileLength:= DragQueryFile(hDrop,0,Nil,0) + 1;
   GetMem(pszFileName,nFileLength);
   DragQueryFile(hDrop,0,pszFileName,nFileLength);
   DragQueryPoint(hDrop,DropPoint);
   //pszFileName - nazwa upuszczonego pliku
   //tutaj robimy co z nazw pliku
   If ControlAtPos(DropPoint,False,True).Name = 'lvList' then begin
    ListPoint:= lvList.ParentToClient(DropPoint);
    Temp:= lvList.GetItemAt(ListPoint.x,ListPoint.y);
    If Assigned(Temp) then begin
     IndexTemp:= Temp.Index;
     XTemp:= ListPoint.x;
     PathTemp:= pszFileName;
     ListPoint:= ClientToScreen(DropPoint);
     lvList.ClearSelection;
     lvList.Selected:= Temp;
     mDropExisting.Popup(ListPoint.x, ListPoint.y);
    end
    else
     AddFileAuto(-1, ListPoint.x, pszFileName);
   end
   else begin
    try    //eby wykonao si FreeMem jeeli bdzie bd
     If ExtIs(pszFileName,'.sdp') then begin
      CheckModified();
      LoadProject(pszFileName);
     end
     else Beep; 
    except
    end;
   end;

   FreeMem(pszFileName,nFileLength);
  end
  else
   MessageBox(handle,'One file at a time, please.','Little Stage Designer',MB_ICONWARNING+MB_OK);

  DragFinish(hDrop);
end;

procedure TForm1.AppMessage(var Msg: TMsg; var Handled: Boolean);
begin
  case Msg.Message of
   WM_DROPFILES: WMDropFiles(Msg.wParam, Msg.hWnd);
  end;
end;

procedure TForm1.AppException(Sender: TObject; E: Exception);
begin
 //If ProgBarForm.Visible then ProgBarForm.Close;
 //if fSettings.Visible then fSettings.Close;
 //if fExtract.Visible then fExtract.Close;

 Screen.Cursor:= crArrow;
 MessageBox(handle,PChar('Little Stage Designer has risen an exception called: "'+E.Message+'" and may be unstable. Please save all changes and restart the program as soon as possible.'),'Little Stage Designer',MB_ICONWARNING+MB_OK);
end;

Procedure TForm1.AppShowHint(var HintStr: String; var CanShow: Boolean;
 var HintInfo: THintInfo);
var ARow, ACol: Integer;
    p: TPoint;
    s: String;
begin
 {If HintInfo.HintControl is TLabel then begin
  HintInfo.HintWindowClass:=THintLabel;
  HintInfo.HintPos.X:=HintInfo.HintControl.ClientOrigin.X-3;
  HintInfo.HintPos.Y:=HintInfo.HintControl.ClientOrigin.Y-1;
 end
 else if HintInfo.HintControl = FileList then begin
  p:=FileList.ScreenToClient(Mouse.CursorPos);
  FileList.MouseToCell(p.X,p.Y,ACol,ARow);
  CanShow:=False;
  If (FileList.ColCount>=ACol) and (FileList.RowCount>=ARow) then begin
   s:=FileList.Cells[ACol,ARow];
   If (s<>'') and ((ACol=7) or (ACol=8))
   and ((FileList.Canvas.TextWidth(s)>FileList.ColWidths[ACol]-2)
   or ((ACol=8) and (s<>Entries[DispMap[ARow]].Replace) and (s[1]<>'>'))) then begin
    HintInfo.HintWindowClass:=THintList;
    If ACol=8 then begin
     HintStr:=Entries[DispMap[ARow]].Replace;
     HintParam:=-1;
    end
    else begin
     HintStr:=s;
     HintParam:=Entries[DispMap[ARow]].ExtIndex;
    end;
    HintInfo.HintData:=@HintParam;
    p:=FileList.ClientToScreen(FileList.CellRect(ACol,ARow).TopLeft);
    HintInfo.HintPos.X:=p.X-1;
    HintInfo.HintPos.Y:=p.Y-1;
    HintInfo.ReshowTimeout:=100;
    CanShow:=True;
   end;
  end;
 end;}
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 Application.OnMessage:= AppMessage;
 Application.OnException:= AppException;
 Application.OnShowHint:= AppShowHint;
 DragAcceptFiles(Form1.Handle,True);
 lvList.DoubleBuffered:= True;
end;

procedure TForm1.lvListDrawItem(Sender: TCustomListView; Item: TListItem;
  Rect: TRect; State: TOwnerDrawState);
var a, mw: Integer;
begin
 //Sender.Canvas.Brush.Style:= bsSolid;
 //Sender.Canvas.FillRect(Rect);

 Sender.Canvas.Brush.Style:= bsSolid;
 If odSelected in State then begin
  Sender.Canvas.Pen.Color:= clBlue;
  Sender.Canvas.Brush.Color:= clSkyBlue;
  Sender.Canvas.Rectangle(Rect);//.Left, Rect.Top - 1, Rect.Right, Rect.Bottom);
 end;

// else begin
  Sender.Canvas.Brush.Color:= $00A0A0FF;
  a:= Sender.Column[0].Width;
  If not TheList[Item.Index].GridEx then
   Sender.Canvas.FillRect(Classes.Rect(a,Rect.Top,a+Sender.Column[1].Width-1,Rect.Bottom-1));
  a:= a + Sender.Column[1].Width;
  If not TheList[Item.Index].LibEx then
   Sender.Canvas.FillRect(Classes.Rect(a,Rect.Top,a+Sender.Column[2].Width-1,Rect.Bottom-1));
  a:= a + Sender.Column[2].Width;
  If not TheList[Item.Index].BrickEx then
   Sender.Canvas.FillRect(Classes.Rect(a,Rect.Top,a+Sender.Column[3].Width-1,Rect.Bottom-1));
  a:= a + Sender.Column[3].Width;
  If not TheList[Item.Index].SceneEx then
   Sender.Canvas.FillRect(Classes.Rect(a,Rect.Top,a+Sender.Column[4].Width-1,Rect.Bottom-1));
 //end;
 Sender.Canvas.Brush.Style:= bsClear;
 If odSelected in State then begin
  Sender.Canvas.Rectangle(Rect);
  mw:= Sender.Column[0].Width;
  for a:= 1 to (Sender as TListView).Columns.Count - 1 do begin
   Sender.Canvas.MoveTo(mw - 1, Rect.Top);
   Sender.Canvas.LineTo(mw - 1, Rect.Bottom);
   Inc(mw, Sender.Column[a].Width);
  end;
 end;

 Sender.Canvas.Font.Color:= clBlack;

 Sender.Canvas.TextOut(Rect.Left, Rect.Top, IntToStr(Item.Index + 1));
 a:= Sender.Column[0].Width;
 Sender.Canvas.TextOut(Rect.Left + a, Rect.Top,
  MinimizeName(TheList[Item.Index].GridPath, Sender.Canvas, Sender.Column[1].Width - 1));
 a:= a + Sender.Column[1].Width;
 Sender.Canvas.TextOut(Rect.Left + a, Rect.Top,
  MinimizeName(TheList[Item.Index].LibPath, Sender.Canvas, Sender.Column[2].Width - 1));
 a:= a + Sender.Column[2].Width;
 Sender.Canvas.TextOut(Rect.Left + a, Rect.Top,
  Minimizename(TheList[Item.Index].BrickPath, Sender.Canvas, Sender.Column[3].Width - 1));
 a:= a + Sender.Column[3].Width;
 Sender.Canvas.TextOut(Rect.Left + a, Rect.Top,
  Minimizename(TheList[Item.Index].ScenePath, Sender.Canvas, Sender.Column[4].Width - 1));

 //Siatka:
 //Sender.Canvas.Pen.Color:= clBtnFace;
 //Sender.Canvas.Brush.Style:= bsClear;
 //Sender.Canvas.Rectangle(Rect);
end;

procedure TForm1.lvListCustomDraw(Sender: TCustomListView;
  const ARect: TRect; var DefaultDraw: Boolean);
var a, ih, mw, rows, cc: Integer;
    Temp: TRect;
begin
 Sender.Canvas.Brush.Style:= bsSolid;
 Sender.Canvas.FillRect(ARect);
 //Siatka:
 If (Sender as TListView).Items.Count > 0 then begin
  Sender.Canvas.Pen.Color:= clBtnFace;
  rows:= Min(Sender.VisibleRowCount, (Sender as TListView).Items.Count);
  cc:= (Sender as TListView).Columns.Count;
  Temp:= (Sender as TListView).Items.Item[0].DisplayRect(drBounds);
  ih:= Temp.Bottom - Temp.Top;
  mw:= 0;
  for a:= 0 to cc do begin
   Sender.Canvas.MoveTo(mw - 1, ARect.Top);
   Sender.Canvas.LineTo(mw - 1, rows * ih + 19);
   If a < cc then Inc(mw, Sender.Column[a].Width);
  end;
  for a:= 0 to rows do begin
   Sender.Canvas.MoveTo(ARect.Left, a * ih + 18);
   Sender.Canvas.LineTo(mw - 1, a * ih + 18);
  end;
 end;
end;

procedure TForm1.lvListKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 StatusBar1.SimpleText:= IntToStr(Key);
 case Key of
  46: DeleteSelectedFiles(); //Del
  38: If ssCtrl in Shift then MoveSelectedUp(); //Up
  40: If ssCtrl in Shift then MoveSelectedDown(); //Down
 end;
end;

procedure TForm1.mDropInsertLineClick(Sender: TObject);
var a: Integer;
begin
 If Sender = mDropInsertLine then
  AddFileAuto(IndexTemp, XTemp, PathTemp)
 else if Sender = mDropReplaceLine then
  SetListItem(IndexTemp, GetColumn(XTemp), PathTemp, True)
 else if Sender = mDropFillColumn then begin
  SetUndo();
  for a:= 0 to High(TheList) do
   SetListItem(a, GetColumn(XTemp), PathTemp)
 end;  
end;

procedure TForm1.mClearCellClick(Sender: TObject);
var a: Integer;
begin
 If Sender = mClearCell then SetListItem(IndexTemp, XTemp, '', True)
 else if Sender = mSetBlank then SetListItem(IndexTemp, XTemp, '<B>', True)
 else if Sender = mClearRows then begin
  If lvList.SelCount > 0 then begin
   SetUndo();
   for a:= 0 to lvList.Items.Count - 1 do
    If lvList.Items.Item[a].Selected then SetListItem(a, 0, '');
  end;
 end;
end;

procedure TForm1.lvListMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var a: Integer;
    //Temp: TListItem;
    p: TPoint;
begin
 If Button = mbRight then begin
  a:= GetColumn(X);
  p:= ClientToScreen(Point(X, Y));
  //Temp:= lvList.GetItemAt(X, Y);
  If Assigned(lvList.Selected) and (a >= 1) and (a <= 4) then begin
   IndexTemp:= lvList.Selected.Index;
   XTemp:= a;
   //lvList.ClearSelection;
   //lvList.Selected:= Temp;
   mEditClick(Self);
   mListMenu.Popup(p.X, p.Y);
  end
  else
   mNewMenu.Popup(p.X, p.Y);
 end;
end;

procedure TForm1.mMoveToTopClick(Sender: TObject);
begin
 If Sender = mMoveToTop then MoveSelectedToTop()
 else if Sender = mMoveToBottom then MoveSelectedToBottom()
 else if Sender = mMoveUp then MoveSelectedUp()
 else if Sender = mMoveDown then MoveSelectedDown();
 lvList.Repaint();
end;

procedure TForm1.lvListResize(Sender: TObject);
begin
 //StatusBar1.SimpleText:= IntToStr(lvList.Columns.Items[0].Width);
 //lvList.Columns.Items.WidthType
end;

procedure TForm1.aProjectOptionsClick(Sender: TObject);
begin
 fmProject.ShowOptions();
end;

procedure TForm1.mSettingsClick(Sender: TObject);
begin
 fmSettings.ShowSettings();
end;

procedure TForm1.aOpenProjectClick(Sender: TObject);
begin
 CheckModified();
 dlOpen.InitialDir:= MainSettings.LastProjectDir;
 If dlOpen.Execute then begin
  MainSettings.LastProjectDir:= ExtractFilePath(dlOpen.FileName);
  MainSettings.LastProject:= dlOpen.FileName;
  LoadProject(dlOpen.FileName);
 end;
end;

function ProjectSaveAs(): Boolean;
begin
 Result:= False;
 Form1.dlSave.InitialDir:= MainSettings.LastProjectDir;
 If Form1.dlSave.Execute then begin
  MainSettings.LastProjectDir:= ExtractFilePath(Form1.dlSave.FileName);
  If not ExtIs(Form1.dlSave.FileName,'.sdp') then
   Form1.dlSave.FileName:= Form1.dlSave.FileName + '.sdp';
  MainSettings.LastProject:= Form1.dlSave.FileName;
  SaveProject(Form1.dlSave.FileName);
  Result:= True;
 end;
end;

procedure TForm1.aSaveProjectClick(Sender: TObject);
begin
 If CurrentProject = '' then ProjectSaveAs() else SaveProject(CurrentProject);
end;

procedure TForm1.aSaveProjectAsClick(Sender: TObject);
begin
 ProjectSaveAs();
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 If CheckModified() then UnloadProject()
                    else Action:= caNone;
end;

procedure TForm1.aNewProjectExecute(Sender: TObject);
begin
 If CheckModified() then UnloadProject();
end;

procedure TForm1.aBuildProjectExecute(Sender: TObject);
begin
 If ProjectModified and MainSettings.AutoSave
 and not ((CurrentProject = '') and MainSettings.NoASForce) then
  aSaveProject.Execute;
 BuildProject();
end;

procedure TForm1.aAddLineExecute(Sender: TObject);
begin
 If Sender = aInsertLine then AddFileAuto(IndexTemp, 0, '')
                         else AddFileAuto(-1, 0, '');
end;

procedure TForm1.aSettingsExecute(Sender: TObject);
begin
 fmSettings.ShowSettings();
end;

procedure TForm1.aUndoExecute(Sender: TObject);
begin
 DoUndo();
end;

procedure TForm1.aRedoExecute(Sender: TObject);
begin
 DoRedo();
end;

procedure TForm1.aDelSelectedExecute(Sender: TObject);
begin
 DeleteSelectedFiles();
end;

procedure TForm1.mEditClick(Sender: TObject);
begin
 aDelSelected.Enabled:= lvList.SelCount > 0;
end;

end.
