unit Projects;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, PathEdit, StdCtrls, Buttons, ComCtrls, ExtCtrls, IniFiles, DePack;

type
  TfmProject = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    GroupBox1: TGroupBox;
    rb1CompNone: TRadioButton;
    rb1CompAlways: TRadioButton;
    rb1CompAuto: TRadioButton;
    GroupBox2: TGroupBox;
    rb2CompNone: TRadioButton;
    rb2CompAuto: TRadioButton;
    rb2CompAlways1: TRadioButton;
    rb2CompAlways2: TRadioButton;
    GroupBox3: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label4: TLabel;
    Label3: TLabel;
    Label5: TLabel;
    eMinSizeBenefit: TEdit;
    cbMinSizeBenefit: TComboBox;
    eMinTimeBenefit: TEdit;
    eMaxSizeLoss: TEdit;
    cbMaxSizeLoss: TComboBox;
    cbMinTimeBenefit: TComboBox;
    btOK: TBitBtn;
    btCancel: TBitBtn;
    TabSheet2: TTabSheet;
    cbUseRepeated: TCheckBox;
    TabSheet3: TTabSheet;
    cbOutputSce: TCheckBox;
    peOutputSce: TPathEdit;
    GroupBox5: TGroupBox;
    cbBrkForceInv: TCheckBox;
    eBrkForceInv: TEdit;
    cbLtsRemUnused: TCheckBox;
    cbBrkRemDoubled: TCheckBox;
    GroupBox6: TGroupBox;
    Panel1: TPanel;
    rb2AutoBoth: TRadioButton;
    rb2AutoOnly1: TRadioButton;
    rb2AutoOnly2: TRadioButton;
    rbOutputType1: TRadioButton;
    Label8: TLabel;
    rbOutputType2: TRadioButton;
    pcOutFiles: TPageControl;
    tsOutLBA1: TTabSheet;
    tsOutLBA2: TTabSheet;
    GroupBox4: TGroupBox;
    Label6: TLabel;
    Label7: TLabel;
    cbOutputGri: TCheckBox;
    peOutputGri: TPathEdit;
    cbOutputBllBrk: TCheckBox;
    peOutputBll: TPathEdit;
    peOutputBrk: TPathEdit;
    GroupBox7: TGroupBox;
    cbOutputBkg: TCheckBox;
    peOutputBkg: TPathEdit;
    TabSheet4: TTabSheet;
    meDescription: TMemo;
    Label9: TLabel;
  private
    { Private declarations }
  public
    Procedure ShowOptions();
  end;


var
  fmProject: TfmProject;
  f: TMemIniFile;
  CurrentProject: String = '';
  ProjectModified: Boolean = False;

  ProjectOptions: record
   Compression: record
    Lba1: Integer; // 0 = none, 1 = always type 1, 3 = auto
    Lba2: Integer; // 0 = none, 1 = always 1, 2 = always 2, 3 = auto
    Lba2Auto: Integer; // 0 = both, 1 = type 1 only, 2 = type 2 only
    MinSizeBenVal: Single;
    MinSizeBenUnit: Integer; // 0 = %, 1 = kB
    MinTimeBenVal: Single;
    MinTimeBenUnit: Integer; // 0 = %, 1 = sec.
    MaxSizeLossVal: Single;
    MaxSizeLossUnit: Integer; // 0 = %, 1 = kB
   end;
   Optimizations: record
    UseRepeated: Boolean;
    BricksRemoveUnused: Boolean;
    BricksRemoveDoubled: Boolean;
    ForceInvisibleBrick: Boolean;
    ForceInvBrickValue: Integer;
    LayoutsRemoveUnused: Boolean;
   end;
   Output: record
    OutputType: Integer; // 1 = LBA 1, 2 = LBA 2;
    Lba1OutputGrid: Boolean;
    Lba1GridPath: String;
    Lba1OutputLibBrk: Boolean;
    Lba1LibraryPath: String;
    Lba1BrickPath: String;
    Lba2OutputBkg: Boolean;
    Lba2BkgPath: String;
    OutputScene: Boolean;
    ScenePath: String;
   end;
   Description: TStringList;
  end = (Compression: (Lba1: 3; Lba2: 3; Lba2Auto: 0; MinSizeBenVal: 1; MinSizeBenUnit: 0;
                       MinTimeBenVal: 1; MinTimeBenUnit: 0; MaxSizeLossVal: 1;
                       MaxSizeLossUnit: 0);
         Optimizations: (UseRepeated: True; BricksRemoveUnused: True;
                         BricksRemoveDoubled: True; ForceInvisibleBrick: False;
                         ForceInvBrickValue: 0; LayoutsRemoveUnused: False);
         Output: (OutputType: 1; Lba1OutputGrid: True; Lba1GridPath: '';
                  Lba1OutputLibBrk: True; Lba1LibraryPath: ''; Lba1BrickPath: '';
                  Lba2OutputBkg: True; Lba2BkgPath: ''; OutputScene: True; ScenePath: '')
        );

function CheckExistingLine(Line: Integer): Boolean;
Procedure LoadProject(path: String);
Procedure SaveProject(path: String);
procedure UnloadProject();
procedure SetProjectModified(val: Boolean);

implementation

uses Main, Editing;

{$R *.dfm}

function CheckExistingLine(Line: Integer): Boolean;
begin
 TheList[Line].GridEx:= (not ProjectOptions.Output.Lba1OutputGrid)
   or (TheList[Line].GridPath = '<B>')
   or (FileExists(TheList[Line].GridPath)
       and (ExtIs(TheList[Line].GridPath,'.gr1') or ExtIs(TheList[Line].GridPath,'.hqs')));
 TheList[Line].LibEx:= (not ProjectOptions.Output.Lba1OutputLibBrk)
   or (TheList[Line].LibPath = '<B>')
   or (FileExists(TheList[Line].LibPath)
       and (ExtIs(TheList[Line].LibPath,'.bl1') or ExtIs(TheList[Line].LibPath,'.hqs')));
 TheList[Line].BrickEx:= (not ProjectOptions.Output.Lba1OutputLibBrk)
   or (TheList[Line].BrickPath = '<B>')
   or (FileExists(TheList[Line].BrickPath)
       and (ExtIs(TheList[Line].BrickPath,'.hqr') or ExtIs(TheList[Line].BrickPath,'.hqs')));
 TheList[Line].SceneEx:= (not ProjectOptions.Output.OutputScene)
   or (TheList[Line].ScenePath = '<B>')
   or (FileExists(TheList[Line].ScenePath)
       and (ExtIs(TheList[Line].ScenePath,'.ls1') or ExtIs(TheList[Line].ScenePath,'.hqs')));
       
 Result:= TheList[Line].GridEx  and TheList[Line].LibEx
      and TheList[Line].BrickEx and TheList[Line].SceneEx;
end;

procedure CheckExistingFiles();
var a: Integer;
    NEFound: Boolean;
begin
 NEFound:= False;
 for a:= 0 to High(TheList) do
  If not CheckExistingLine(a) then NEFound:= True;
 If NEFound then
  MessageBox(Form1.Handle,'Some of the files on the list don''t exist, the paths are invalid, cells are empty, or extensions are not appropriate. You will have to make sure all cells contain correct files, otherwise you will not be able to build the project.'#13#13
                        + 'Invalid cells have been marked in red.','Little Stage Designer',MB_ICONWARNING+MB_OK);
end;

procedure CheckValues(var Subject: Integer; Values: array of Integer;
 DefaultIndex: Integer = 0);
var a: Integer;
begin
 for a:= 0 to High(Values) do
  If Subject = Values[a] then Exit;
 Subject:= Values[DefaultIndex];
end;

Procedure CheckRange(var Subject: Integer; Min, Max, Default: Integer); overload;
begin
 If (Subject < Min) or (Subject > Max) then Subject:= Default;
end;

Procedure CheckRange(var Subject: Single; Min, Max, Default: Single); overload;
begin
 If (Subject < Min) or (Subject > Max) then Subject:= Default;
end;

Procedure TfmProject.ShowOptions();
var sb, tb, sl: Single;
    bi: Integer;
begin
 Case ProjectOptions.Compression.Lba1 of
  0: rb1CompNone.Checked:= True;
  1: rb1CompAlways.Checked:= True;
  else rb1CompAuto.Checked:= True;
 end;
 Case ProjectOptions.Compression.Lba2 of
  0: rb2CompNone.Checked:= True;
  1: rb2CompAlways1.Checked:= True;
  2: rb2CompAlways2.Checked:= True;
  else rb2CompAuto.Checked:= True;
 end;
 Case ProjectOptions.Compression.Lba2Auto of
  0: rb2AutoBoth.Checked:= True;
  1: rb2AutoOnly1.Checked:= True;
  else rb2AutoOnly2.Checked:= True;
 end;
 eMinSizeBenefit.Text:= Format('%f',[ProjectOptions.Compression.MinSizeBenVal]);
 cbMinSizeBenefit.ItemIndex:= ProjectOptions.Compression.MinSizeBenUnit;
 eMinTimeBenefit.Text:= Format('%f',[ProjectOptions.Compression.MinTimeBenVal]);
 cbMinTimeBenefit.ItemIndex:= ProjectOptions.Compression.MinTimeBenUnit;
 eMaxSizeLoss.Text:= Format('%f',[ProjectOptions.Compression.MaxSizeLossVal]);
 cbMaxSizeLoss.ItemIndex:= ProjectOptions.Compression.MaxSizeLossUnit;
 cbUseRepeated.Checked:= ProjectOptions.Optimizations.UseRepeated;
 //cbBrkRemUnused.Checked:= ProjectOptions.Optimizations.BricksRemoveUnused;
 cbLtsRemUnused.Checked:= ProjectOptions.Optimizations.LayoutsRemoveUnused;
 cbBrkRemDoubled.Checked:= ProjectOptions.Optimizations.BricksRemoveDoubled;
 cbBrkForceInv.Checked:= ProjectOptions.Optimizations.ForceInvisibleBrick;
 eBrkForceInv.Text:= IntToStr(ProjectOptions.Optimizations.ForceInvBrickValue);
 If ProjectOptions.Output.OutputType = 1 then rbOutputType1.Checked:= True
                                         else rbOutputType2.Checked:= True;
 cbOutputGri.Checked:= ProjectOptions.Output.Lba1OutputGrid;
 peOutputGri.Path:= ProjectOptions.Output.Lba1GridPath;
 cbOutputBllBrk.Checked:= ProjectOptions.Output.Lba1OutputLibBrk;
 peOutputBll.Path:= ProjectOptions.Output.Lba1LibraryPath;
 peOutputBrk.Path:= ProjectOptions.Output.Lba1BrickPath;
 cbOutputBkg.Checked:= ProjectOptions.Output.Lba2OutputBkg;
 peOutputBkg.Path:= ProjectOptions.Output.Lba2BkgPath;
 cbOutputSce.Checked:= ProjectOptions.Output.OutputScene;
 peOutputSce.Path:= ProjectOptions.Output.ScenePath;
 meDescription.Lines.Assign(ProjectOptions.Description);
 While (ShowModal = mrOK)
 and not (TryStrToFloat(eMinSizeBenefit.Text,sb) and (sb >= 0)
      and TryStrToFloat(eMinTimeBenefit.Text,tb) and (tb >= 0)
      and TryStrToFloat(eMaxSizeLoss.Text,sl)    and (sl >= 0)
      and TryStrToInt(eBrkForceInv.Text,bi)      and (bi >= 0)) do
  MessageBox(Handle,'At leas one of the fields contains invalid number!'#13#13
                  + 'Fields "file size benefit is at least", "time benefit is at least" and "size loss is not higher than" should contain real numbers, greater or equal to zero.'#13
                  + 'Field "Force the invisible Brick at specific position" should contain and integer number, greater or equal to zero.','Stage Designer',MB_ICONERROR+MB_OK);
 If ModalResult = mrOK then begin
  If rb1CompNone.Checked then ProjectOptions.Compression.Lba1:= 0
  else if rb1CompAlways.Checked then ProjectOptions.Compression.Lba1:= 1
  else ProjectOptions.Compression.Lba1:= 3;
  If rb2CompNone.Checked then ProjectOptions.Compression.Lba2:= 0
  else if rb2CompAlways1.Checked then ProjectOptions.Compression.Lba2:= 1
  else if rb2CompAlways2.Checked then ProjectOptions.Compression.Lba2:= 2
  else ProjectOptions.Compression.Lba2:= 3;
  If rb2AutoBoth.Checked then ProjectOptions.Compression.Lba2Auto:= 0
  else if rb2AutoOnly1.Checked then ProjectOptions.Compression.Lba2Auto:= 1
  else ProjectOptions.Compression.Lba2Auto:= 2;
  ProjectOptions.Compression.MinSizeBenVal:= sb;
  ProjectOptions.Compression.MinSizeBenUnit:= cbMinSizeBenefit.ItemIndex;
  ProjectOptions.Compression.MinTimeBenVal:= tb;
  ProjectOptions.Compression.MinTimeBenUnit:= cbMinTimeBenefit.ItemIndex;
  ProjectOptions.Compression.MaxSizeLossVal:= sl;
  ProjectOptions.Compression.MaxSizeLossUnit:= cbMaxSizeLoss.ItemIndex;
  ProjectOptions.Optimizations.UseRepeated:= cbUseRepeated.Checked;
 // ProjectOptions.Optimizations.BricksRemoveUnused:= cbBrkRemUnused.Checked;
  ProjectOptions.Optimizations.LayoutsRemoveUnused:= cbLtsRemUnused.Checked;
  ProjectOptions.Optimizations.BricksRemoveDoubled:= cbBrkRemDoubled.Checked;
  ProjectOptions.Optimizations.ForceInvisibleBrick:= cbBrkForceInv.Checked;
  ProjectOptions.Optimizations.ForceInvBrickValue:= bi;
  If rbOutputType1.Checked then ProjectOptions.Output.OutputType:= 1
                           else ProjectOptions.Output.OutputType:= 2;
  ProjectOptions.Output.Lba1OutputGrid:= cbOutputGri.Checked;
  ProjectOptions.Output.Lba1GridPath:= peOutputGri.Path;
  ProjectOptions.Output.Lba1OutputLibBrk:= cbOutputBllBrk.Checked;
  ProjectOptions.Output.Lba1LibraryPath:= peOutputBll.Path;
  ProjectOptions.Output.Lba1BrickPath:= peOutputBrk.Path;
  ProjectOptions.Output.Lba2OutputBkg:= cbOutputBkg.Checked;
  ProjectOptions.Output.Lba2BkgPath:= peOutputBkg.Path;
  ProjectOptions.Output.OutputScene:= cbOutputSce.Checked;
  ProjectOptions.Output.ScenePath:= peOutputSce.Path;
  ProjectOptions.Description.Assign(meDescription.Lines);
  SetProjectModified(True);
  CheckExistingFiles();
  Form1.lvList.Repaint;
 end;
end;

Procedure LoadProject(path: String);
var a: Integer;
begin
 f:= TMemIniFile.Create(path);
 try

  UnloadProject();

  //opcje projektu:
  ProjectOptions.Compression.Lba1:= f.ReadInteger('Compression','Lba1',3);
  CheckValues(ProjectOptions.Compression.Lba1,[0,1,3],2);
  ProjectOptions.Compression.Lba2:= f.ReadInteger('Compression','Lba2',3);
  CheckRange(ProjectOptions.Compression.Lba2,0,3,3);
  ProjectOptions.Compression.Lba2Auto:= f.ReadInteger('Compression','Lba2Auto',0);
  CheckRange(ProjectOptions.Compression.Lba2Auto,0,2,0);
  ProjectOptions.Compression.MinSizeBenVal:= f.ReadFloat('Compression','MinSizeBenVal',1);
  CheckRange(ProjectOptions.Compression.MinSizeBenVal,0,1000000,1);
  ProjectOptions.Compression.MinSizeBenUnit:= f.ReadInteger('Compression','MinSizeBenUnit',0);
  CheckRange(ProjectOptions.Compression.MinSizeBenUnit,0,1,0);
  ProjectOptions.Compression.MinTimeBenVal:= f.ReadFloat('Compression','MinTimeBenVal',0.1);
  CheckRange(ProjectOptions.Compression.MinTimeBenVal,0,1000000,0.1);
  ProjectOptions.Compression.MinTimeBenUnit:= f.ReadInteger('Compression','MinTimeBenUnit',0);
  CheckRange(ProjectOptions.Compression.MinTimeBenUnit,0,1,0);
  ProjectOptions.Compression.MaxSizeLossVal:= f.ReadFloat('Compression','MaxSizeLossVal',1);
  CheckRange(ProjectOptions.Compression.MaxSizeLossVal,0,1000000,1);
  ProjectOptions.Compression.MaxSizeLossUnit:= f.ReadInteger('Compression','MaxSizeLossUnit',0);
  CheckRange(ProjectOptions.Compression.MaxSizeLossUnit,0,1,0);

  ProjectOptions.Optimizations.UseRepeated:= f.ReadBool('Optimizations','UseRepeated',True);
  ProjectOptions.Optimizations.BricksRemoveUnused:= f.ReadBool('Optimizations','BricksRemoveUnused',True);
  ProjectOptions.Optimizations.BricksRemoveDoubled:= f.ReadBool('Optimizations','BricksRemoveDoubled',True);
  ProjectOptions.Optimizations.ForceInvisibleBrick:= f.ReadBool('Optimizations','ForceInvisibleBrick',False);
  ProjectOptions.Optimizations.ForceInvBrickValue:= f.ReadInteger('Optimizations','ForceInvBrickValue',0);
  CheckRange(ProjectOptions.Optimizations.ForceInvBrickValue,0,1000000,0);
  ProjectOptions.Optimizations.LayoutsRemoveUnused:= f.ReadBool('Optimizations','LayoutsRemoveUnused',False);

  ProjectOptions.Output.OutputType:= f.ReadInteger('Output','OutputType',1);
  CheckRange(ProjectOptions.Output.OutputType,1,2,1);
  ProjectOptions.Output.Lba1OutputGrid:= f.ReadBool('Output','Lba1OutputGrid',True);
  ProjectOptions.Output.Lba1GridPath:= f.ReadString('Output','Lba1GridPath','');
  ProjectOptions.Output.Lba1OutputLibBrk:= f.ReadBool('Output','Lba1OutputLibBrk',True);
  ProjectOptions.Output.Lba1LibraryPath:= f.ReadString('Output','Lba1LibraryPath','');
  ProjectOptions.Output.Lba1BrickPath:= f.ReadString('Output','Lba1BrickPath','');
  ProjectOptions.Output.Lba2OutputBkg:= f.ReadBool('Output','Lba2OutputBkg',True);
  ProjectOptions.Output.Lba2BkgPath:= f.ReadString('Output','Lba2BkgPath','');
  ProjectOptions.Output.OutputScene:= f.ReadBool('Output','OutputScene',True);
  ProjectOptions.Output.ScenePath:= f.ReadString('Output','ScenePath','');

  If f.SectionExists('Description') then begin
   a:= 0;
   while f.ValueExists('Description',IntToStr(a)) do begin
    ProjectOptions.Description.Add(f.ReadString('Description',IntToStr(a),''));
    Inc(a);
   end;
  end;

  //waciwe dane projektu:
  SetLength(TheList, f.ReadInteger('ProjectData','Count',0));
  for a:= 0 to High(TheList) do begin
   //Form1.lvList.Items.Add();
   TheList[a].GridPath:=  f.ReadString('ProjectData',IntToStr(a+1)+'gri','');
   TheList[a].LibPath:=   f.ReadString('ProjectData',IntToStr(a+1)+'lib','');
   TheList[a].BrickPath:= f.ReadString('ProjectData',IntToStr(a+1)+'brk','');
   TheList[a].ScenePath:= f.ReadString('ProjectData',IntToStr(a+1)+'sce','');
   If AnsiSameText(TheList[a].LibPath,'<B>')
   and not AnsiSameText(TheList[a].BrickPath,'<B>') then
    TheList[a].BrickPath:= '<B>';
   If AnsiSameText(TheList[a].BrickPath,'<B>')
   and not AnsiSameText(TheList[a].LibPath,'<B>') then
    TheList[a].LibPath:= '<B>';
  end;
  Form1.lvList.Items.Count:= Length(TheList);

  CurrentProject:= path;
  Form1.dlSave.FileName:= ExtractFileName(path);
  SetProjectModified(False);
  Form1.Caption:= 'Little Stage Designer [' + ExtractFileName(path) + ']';
  Application.Title:= Form1.Caption;

  CheckExistingFiles;
  Form1.lvList.Repaint();

 finally
  f.Free;
 end;
end;

Procedure SaveProject(path: String);
var a: Integer;
begin
 f:= TMemIniFile.Create(path);
 try

  //opcje projektu:
  f.WriteInteger('Compression','Lba1',ProjectOptions.Compression.Lba1);
  f.WriteInteger('Compression','Lba2',ProjectOptions.Compression.Lba2);
  f.WriteInteger('Compression','Lba2Auto',ProjectOptions.Compression.Lba2Auto);
  f.WriteFloat('Compression','MinSizeBenVal',ProjectOptions.Compression.MinSizeBenVal);
  f.WriteInteger('Compression','MinSizeBenUnit',ProjectOptions.Compression.MinSizeBenUnit);
  f.WriteFloat('Compression','MinTimeBenVal',ProjectOptions.Compression.MinTimeBenVal);
  f.WriteInteger('Compression','MinTimeBenUnit',ProjectOptions.Compression.MinTimeBenUnit);
  f.WriteFloat('Compression','MaxSizeLossVal',ProjectOptions.Compression.MaxSizeLossVal);
  f.WriteInteger('Compression','MaxSizeLossUnit',ProjectOptions.Compression.MaxSizeLossUnit);

  f.WriteBool('Optimizations','UseRepeated',ProjectOptions.Optimizations.UseRepeated);
  f.WriteBool('Optimizations','BricksRemoveUnused',ProjectOptions.Optimizations.BricksRemoveUnused);
  f.WriteBool('Optimizations','BricksRemoveDoubled',ProjectOptions.Optimizations.BricksRemoveDoubled);
  f.WriteBool('Optimizations','ForceInvisibleBrick',ProjectOptions.Optimizations.ForceInvisibleBrick);
  f.WriteInteger('Optimizations','ForceInvBrickValue',ProjectOptions.Optimizations.ForceInvBrickValue);
  f.WriteBool('Optimizations','LayoutsRemoveUnused',ProjectOptions.Optimizations.LayoutsRemoveUnused);

  f.WriteInteger('Output','OutputType',ProjectOptions.Output.OutputType);
  f.WriteBool('Output','Lba1OutputGrid',ProjectOptions.Output.Lba1OutputGrid);
  f.WriteString('Output','Lba1GridPath',ProjectOptions.Output.Lba1GridPath);
  f.WriteBool('Output','Lba1OutputLibBrk',ProjectOptions.Output.Lba1OutputLibBrk);
  f.WriteString('Output','Lba1LibraryPath',ProjectOptions.Output.Lba1LibraryPath);
  f.WriteString('Output','Lba1BrickPath',ProjectOptions.Output.Lba1BrickPath);
  f.WriteBool('Output','Lba2OutputBkg',ProjectOptions.Output.Lba2OutputBkg);
  f.WriteString('Output','Lba2BkgPath',ProjectOptions.Output.Lba2BkgPath);
  f.WriteBool('Output','OutputScene',ProjectOptions.Output.OutputScene);
  f.WriteString('Output','ScenePath',ProjectOptions.Output.ScenePath);

  f.EraseSection('Description');
  for a:= 0 to ProjectOptions.Description.Count - 1 do
   f.WriteString('Description',IntToStr(a),ProjectOptions.Description.Strings[a]);

  //waciwe dane projektu:
  f.EraseSection('ProjectData');
  f.WriteInteger('ProjectData','Count',Length(TheList));
  for a:= 0 to High(TheList) do begin
   If TheList[a].GridPath <> '' then
    f.WriteString('ProjectData',IntToStr(a+1)+'gri',TheList[a].GridPath);
   If TheList[a].LibPath <> '' then
    f.WriteString('ProjectData',IntToStr(a+1)+'lib',TheList[a].LibPath);
   If TheList[a].BrickPath <> '' then
    f.WriteString('ProjectData',IntToStr(a+1)+'brk',TheList[a].BrickPath);
   If TheList[a].ScenePath <> '' then
    f.WriteString('ProjectData',IntToStr(a+1)+'sce',TheList[a].ScenePath);
  end;

  f.UpdateFile;

  CurrentProject:= path;
  SetProjectModified(False);
  Form1.Caption:= 'Little Stage Designer [' + ExtractFileName(path) + ']';
  Application.Title:= Form1.Caption;

 finally
  f.Free;
 end;
end;

procedure UnloadProject();
begin
 Form1.lvList.Items.Count:= 0;
 SetLength(TheList,0);
 CurrentProject:= '';
 SetProjectModified(False);
 Form1.Caption:= 'Little Stage Designer';
 Application.Title:= Form1.Caption;
 LastUndo:= 0;
 FirstRedo:= 0;
 Form1.aUndo.Enabled:= False;
 Form1.aRedo.Enabled:= False;
end;

procedure SetProjectModified(val: Boolean);
begin
 ProjectModified:= val;
 Form1.aSaveProject.Enabled:= val;
 If val then Form1.StatusBar1.Panels[0].Text:= 'Modified'
 else Form1.StatusBar1.Panels[0].Text:= '';
end;

initialization
 ProjectOptions.Description:= TStringList.Create;

finalization
 If Assigned(ProjectOptions.Description) then ProjectOptions.Description.Free;

end.
 