//******************************************************************************
// Little Big Architect: Factory - editing brick and layout files from
//                                 Little Big Adventure 1 & 2
//
// This is the main program file.
//
// Copyright Zink
// e-mail: zink@poczta.onet.pl
//
// This source code is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This source code is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License (License.txt) for more details.
//******************************************************************************

program Factory;

uses
  SysUtils,
  Forms,
  Main in 'Main.pas' {Form1},
  ProgBar in '..\Libs\ProgBar.pas' {ProgBarForm},
  Engine in '..\Libs\Engine.pas',
  Bricks in 'Bricks.pas',
  DePack in '..\Libs\DePack.pas',
  Editor in 'Editor.pas' {EditForm},
  OptPanel in 'OptPanel.pas' {OptForm},
  CompMods in '..\..\Libs\CompMods.pas',
  Layouts in 'Layouts.pas',
  StructEd in 'StructEd.pas' {StrForm},
  BrkTable in 'BrkTable.pas' {TableForm},
  DimDialog in 'DimDialog.pas' {DimForm},
  Libraries in '..\Libs\Libraries.pas',
  Scenario in 'Scenario.pas',
  ScenProp in '..\Libs\ScenProp.pas' {fmScenProp},
  ListForm in '..\Libs\ListForm.pas' {fmList},
  HQDesc in '..\Libs\HQDesc.pas';

{$R *.res}

begin
  Application.Initialize;
  Application.CreateForm(TForm1, Form1);
  Application.CreateForm(TfmScenProp, fmScenProp);
  Application.CreateForm(TfmList, fmList);
  Form1.Left:=(Screen.Width-Form1.Width) div 2;
  Form1.Top:=(Screen.Height-Form1.Height) div 2;
  Application.HintHidePause:=15000;
  Application.CreateForm(TProgBarForm, ProgBarForm);
  Application.CreateForm(TEditForm, EditForm);
  Application.CreateForm(TOptForm, OptForm);
  Application.CreateForm(TStrForm, StrForm);
  Application.CreateForm(TTableForm, TableForm);
  Application.CreateForm(TDimForm, DimForm);
  Application.OnDeactivate:=TableForm.FormDeactivate;
  LoadSettings;

  If ParamCount > 0 then OpenParam();

  If (Length(VBricks) = 0) and FileExists(BrkPath) then OpenBricks(BrkPath);
  If (Length(Lib) = 0) and FileExists(LibPath) then
   OpenLibrary(LibPath,LibIndex,True);

  UpdateComponents;
  Application.Run;

  SaveSettings;
end.
