//******************************************************************************
// Little Big Architect: Builder - editing grid files containing rooms
//                                 in Little Big Adventure 1 & 2
//
// This is the main program file.
//
// Copyright Zink
// e-mail: zink@poczta.onet.pl
//
// This source code is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This source code is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License (License.txt) for more details.
//******************************************************************************

program Builder;





uses
  SysUtils,
  StrUtils,
  Windows,
  Forms,
  Main in 'Main.pas' {Form1},
  ProgBar in '..\Libs\ProgBar.pas' {ProgBarForm},
  Sett in 'Sett.pas' {SetForm},
  Open in 'Open.pas' {OpenForm},
  BEngine in 'BEngine.pas',
  Engine in '..\Libs\Engine.pas',
  Hints in 'Hints.pas',
  OpenSim in 'OpenSim.pas' {SimpleForm},
  Clipping in 'Clipping.pas' {ClipFrame: TFrame},
  ListDialog in 'ListDialog.pas' {fmListForm},
  Scene in 'Scene.pas',
  CompMods in '..\..\Libs\CompMods.pas',
  Grids in '..\Libs\Grids.pas',
  CompDialog in 'CompDialog.pas' {CompForm},
  Libraries in '..\Libs\Libraries.pas',
  DePack in '..\Libs\DePack.pas',
  About in 'About.pas' {fmAbout},
  Bricks in 'Bricks.pas',
  ScenProp in '..\Libs\ScenProp.pas' {fmScenProp},
  Scenario in 'Scenario.pas' {Form2},
  OpScenGrid in 'OpScenGrid.pas' {fmOpScenGrid},
  HQDesc in '..\Libs\HQDesc.pas',
  ListForm in '..\Libs\ListForm.pas' {fmList};

{$R *.res}
//{$R napisy.res}
{$R Images.res}
{$R cursor.res}

var a, b: Integer;
    ErrorText: String;

begin
  Application.Initialize;
  Application.OnException:= Form1.AppException;
  Application.Title := 'Little Grid Builder';
  Application.CreateForm(TForm1, Form1);
  Application.CreateForm(TProgBarForm, ProgBarForm);
  Application.CreateForm(TSetForm, SetForm);
  Application.CreateForm(TOpenForm, OpenForm);
  Application.CreateForm(TSimpleForm, SimpleForm);
  Application.CreateForm(TfmListForm, fmListForm);
  Application.CreateForm(TfmAbout, fmAbout);
  Application.CreateForm(TfmScenProp, fmScenProp);
  Application.CreateForm(TfmScenario, fmScenario);
  Application.CreateForm(TfmOpScenGrid, fmOpScenGrid);
  Application.CreateForm(TfmList, fmList);
  //Application.CreateForm(TCompForm, CompForm);

  LoadSettings();

  LoadGriToBllTables();

  UpdateComponents();

  If not FileExists(ChangeFileExt(Application.ExeName,'.ini')) and
   (MessageBox(Form1.Handle,'If you want to open standard LBA rooms, you should set up paths to LBA files in the settings window (View->Settings). Open the settings now?','LBA Builder',MB_ICONQUESTION+MB_YESNO)
    =ID_YES) then begin
     SetForm.PageControl1.ActivePageIndex:= 1;
     SetForm.ShowModal();
    end;

  //parameters: scenemode x y
  // x = Lba version (1 or 2) or path to a scenario file
  // y = room number (counted from 1) (not necessary if scenario)
  ErrorText:= '';   
  If ParamCount>0 then begin
   If AnsiContainsText(ParamStr(1),'scenemode') then begin
    If ParamCount>1 then begin
     If TryStrToInt(ParamStr(2),a) and (a = 1) or (a = 2) then begin
      If ParamCount>2 then begin
       If TryStrToInt(ParamStr(3),b) and (b > 0) then
        OpenSceneMode(a,b)
       else ErrorText:= 'Invalid third parameter';
      end else ErrorText:= 'Three paramters required';
     end
     else if FileExists(ParamStr(2)) and ExtIs(ParamStr(2),'.hqs') then begin
      OpenSceneMode(ParamStr(2));
     end
     else ErrorText:= 'Invalid second parameter';
    end else ErrorText:= 'Three parameters required';
   end else
    if FileExists(ParamStr(1)) and ExtIs(ParamStr(1),'.hqs') then begin
    OpenScenario(ParamStr(1));
    OpenFinalize;
   end
   else ErrorText:= 'Invalid first parameter';
   If ErrorText<>'' then MessageBox(Form1.Handle,PChar(ErrorText),'Error',MB_ICONERROR+MB_OK);
  end;

  Application.Run;

  SaveSettings;
end.
