unit Scenario;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Libraries, StrUtils, ProgBar, Engine, Hints, StdCtrls, DePack;

type
  TfmScenario = class(TForm)
   lbMsg1: TLabel;
   lbMsg: TLabel;
   Label2: TLabel;
   lbDesc: TLabel;
   Label3: TLabel;
   Button2: TButton;
   Button1: TButton;
   Button4: TButton;
  private
    { Private declarations }
  public
   Function ShowDialog(ScenDesc: String; NoLib: Boolean): Integer;
  end;

 THQSInfo = record
  Lba2: Boolean;
  InfoText: String[255];
 end;

var
 fmScenario: TfmScenario;
 HQSInfo: THQSInfo;
 ScenDescription: String = '';
 ScenPath: String;
 ScenModified: Boolean;
 VScen: TPackEntries;
 TempLib: TCubeLib;

function OpenScenario(path: String): Boolean;
procedure CloseScenario;
procedure SaveScenario(path: String);

implementation

{$R *.dfm}

uses Main, Bricks, Open, Grids, OpenSim, Scene, BEngine, OpScenGrid;

Function TfmScenario.ShowDialog(ScenDesc: String; NoLib: Boolean): Integer;
begin
 lbDesc.Caption:= ScenDesc;
 lbMsg.Visible:= NoLib;
 Result:= ShowModal;
end;

function LoadHQSInfo(data: String): THQSInfo;
begin
 //FStr.Seek(0,soBeginning);
 Result.Lba2:= data[1] = #2; //FStr.Read(Result.Lba2,1);
 Result.InfoText:= Copy(data,2,255); //FStr.Read(Result.InfoText[1],255);
 //FStr.Free;
end;

function OpenScenario(path: String): Boolean;
var ext: String;
    NoGrid, NoLib: Boolean;
 procedure CancelOpen;
 begin
  CloseScenario;
  Result:= False;
  If SceneMode then Application.Terminate;
 end; 
begin
 Result:= True;
 path:= Trim(path);
 If not FileExists(path) then begin
  MessageBox(Form1.Handle,PChar('File "'+path+'" not found !'),'LBArchitect',MB_ICONERROR+MB_OK);
  Result:= False;
  Exit;
 end;
 ext:= LowerCase(ExtractFileExt(path));
 If (ext = '.hqs') then begin
  VScen:= OpenPack(path);
  HQSInfo:= LoadHQSInfo(UnpackToString(VScen[0]));

  If VScen[1].FType = -1 then
   ScenDescription:= UnpackToString(VScen[1]);

  PaletteType:= ptScen;
  If VScen[4].FType = -1 then
   Palette:= LoadPaletteFromStream(UnpackToStream(VScen[4]))
  else begin
   If HQSInfo.Lba2 then Palette:= LoadPaletteFromResource(2)
   else Palette:= LoadPaletteFromResource(1);
   PaletteType:= ptLba;
  end;

  VBricks:= Copy(VScen,20,Length(VScen)-20); //OpenPack(FStr,20);
  TransparentBrick:= 0;
  If HQSInfo.Lba2 then FindTransparentBrick;

  NoLib:= False;
  If VScen[2].FType = -1 then
   VLibrary:= LoadLibraryFromStream(UnpackToStream(VScen[2]))
  else NoLib:= True;

  NoGrid:= False;
  GridNow:= True;
  CurrentIndex:= 0;
  If VScen[3].FType = -1 then begin
   Grid:= LoadGridFromStream(UnpackToStream(VScen[3]),HQSInfo.Lba2);
   DataToMap;
   CurrentFile:= path;
  end
  else NoGrid:= True;

  If NoGrid or NoLib then begin
   case fmScenario.ShowDialog(HQSInfo.InfoText,NoLib) of
    mrOK:   //open existing grid
     If NoLib then begin
      SetModeOpen(True);
      If OpenForm.ShowModal = mrOK then begin
       //EnableControls(False);
       Screen.Cursor:= crHourGlass;
       OpenFiles(False);
       ProgBarForm.ShowSpecial('Loading files...', Form1, True);
       DataToMap;
       BufferBricks(VLibrary,VBricks);
       CreateThumbnail;
      end
      else CancelOpen;
     end
     else begin  //library present
      If fmOpScenGrid.ShowModal = mrOK then begin
       fmOpScenGrid.OpenGridForScenario(HQSInfo.Lba2);
       DataToMap;
       BufferBricks(VLibrary,VBricks);
       CreateThumbnail;
      end
      else CancelOpen;
     end;
    mrIgnore:  //create new grid
     If NoLib then begin
      SetModeNew(True);
      If OpenForm.ShowModal = mrOK then begin
       //EnableControls(False);
       Form1.btScNet.Down:= True;
       Screen.Cursor:= crHourGlass;
       OpenFiles(True);
       ProgBarForm.ShowSpecial('Loading files...', Form1, True);
       Grid.Lba2:= OpenForm.rb12.Checked or ExtIs(LibPath,'bl2') or IsBkg(LibPath);
       Grid.LibIndex:= StrToIntDef(OpenForm.eLibIndex.Text, 0);
       Grid.FragIndex:= StrToIntDef(OpenForm.eFragIndex.Text, 0);
       SetMapsLengths(63, 24, 63);
       ClearMap;
       FindLba2Invisible(VLibrary);
      end
      else CancelOpen;
     end
     else begin  //library present
      Form1.btNet.Down:= True;
      Grid.Lba2:= HQSInfo.Lba2;
      Grid.LibIndex:= 0;
      Grid.FragIndex:= 0;
      SetMapsLengths(63, 24, 63);
      ClearMap;
      CurrentFile:= '';
     end;
    mrCancel: CancelOpen;
   end;
  end;
 end;
 ScenPath:= path;
end;

procedure CloseScenario;
begin
 HQSInfo.InfoText:= '';
 ScenDescription:= '';
 SetLength(VScen,0);
end;

function CreateHQSInfo(Lba2: Boolean; Desc: ShortString): String;
begin
 If Lba2 then Result:= #2 else Result:= #1;
 If Length(Desc) > 255 then Result:= Result + Copy(Desc,1,255)
 else Result:= Result + Desc + StringOfChar(' ',255 - Length(Desc));
end;

procedure MakeScenarioFile;
var a, b, c, d, Index: Integer;
begin
 If Length(VScen) < 1 then begin
  SetLength(VScen,20);
  for a:= 0 to 19 do
   VScen[a]:= PackEntry('',-2); //make all blank
 end;

 If PaletteType = ptFile then
  VScen[4]:= PackEntry(PaletteToString(Palette),-1,2);

 TempLib:= LibToCubeLib(Copy(VLibrary,1,High(VLibrary)));
 for a:= 0 to High(TempLib) do
  for d:= 0 to TempLib[a].Z - 1 do
   for c:= 0 to TempLib[a].Y - 1 do
    for b:= 0 to TempLib[a].X - 1 do begin
     Index:= TempLib[a].Map[b,c,d].Index;
     If Index > 0 then begin
      SetLength(VScen,Length(VScen)+1);
      If VBricks[Index-1].Comp <> 2 then
       VScen[High(VScen)]:= PackEntry(UnpackToString(VBricks[Index-1]),-1,2)
      else
       VScen[High(VScen)]:= VBricks[Index-1];
      TempLib[a].Map[b,c,d].Index:= Length(VScen) - 20;
     end;
    end;
 VScen[2]:= PackEntry(LibraryToString(TempLib),-1,2);

 VScen[0]:= PackEntry(CreateHQSInfo(Grid.Lba2,HQSInfo.InfoText),-1,2);
 If Length(ScenDescription) > 0 then
  VScen[1]:= PackEntry(ScenDescription,-1,2)
 else
  VScen[1]:= PackEntry('',-2);
 Grid:= MapToGrid;
 VScen[3]:= PackEntry(GridToString(Grid,Grid.Lba2),-1,2);
end;

procedure SaveScenario(path: String);
begin
 If ExtIs(path,'.hqs') then begin
  ProgBarForm.ShowSpecial('Saving Scenario...',Form1,True);
  MakeScenarioFile;
  SavePackToFile(VScen,path);
  ProgBarForm.CloseSpecial;
 end;
 ScenModified:= False;
 ScenPath:= path;
 CurrentFile:= path;
 SysUtils.Beep;
 PutMessage(79);
end;

end.
