unit Settings;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, IniFiles;

type
  TfmSettings = class(TForm)
    btOK: TBitBtn;
    btCancel: TBitBtn;
    cbAskDelRow: TCheckBox;
    cbBuildSummary: TCheckBox;
    cbAutoSave: TCheckBox;
    cbNoASForce: TCheckBox;
    CheckBox1: TCheckBox;
    procedure cbAutoSaveClick(Sender: TObject);
  private
    { Private declarations }
  public
   Procedure ShowSettings();
  end;

var
  fmSettings: TfmSettings;
  f: TIniFile;

  MainSettings: record
   LastProjectDir: String;
   LastProject: String;
   AskDeletingRow: Boolean;
   BuildSummary: Boolean;
   AutoSave: Boolean;
   NoASForce: Boolean;
  end;

Procedure LoadSettings();
Procedure SaveSettings();

implementation

{$R *.dfm}

Procedure TfmSettings.ShowSettings();
begin
 cbAskDelRow.Checked:= MainSettings.AskDeletingRow;
 cbBuildSummary.Checked:= MainSettings.BuildSummary;
 cbAutoSave.Checked:= MainSettings.AutoSave;
 cbNoASForce.Checked:= MainSettings.NoASForce;
 cbAutoSaveClick(Self);
 //While (ShowModal = mrOK)
 //and not (TryStrToFloat(eMinSizeBen.Text,sb)  and (sb >= 0)
 //     and TryStrToFloat(eMinTimeBen.Text,tb)  and (tb >= 0)
 //     and TryStrToFloat(eMaxSizeLoss.Text,sl) and (sl >= 0)
 //     and TryStrToInt(eBrkForceInv,bi)        and (bi >= 0)) do
 // MessageBox(Handle,'At leas one of the fields contains invalid number!'#13#13
 //                 + 'Fields "file size benefit is at least", "time benefit is at least" and "size loss is not higher than" should contain real numbers, greater or equal to zero.'#13
 //                 + 'Field "Force the invisible Brick at specific position" should contain and integer number, greater or equal to zero.','Stage Designer',MB_ICONERROR+MB_OK);
 ShowModal;
 If ModalResult = mrOK then begin
  MainSettings.AskDeletingRow:= cbAskDelRow.Checked;
  MainSettings.BuildSummary:= cbBuildSummary.Checked;
  MainSettings.AutoSave:= cbAutoSave.Checked;
  MainSettings.NoASForce:= cbNoASForce.Checked;
 end;
end;

Procedure LoadSettings();
begin
 f:= TIniFile.Create(ChangeFileExt(Application.ExeName,'.ini'));
 try

  MainSettings.LastProjectDir:= f.ReadString('General','LastProjectDir','');
  MainSettings.LastProject:= f.ReadString('General','LastProject','');
  MainSettings.AskDeletingRow:= f.ReadBool('General','AskDeletingRow',True);
  MainSettings.AutoSave:= f.ReadBool('General','AutoSave',True);
  MainSettings.NoASForce:= f.ReadBool('General','NoASForce',False);
  MainSettings.BuildSummary:= f.ReadBool('Building','BuildSummary',True);

 finally
  f.Free;
 end;
end;

Procedure SaveSettings();
begin
 f:= TIniFile.Create(ChangeFileExt(Application.ExeName,'.ini'));
 try

  f.WriteString('General','LastProjectDir',MainSettings.LastProjectDir);
  f.WriteString('General','LastProject',MainSettings.LastProject);
  f.WriteBool('General','AskDeletingRow',MainSettings.AskDeletingRow);
  f.WriteBool('General','AutoSave',MainSettings.AutoSave);
  f.WriteBool('General','NoASForce',MainSettings.NoASForce);
  f.WriteBool('Building','BuildSummary',MainSettings.BuildSummary);

 finally
  f.Free;
 end;
end;

procedure TfmSettings.cbAutoSaveClick(Sender: TObject);
begin
 cbNoASForce.Enabled:= cbAutoSave.Checked;
end;

end.
