//******************************************************************************
// Little Big Architect: Factory - editing brick and layout files from
//                                 Little Big Adventure 1 & 2
//
// OptPanel unit.
// Contains the small panel that slides out from left border of the editor
//  window.
//
// Copyright Zink
// e-mail: zink@poczta.onet.pl
// See the GNU General Public License (License.txt) for details.
//******************************************************************************

unit OptPanel;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, IniFiles, DFSClrBn, Math;

type
  TOptForm = class(TForm)
    paOpt: TPanel;
    pcOpts: TPageControl;
    optZoom: TTabSheet;
    optDisplay: TTabSheet;
    cbFrontF: TCheckBox;
    cbGrid: TCheckBox;
    cbBackF: TCheckBox;
    cbCoverBack: TCheckBox;
    lbZoom: TListBox;
    Label1: TLabel;
    Label2: TLabel;
    cbAddF: TCheckBox;
    optOptions: TTabSheet;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    cbFrontC: TdfsColorButton;
    cbBackC: TdfsColorButton;
    optStructOpts: TTabSheet;
    cbShowImg: TCheckBox;
    cbIndexes: TCheckBox;
    cbShape: TCheckBox;
    Label7: TLabel;
    cbSelect: TdfsColorButton;
    cbFrames: TCheckBox;
    procedure lbZoomClick(Sender: TObject);
    procedure cbGridClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure cbFrontCColorChange(Sender: TObject);
    procedure cbFramesClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure ShowPanel(x, y, Index: Integer);
    procedure HidePanel;
  end;

var
  OptForm: TOptForm;

  AppPath: String;
  LastBrkPath: String;
  LastLtPath: String;
  LastExportPath: String;
  LastHqrPath: String;
  LastScenPath: String;

procedure ChangePalette(PLba1: Boolean; Repaint: Boolean = True);
procedure SaveSettings;
procedure LoadSettings;

implementation

uses Editor, Engine, Main, Bricks, Layouts, StructEd, Scenario;

{$R *.dfm}

procedure TOptForm.ShowPanel(x, y, Index: Integer);
begin
 OptForm.Left:=x;
 OptForm.Top:=y;
 OptForm.pcOpts.ActivePageIndex:=Index;
 AnimateWindow(OptForm.Handle,50,aw_hor_positive+aw_slide);
 OptForm.Visible:=True;
end;

procedure TOptForm.HidePanel;
begin
 AnimateWindow(OptForm.Handle,50,aw_hor_negative+aw_hide+aw_slide);
 OptForm.Visible:=False;
end;

procedure TOptForm.lbZoomClick(Sender: TObject);
begin
 Zoom:=OptForm.lbZoom.ItemIndex+1;
 SetScrolls(True);
 RepaintImage;
end;

procedure TOptForm.cbGridClick(Sender: TObject);
begin
 RepaintImage;
end;

procedure TOptForm.FormCreate(Sender: TObject);
begin
 lbZoom.ItemIndex:=0;
end;

procedure ChangePalette(PLba1: Boolean; Repaint: Boolean = True);
begin
 Palette:= LoadPaletteFromResource(IfThen(PLba1,1,2));
 InvertPal:= InvertPalette(Palette);
 If PLba1 then Form1.mLba1.Checked:=True else Form1.mLba2.Checked:=True;
 If Repaint then begin
  PaintBricks;
  PaintLayouts;
 end;
end;

procedure SaveSettings;
var f: TIniFile;
begin
 f:=TIniFIle.Create(AppPath+'Factory.ini');
 f.WriteInteger('General', 'Palette',        IfThen(Form1.mLba1.Checked,1,2));
 f.WriteString( 'General', 'lba_brk',        BrkPath);
 f.WriteString( 'General', 'bll_path',       LibPath);
 f.WriteInteger('General', 'bll_index',      LibIndex);
 f.WriteString( 'General', 'scen_path',      ScenPath);
 f.WriteInteger('General', 'Zoom',           OptForm.lbZoom.ItemIndex);
 f.WriteString( 'General', 'LastBrkPath',    LastBrkPath);
 f.WriteString( 'General', 'LastExportPath', LastExportPath);
 f.WriteString( 'General', 'LastHqrPath',    LastHqrPath);
 f.WriteString( 'General', 'LastScenPath',   LastScenPath);
 f.WriteBool(   'General', 'ViewFrames',     Form1.mFrames.Checked);
 f.WriteBool(   'General', 'ViewIndexes',    Form1.mIndexes.Checked);
 f.WriteBool(   'General', 'ViewShapes',     Form1.mShapes.Checked);
 f.WriteBool(   'General', 'SortBySizes',    Form1.btSortSize.Down);
 f.WriteBool(   'Editor',  'Grid',           OptForm.cbGrid.Checked);
 f.WriteBool(   'Editor',  'FrontFrame',     OptForm.cbFrontF.Checked);
 f.WriteBool(   'Editor',  'BackFrame',      OptForm.cbBackF.Checked);
 f.WriteBool(   'Editor',  'AddFrame',       OptForm.cbAddF.Checked);
 f.WriteBool(   'Editor',  'BrickCoversBF',  OptForm.cbCoverBack.Checked);
 f.WriteInteger('Editor',  'FrontColour',    OptForm.cbFrontC.Color);
 f.WriteInteger('Editor',  'BackColour',     OptForm.cbBackC.Color);
 f.WriteBool(   'StructEditor', 'ShowFrames',  OptForm.cbFrames.Checked);
 f.WriteBool(   'StructEditor', 'ShowImage',   OptForm.cbShowImg.Checked);
 f.WriteBool(   'StructEditor', 'ShowIndexes', OptForm.cbIndexes.Checked);
 f.WriteBool(   'StructEditor', 'ShowShape',   OptForm.cbShape.Checked);
 f.WriteInteger('StructEditor', 'SelColour',   OptForm.cbSelect.Color);
 f.Free;
end;

procedure LoadSettings;
var f: TIniFile;
begin
 AppPath:= ExtractFilePath(Application.ExeName);
 f:= TIniFIle.Create(AppPath+'Factory.ini');
 ChangePalette(f.ReadInteger('General','Palette',1)=1);
 BrkPath:=                     f.ReadString('General','lba_brk','');
 LibPath:=                     f.ReadString('General','bll_path','');
 LibIndex:=                    f.ReadInteger('General','bll_index',1);
 ScenPath:=                    f.ReadString('General','scen_path','');
 OptForm.lbZoom.ItemIndex:=    f.ReadInteger('General','Zoom',0);
 OptForm.lbZoomClick(EditForm);
 LastBrkPath:=                 f.ReadString('General','LastBrkPath',AppPath);
 LastExportPath:=              f.ReadString('General','LastExportPath',AppPath);
 LastHqrPath:=                 f.ReadString('General','LastHqrPath',AppPath);
 LastScenPath:=                f.ReadString('General','LastScenPath',AppPath);
 Form1.mFrames.Checked:=       f.ReadBool('General','ViewFrames',False);
 Form1.mIndexes.Checked:=      f.ReadBool('General','ViewIndexes',True);
 Form1.mShapes.Checked:=       f.ReadBool('General','ViewShapes',False);
 If f.ReadBool('General','SortBySizes',True) then Form1.btSortSize.Down:= True
 else Form1.btSortIndex.Down:= True;
 OptForm.cbGrid.Checked:=      f.ReadBool('Editor','Grid',False);
 OptForm.cbFrontF.Checked:=    f.ReadBool('Editor','FrontFrame',True);
 OptForm.cbBackF.Checked:=     f.ReadBool('Editor','BackFrame',True);
 OptForm.cbAddF.Checked:=      f.ReadBool('Editor','AddFrame',True);
 OptForm.cbCoverBack.Checked:= f.ReadBool('Editor','BrickCoversBF',True);
 OptForm.cbFrontC.Color:=      f.ReadInteger('Editor','FrontColour',clRed);
 OptForm.cbBackC.Color:=       f.ReadInteger('Editor','BackColour',clBlue);
 OptForm.cbFrames.Checked:=    f.ReadBool('StructEditor','ShowFrames',True);
 OptForm.cbShowImg.Checked:=   f.ReadBool('StructEditor','ShowImage',True);
 OptForm.cbIndexes.Checked:=   f.ReadBool('StructEditor','ShowIndexes',True);
 OptForm.cbShape.Checked:=     f.ReadBool('StructEditor','ShowShape',False);
 OptForm.cbSelect.Color:=      f.ReadInteger('StructEditor','SelColour',$000080FF);
 f.Free;
end;

procedure TOptForm.cbFrontCColorChange(Sender: TObject);
begin
 RepaintImage;
end;

procedure TOptForm.cbFramesClick(Sender: TObject);
begin
 DrawStruct;
end;

end.
