unit Scenario;

interface

uses DePack, Classes, SysUtils, Windows, Libraries, StrUtils, ProgBar;

Type
 THQSInfo = record
  Lba2: Boolean;
  InfoText: String[255];
 end;

var
 HQSInfo: THQSInfo = (Lba2: False; InfoText: '');
 ScenDescription: String = '';
 ScenPath: String = '';
 ScenModified: Boolean;
 VScen: TPackEntries;
 TempLib: TCubeLib;

procedure OpenScenario(path: String);
procedure CloseScenario;
procedure SaveScenario(path: String);

implementation

uses Main, Layouts, Bricks, OptPanel;

function LoadHQSInfo(FStr: TStream): THQSInfo;
var a: Byte;
begin
 FStr.Seek(0,soBeginning);
 FStr.Read(a,1);
 Result.Lba2:= a = 2;
 FStr.Read(Result.InfoText[1],255);
 FStr.Free;
end;

procedure OpenScenario(path: String);
var FStr: TFileStream;
    ext: String;
begin
 path:= Trim(path);
 If not FileExists(path) then begin
  MessageBox(Form1.Handle,PChar('File "'+path+'" not found !'),'LBArchitect',MB_ICONERROR+MB_OK);
  Exit;
 end;
 CloseScenario;
 BrkPath:= '';
 LibPath:= '';
 FStr:= TFileStream.Create(path,fmOpenRead,fmShareDenyWrite);
 ext:= LowerCase(ExtractFileExt(path));
 If (ext = '.hqs') then begin
  VScen:= OpenPack(FStr);
  HQSInfo:= LoadHQSInfo(UnpackToStream(VScen[0]));
  LLba1:= not HQSInfo.Lba2;

  If VScen[1].FType = -1 then
   ScenDescription:= UnpackToString(VScen[1]);

  {If VBricks[4].FType = -1 then
  else} ChangePalette(LLba1, False);

  VBricks:= Copy(VScen,20,Length(VScen)-20);
  BrkOffset:= 0;
  BrkCount:= Length(VBricks);
  BricksOpened:= True;
  SetMenuBrk('.hqs');

  If VScen[2].FType = -1 then begin
   Lib:= LibToCubeLib(LoadLibraryFromStream2(UnpackToStream(VScen[2])));
   SetMenuLt('.hqs',True);
   LibIndex:= -1;
  end;
 end;
 FStr.Destroy;
 ScenPath:= path;
end;

procedure CloseScenario;
begin
 If Length(VScen) > 0 then begin
  ScenDescription:= '';
  HQSInfo.InfoText:= '';
  SetLength(VScen,0);

  SetLength(Lib,0);
  LibIndex:= 0;
  LtSelect:= 1;
  SetLength(LtSort,0);
  SetLength(LtMap,0);
  SetLength(LtUsed,0);
  SetLength(LtDim,0);
  SetLength(LtPos,0);
  LayoutsModified:= False;

  SetLength(VBricks,0);
  BrkCount:= 0;
  BricksOpened:= False;
  BrkPerRow:= 1;
  BrkSelect:= 0;
  SetLength(Buffered,0);
  SetLength(bitBuffers,0);
  Allocated:= 0;
  BricksModified:= False;
 end; 
end;

function CreateHQSInfo(Lba2: Boolean; Desc: ShortString): String;
begin
 If Lba2 then Result:= #2 else Result:= #1;
 If Length(Desc) > 255 then Result:= Result + Copy(Desc,1,255)
 else Result:= Result + Desc + StringOfChar(' ',255 - Length(Desc));
end;

procedure MakeScenarioFile;
var a, b, c, d, Index: Integer;
begin
 If Length(VScen) < 1 then begin
  SetLength(VScen,20);
  for a:= 0 to 19 do
   VScen[a]:= PackEntry('',-2); //make all blank
  //VScen[4]:= palette;
 end
 else
  SetLength(VScen,20);

 VScen[0]:= PackEntry(CreateHQSInfo(not LLba1,HQSInfo.InfoText),-1,2);
 If Length(ScenDescription) > 0 then
  VScen[1]:= PackEntry(ScenDescription,-1,2)
 else
  VScen[1]:= PackEntry('',-2); 

 TempLib:= CopyLibrary(Lib);
 for a:= 0 to High(TempLib) do
  for d:= 0 to TempLib[a].Z - 1 do
   for c:= 0 to TempLib[a].Y - 1 do
    for b:= 0 to TempLib[a].X - 1 do begin
     Index:= TempLib[a].Map[b,c,d].Index;
     If Index > 0 then begin
      SetLength(VScen,Length(VScen)+1);
      If VBricks[Index+BrkOffset-1].Comp <> 2 then
       VScen[High(VScen)]:= PackEntry(UnpackToString(VBricks[Index+BrkOffset-1]),-1,2)
      else
       VScen[High(VScen)]:= VBricks[Index+BrkOffset-1];
      TempLib[a].Map[b,c,d].Index:= Length(VScen) - 20;
     end;
    end;
 VScen[2]:= PackEntry(LibraryToString(TempLib),-1,2);
end;

procedure SaveScenario(path: String);
begin
 If ExtIs(path,'.hqs') then begin
  ProgBarForm.ShowSpecial('Saving Scenario...',Form1,True);
  MakeScenarioFile;
  SavePackToFile(VScen,path);
  ProgBarForm.CloseSpecial();
 end;
 SetTabCaptions;
 ScenModified:= False;
 ScenPath:= path;
 SysUtils.Beep;
end;

end.
