unit HQDesc;

interface

uses SysUtils, Forms, DePack;

type
 TStrArray = array of String;

 THQRDesc = record
  Index: Integer;
  Desc: String;
 end;

 THQRDescs = array of THQRDesc;

 THQRInfoItem = record
  Index: Integer;
  Ext: String[3];
  Desc: String;
 end;

 THQRInfo = array of THQRInfoItem;

 THQDHeader = record
  Desc: String;
  Total: Integer;
  Normal: Integer;
  Repeated: Integer;
  Blank: Integer;
  Mask: String;
 end;

const
 InfoDir = 'fileinfo';

var
 HQDHeader: THQDHeader;
 HQRDescMap: array of Integer;

function LoadHQRFullInfo(HQRPath: String): THQRInfo;
function LoadHQRDescriptions(HQRPath: String; ext: String; out Descs: THQRDescs): Boolean;

implementation

uses Masks;

//leaves the file open for further reading
function ReadHQDHeader(HQDPath: String; var f: TextFile): Boolean;
var st: String;
begin
 Result:= True;
 AssignFile(f,HQDPath);
 FileMode:= fmOpenRead;
 try
  Reset(f);
  ReadLn(f,HQDHeader.Desc);
  ReadLn(f,st);
  HQDHeader.Total:= StrToIntDef(st,-1);
  ReadLn(f,st);
  HQDHeader.Normal:= StrToIntDef(st,-1);
  ReadLn(f,st);
  HQDHeader.Repeated:= StrToIntDef(st,-1);
  ReadLn(f,st);
  HQDHeader.Blank:= StrToIntDef(st,-1);
  ReadLn(f,HQDHeader.Mask);
  try
   MatchesMask(HQDPath,HQDHeader.Mask);
  except
   on EMaskException do HQDHeader.Mask:= '*';  //make sure the mask is correct
  end;
 except
  Result:= False;
 end;
end;

function FindMatchingHQDFile(HQRPath: String; Entries: Integer; var f: TextFile): Boolean;
var fs: TSearchRec;
    path: String;
begin
 Result:= False;
 If FileExists(ChangeFileExt(HQRPath,'.hqd')) then begin
  ReadHQDHeader(ChangeFileExt(HQRPath,'.hqd'),f);
  Result:= True;
 end
 else begin
  path:= ExtractFilePath(Application.ExeName) + InfoDir + '\';
  if FindFirst(path + '*.hqd', faReadOnly + faHidden + faArchive,fs) = 0 then begin
   repeat
    If ReadHQDHeader(path + fs.Name, f) then begin
     If (HQDHeader.Total = Entries) and MatchesMask(HQRPath,HQDHeader.Mask) then begin
      Result:= True;
      Break;
     end;
     CloseFile(f);
    end;
   until FindNext(fs) <> 0;
   FindClose(fs);
  end;
 end;
end;

function ReadHQDFile(HQRPath: String; ext: String; out Str: TStrArray): Boolean;
var a, rl: Integer;
    f: TextFile;
    st: String;
begin
 Result:= False;
 SetLength(Str,0);
 rl:= 0;
 a:= PackEntriesCount(HQRPath);
 If FindMatchingHQDFile(HQRPath,a,f) then begin
  while not Eof(f) do begin
   Inc(rl);
   SetLength(Str, rl);
   If ext = '*' then //all entries
    ReadLn(f,Str[rl-1])
   else begin
    ReadLn(f,st);
    a:= Pos(':',st);
    if (a > 0) and AnsiSameText(Copy(st, a + 1, Pos('|',st) - a - 1), ext) then
     Str[rl-1]:= st;
   end;
  end;
  CloseFile(f);
  Result:= True;
 end
 else
  HQDHeader.Desc:= '>> Description file not found <<';
end;

function LoadHQRFullInfo(HQRPath: String): THQRInfo;
begin

end;

function LoadHQRDescriptions(HQRPath: String; ext: String; out Descs: THQRDescs): Boolean;
var a, b, id, lr: Integer;
    temp: TStrArray;
begin
 Result:= False;
 lr:= 0;
 SetLength(Descs,0);
 
 If ReadHQDFile(HQRPath,ext,temp) then begin

  SetLength(HQRDescMap,HQDHeader.Total);
  for a:= 0 to High(HQRDescMap) do
   HQRDescMap[a]:= -1;

  for a:= 0 to High(temp) do begin
   b:= Pos(':',temp[a]);
   If (b > 0) and TryStrToInt(Copy(temp[a],1,b-1),id) then begin
    b:= Pos('|',temp[a]);
    If (b > 0) then begin
     Inc(lr);
     SetLength(Descs,lr);
     Descs[lr-1].Index:= id;
     Descs[lr-1].Desc:= Copy(temp[a], b + 1, Length(temp[a]) - b);
     If id >= HQDHeader.Total then begin
      HQDHeader.Desc:= '>> Error in description file near entry ' + IntToStr(id) + ' <<';
      Exit;
     end;
     HQRDescMap[id]:= lr-1;
    end;
   end;
  end;
  Result:= True;
 end;
end;

end.
