unit ListForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, DePack, HQDesc;

type
  TfmList = class(TForm)
    Label1: TLabel;
    lbList: TListBox;
    btOK: TBitBtn;
    btCancel: TBitBtn;
    procedure lbListMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure lbListDblClick(Sender: TObject);
  private
    { Private declarations }
  public
    Function ShowList(Caption: String; Items: array of String;
     DefSelect: Integer = -1): Integer;
  end;

var
  fmList: TfmList;

Function MakeDescriptionList(Path: String; What: TWhatEntries;
 Lba1: Boolean; out IndexList: TIndexList): TStrArray;
Function HQRListDialog(Path: String; What: TWhatEntries; Lba1: Boolean;
 Caption: String; DefSelect: Integer = -1): Integer;

implementation

{$R *.dfm}

Procedure DescriptionsToStrings(descs: THQRDescs; List: TIndexList;
 DescOK: Boolean; Partial: Boolean; Prefix: String; var Names: TStrArray);
var a: Integer;
    st: String;
begin
 SetLength(Names,Length(List));
 If DescOK then begin
  for a:= 0 to High(List) do begin
   st:= Prefix + IntToStr(List[a] + 1) + ': ';
   If List[a] < Length(HQRDescMap) then
    If HQRDescMap[List[a]] > -1 then begin
     st:= st + descs[HQRDescMap[List[a]]].Desc;
     Names[a]:= st;
    end
    else if not Partial then
     Names[a]:= st + '[no description]'
   else if not Partial then
    Names[a]:= st + '[error in description file]';
  end;
 end
 else if not Partial then begin
  for a:= 0 to High(Names) do
   Names[a]:= IntToStr(List[a] + 1) + ': [no description]';
 end;
end;

Function MakeDescriptionList(Path: String; What: TWhatEntries;
 Lba1: Boolean; out IndexList: TIndexList): TStrArray;
var p: TSmallPoint;
    descs: THQRDescs;
    ext: String;
    DescsOK: Boolean;
begin
 If FileExists(Path) then begin
  If Lba1 then begin
   IndexList:= GetNormalEntriesList(Path);
  end
  else begin
   p:= BkgEntriesCount0(Path,What);
   IndexList:= GetNormalEntriesList(Path,p.x, p.y - 1);
  end;

  If (What = weGridFrag) and not Lba1 then begin
   DescsOK:= LoadHQRDescriptions(Path,'gr2',descs);
   DescriptionsToStrings(descs,IndexList,DescsOK,False,'[grid] ',Result);
   DescsOK:= LoadHQRDescriptions(Path,'grf',descs);
   DescriptionsToStrings(descs,IndexList,DescsOK,True,'[fragment] ',Result);
  end
  else begin
   case What of
    weGrids,
    weGridFrag:  If Lba1 then ext:= 'gr1' else ext:= 'gr2';
    weFrags:     ext:= 'grf';
    weLibs:      If Lba1 then ext:= 'bl1' else ext:= 'bl2';
    weBricks:    ext:= 'brk';
   end;
   DescsOK:= LoadHQRDescriptions(Path,ext,descs);
   DescriptionsToStrings(descs,IndexList,DescsOK,False,'',Result);
  end;
 end
 else begin
  SetLength(IndexList,0);
  SetLength(Result,0);
 end;
end;

Function HQRListDialog(Path: String; What: TWhatEntries; Lba1: Boolean;
 Caption: String; DefSelect: Integer = -1): Integer;
var a: Integer;
    List: TIndexList;
    Names: TStrArray;
begin
 Names:= MakeDescriptionList(Path, What, Lba1, List);

 If DefSelect > -1 then
  for a:= 0 to High(List) do
   If List[a] = DefSelect then begin
    DefSelect:= a;
    Break;
   end;

 a:= fmList.ShowList(Caption, Names, DefSelect);
 If a > -1 then Result:= List[a] else Result:= -1;
end;

Function TfmList.ShowList(Caption: String; Items: array of String;
 DefSelect: Integer = -1): Integer;
var a: Integer;
begin
 Label1.Caption:= Caption;
 lbList.ClearSelection;
 lbList.Clear;
 If Length(Items) < 1 then
  raise EListError.Create('There must be at least one item in the list');
 for a:= 0 to High(Items) do
  lbList.Items.Add(Items[a]);
 If (DefSelect > -1) and (DefSelect < lbList.Count) then
  lbList.ItemIndex:= DefSelect;
 btOK.Enabled:= lbList.ItemIndex > - 1;

 If ShowModal = mrOK then begin
  Result:= lblist.ItemIndex;
 end
 else
  Result:= -1;
end;

procedure TfmList.lbListMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
 btOK.Enabled:= lbList.ItemIndex > -1; 
end;

procedure TfmList.lbListDblClick(Sender: TObject);
begin
 If lbList.ItemIndex > -1 then ModalResult:= mrOK;
end;

end.
