//******************************************************************************
// Little Big Architect: Builder - editing grid files containing rooms in
//                                 Little Big Adventure 1 & 2
//
// Clipping unit.
// Contains routines used for clipping frame. This is frame that shows when you
//  want to place a new layout in the grid, and allows you to clip the Layout so
//  that only part of it will be placed.
//
// Copyright (C) Zink
// e-mail: zink@poczta.onet.pl
// See the GNU General Public License (License.txt) for details.
//******************************************************************************

unit Clipping;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons, ExtCtrls, ActnList, ImgList, BEngine, Engine, Grids,
  Libraries, Math, StdCtrls;

type
  TClipFrame = class(TFrame)
    Images: TImageList;
    btAdvanced: TSpeedButton;
    pbImage: TPaintBox;
    Image1: TImage;
    btPos4: TSpeedButton;
    btPos1: TSpeedButton;
    btPos2: TSpeedButton;
    btPos3: TSpeedButton;
    btMin: TSpeedButton;
    btReset: TSpeedButton;
    Bevel1: TBevel;
    procedure pbImagePaint(Sender: TObject);
    procedure pbImageMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure pbImageMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure btMinClick(Sender: TObject);
    procedure btResetClick(Sender: TObject);
    procedure btPos1Click(Sender: TObject);
    procedure btPos2MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure btAdvancedClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
 ClipBox: TBox;
 Lt: TLayout;
 x24, x12, y15, z24, z12: Integer;
 SelStart: Integer;
 Selecting: Boolean = False;
 Minimized: Boolean = False;
 Advanced: Boolean = False;
 Temp: TBitmap;
 Invert: array [0..2] of Boolean = (False,False,False);
 ExpandChanged: Boolean = False;

Procedure ChangePlaceObj(Init: Boolean = True);
procedure SetClipWndPos;
procedure InitClipping;
procedure InitClipExpand;
procedure SetClipExpand;

implementation

{$R *.dfm}

uses Main, Open, Sett, Hints;  

Procedure ChangePlaceObj(Init: Boolean = True);
begin
 DrawPieceBrk(PlacePos.x,PlacePos.y,PlacePos.z,PlaceObj.X,PlaceObj.Y,PlaceObj.Z,dmRemember,True);
 If Init then begin
  InitClipping;
  ExpandChanged:=False;
 end;
 BufObj:=LayoutToPiece(LtSel);
 If not ExpandChanged then InitClipExpand;
 SetClipExpand;
 DrawPieceBrk(PlacePos.x,PlacePos.y,PlacePos.z,PlaceObj.X,PlaceObj.Y,PlaceObj.Z,dmMerge,True);
end;

Procedure PaintLtPiece(x, y: Integer; Lt: TLayout; dest: TCanvas);
var a, dX, dY, dZ, pX, pY: Integer;
begin
 for a:=0 to Lt.X*Lt.Y*Lt.Z-1 do begin
  If Lt.Map[a].Index>0 then begin
   dX:=a mod Lt.X;
   dY:=(a div Lt.X) mod Lt.Y;
   dZ:=(a div Lt.X) div Lt.Y;
   If not BoxContains(ClipBox,dX,dY,dZ) then Continue;
   GridToPosVar(dX,dY,dZ,(Lt.Z-1)*24+x,(Lt.Y-1)*15+1+y,pX,pY);
   If Form1.cbFramesL.Checked then BackFrame(pX,pY,dest,clPanel);
   Form1.BrkBuff.Draw(Dest,pX,pY,BuffMap[Lt.Map[a].Index]);
   If Form1.cbFramesL.Checked then FrontFrame(pX,pY,dest,clPanel);
  end;
 end;
end;

procedure PaintClipping(Can: TCanvas);
var a: Integer;
    text: String;
begin
 If Length(VLibrary)<1 then Exit;
 Can.Brush.Style:= bsSolid;
 Can.FillRect(Can.ClipRect);
 Can.Brush.Style:= bsClear;
 Can.Pen.Color:= clBlack;

 Can.MoveTo(19,z12);
 Can.LineTo(0,z12);
 Can.LineTo(0,z12+y15+10);
 Form1.frClipping.Images.Draw(Can,2,z12+y15+1,3);
 for a:=1 to Lt.Y do begin
  Can.MoveTo(0,z12+a*15); Can.LineTo(20,z12+a*15);
  text:=IntToStr(Lt.Y-a+1);
  If (Lt.Y-a >= ClipBox.y1) and (Lt.Y-a <= ClipBox.y2) then begin
   Form1.frClipping.Images.Draw(Can,1,z12+a*15-14,0);
   Can.Font.Color:= clWhite;
  end
  else Can.Font.Color:=clBlack;
  Can.TextOut(10-(Can.TextWidth(text) div 2),z12+a*15-13,text);
 end;

 Can.MoveTo(0,z12+y15+10);
 Can.LineTo(x24,z12+x12+y15+10);
 Can.LineTo(x24+20,z12+x12+y15);
 Can.LineTo(x24+20,z12+x12+y15+10);
 Can.LineTo(x24,z12+x12+y15+10);
 Form1.frClipping.Images.Draw(Can,x24+12,z12+x12+y15+4,4);
 for a:=1 to Lt.X do begin
  Can.MoveTo(a*24-24,z12+a*12+y15-2);
  Can.LineTo(a*24-4,z12+a*12+y15-12);
  text:= IntToStr(a);
  If (a-1 >= ClipBox.x1) and (a-1 <= ClipBox.x2) then begin
   Form1.frClipping.Images.Draw(Can,a*24-22,z12+a*12+y15-11,1);
   Can.Font.Color:=clWhite;
  end
  else Can.Font.Color:= clBlack;
  Can.TextOut(a*24-(Can.TextWidth(text) div 2)-1,z12+a*12+y15-7,text);
 end;

 Can.MoveTo(x24+20,z12+x12+y15+10);
 Can.LineTo(x24+40,z12+x12+y15+10);
 Can.MoveTo(x24+20,z12+x12+y15);
 Can.LineTo(x24+40,z12+x12+y15+10);
 Can.LineTo(x24+40+z24,x12+y15+10);
 Form1.frClipping.Images.Draw(Can,x24+23,z12+x12+y15+4,5);
 for a:=1 to Lt.Z do begin
  Can.MoveTo(x24+a*24+20,z12+x12-a*12+y15);
  Can.LineTo(x24+a*24+40,z12+x12-a*12+y15+10);
  text:=IntToStr(Lt.Z-a+1);
  If (Lt.Z-a >= ClipBox.z1) and (Lt.Z-a <= ClipBox.z2) then begin
   Form1.frClipping.Images.Draw(Can,x24+a*24-2,z12+x12-a*12+y15+1,2);
   Can.Font.Color:= clWhite;
  end
  else Can.Font.Color:= clBlack;
  Can.TextOut(x24+a*24+18-(Can.TextWidth(text) div 2),z12+x12-a*12+y15+4,text);
 end;

 PaintLtPiece(20,0,Lt,Can);
end;

procedure SetClipWndPos;
begin
 With Form1 do begin
  If frClipping.btPos1.Down then begin
   frClipping.Left:= pbGrid.Left+pbGrid.Width+paMain.Left-frClipping.Width;
   frClipping.Top:= pbGrid.Top+paMain.Top;
   paAdv.Left:= pbGrid.Left+pbGrid.Width+paMain.Left-paAdv.Width;
   paAdv.Top:= frClipping.Top+frClipping.Height;
  end
  else if frClipping.btPos2.Down then begin
   frClipping.Left:= pbGrid.Left+paMain.Left;
   frClipping.Top:= pbGrid.Top+paMain.Top;
   paAdv.Left:= frClipping.Left;
   paAdv.Top:= frClipping.Top+frClipping.Height;
  end
  else if frClipping.btPos3.Down then begin
   frClipping.Left:= pbGrid.Left+paMain.Left;
   frClipping.Top:= pbGrid.Top+pbGrid.Height+paMain.Top-frClipping.Height;
   paAdv.Left:= frClipping.Left+frClipping.Width;
   paAdv.Top:= pbGrid.Top+pbGrid.Height+paMain.Top-paAdv.Height;
  end
  else if frClipping.btPos4.Down then begin
   frClipping.Left:= pbGrid.Left+pbGrid.Width+paMain.Left-frClipping.Width;
   frClipping.Top:= pbGrid.Top+pbGrid.Height+paMain.Top-frClipping.Height;
   paAdv.Left:= frClipping.Left-paAdv.Width;
   paAdv.Top:= pbGrid.Top+pbGrid.Height+paMain.Top-paAdv.Height;
  end;
 end;
end;

procedure SetSize;
begin
 With Form1.frClipping do begin
  If Minimized then begin
   Width:=22;
   Height:=22;
   btAdvanced.Visible:=False;
   SetClipWndPos;
  end
  else begin
   if ((Lt.X>1) or (Lt.Y>1) or (Lt.Z>1)) then begin
    Width:= GetLtWidth(Lt)+43;
    Height:= GetLtHeight(Lt)+13;
    btMin.Visible:= True;
    btPos3.Visible:= True;
    btPos4.Visible:= True;
   end
   else begin
    Width:=19;
    Height:=14;
    btMin.Visible:=False;
    btPos3.Visible:=False;
    btPos4.Visible:=False;
   end;
   btAdvanced.Visible:=True;  
   SetClipWndPos;
   SetDimensions(Image1,pbImage.Width,pbImage.Height);
   pbImage.Repaint;
  end;
 end;
 Form1.paAdv.Visible:=Advanced and not Minimized and Form1.btPlace.Down;
end;

procedure InitClipping;
begin
 If Length(VLibrary) <1  then Exit;
 Lt:= VLibrary[LtSel];
 x12:= Lt.X*12; x24:=x12*2; y15:=Lt.Y*15; z12:=Lt.Z*12; z24:=z12*2;
 ClipBox:= Box(0,0,0,Lt.X-1,Lt.Y-1,Lt.Z-1);
 Form1.frClipping.Visible:= Form1.btPlace.Down;
 SetSize;
end;

procedure TClipFrame.pbImagePaint(Sender: TObject);
begin
 PaintClipping(pbImage.Canvas);
end;

function YArea(x, y: Integer; out nr: Integer): Boolean;
begin
 Result:=(x>=0) and (y>=z12) and (x<=19) and (y<=z12+y15+9-(x div 2));
 nr:=Lt.Y-((y-z12) div 15)-1;
 If nr<0 then nr:=-1;
end;

function XArea(x, y: Integer; out nr: Integer): Boolean;
begin
 Result:=(x>(z12+y15+9-y)*2) and (x<(-z12-y15+y)*2+20) and (x>=(-z12-y15+y)*2-20)
     and (x<x24+20) and (y<=z12+x12+y15+10);
 nr:=(x+y*2-z24-y15*2-21) div 48;
 If nr>Lt.X-1 then nr:=-1;
end;

function ZArea(x, y: Integer; out nr: Integer): Boolean;
begin
 Result:=(x>=(z12+y15+x24+11-y)*2) and (x<=(z12-y15+10+y)*2) and (x<=(z12+y15+x24+30-y)*2)
     and (x>x24+20) and (y<=z12+x12+y15+10);
 nr:=(-x+y*2+z24-y15*2+20) div 48;
 If nr>Lt.Z-1 then nr:=-1;
end;

procedure TClipFrame.pbImageMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var nr: Integer;
begin
 If ssLeft in Shift then begin
  Selecting:=True;
  If YArea(X,Y,nr) then begin
   If nr<0 then begin ClipBox.y1:= 0;  ClipBox.y2:= Lt.Y-1; end
           else begin ClipBox.y1:= nr; ClipBox.y2:= nr; end;
  end
  else If XArea(X,Y,nr) then begin
   If nr<0 then begin ClipBox.x1:= 0;  ClipBox.x2:= Lt.X-1; end
           else begin ClipBox.x1:= nr; ClipBox.x2:= nr; end;
  end
  else If ZArea(X,Y,nr) then begin
   If nr<0 then begin ClipBox.z1:= 0;  ClipBox.z2:= Lt.Z-1; end
           else begin ClipBox.z1:= nr; ClipBox.z2:= nr; end;
  end
  else Selecting:=False;
  SelStart:=nr;
  pbImage.Repaint;
  ChangePlaceObj(False);
 end;
end;

procedure TClipFrame.pbImageMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
var nr: Integer;
begin
 PutHint(39);
 If Selecting and (ssLeft in Shift) then begin
  If YArea(X,Y,nr) and (nr>=0) then begin
   ClipBox.y1:= Min(SelStart,nr);
   ClipBox.y2:= Max(SelStart,nr);
  end;
  If XArea(X,Y,nr) and (nr>=0) then begin
   ClipBox.x1:= Min(SelStart,nr);
   ClipBox.x2:= Max(SelStart,nr);
  end;
  If ZArea(X,Y,nr) and (nr>=0) then begin
   ClipBox.z1:= Min(SelStart,nr);
   ClipBox.z2:= Max(SelStart,nr);
  end;
  pbImage.Repaint;
  ChangePlaceObj(False);
 end;
end;

procedure TClipFrame.btMinClick(Sender: TObject);
begin
 If Sender is TSpeedButton then Minimized:=not Minimized;
 If Minimized then btMin.Glyph.LoadFromResourceName(0,'EXPAND')
 else btMin.Glyph.LoadFromResourceName(0,'MINIMIZE');
 btAdvancedClick(Self);
end;

procedure TClipFrame.btAdvancedClick(Sender: TObject);
begin
 If Sender is TSpeedButton then Advanced:=not Advanced;
 If Advanced then btAdvanced.Glyph.LoadFromResourceName(0,'UPARROW')
 else btAdvanced.Glyph.LoadFromResourceName(0,'DNARROW');
 SetSize;
end;

procedure TClipFrame.btResetClick(Sender: TObject);
begin
 If Sender is TSpeedButton then
  SetForm.cbReset.Checked:=btReset.Down
 else
  btReset.Down:=SetForm.cbReset.Checked;
end;

procedure TClipFrame.btPos1Click(Sender: TObject);
begin
 SetClipWndPos;
end;

procedure TClipFrame.btPos2MouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
 Form1.btHandMouseMove(Sender,Shift,X,Y);
end;

procedure InitClipExpand;
begin
 Form1.seAX.Value:=BufObj.X;
 Form1.seAY.Value:=BufObj.Y;
 Form1.seAZ.Value:=BufObj.Z;
 ExpandChanged:=False;
end;

procedure SetClipExpand;
var a, b, c, d, e, f: Integer;
begin
 If BufObj.X=0 then Exit;
 DrawPieceBrk(PlacePos.x,PlacePos.y,PlacePos.z,PlaceObj.X,PlaceObj.Y,PlaceObj.Z,dmRemember,True);
 PlaceObj.X:=TryToConvert(Form1.seAX,BufObj.X);
 PlaceObj.Y:=TryToConvert(Form1.seAY,BufObj.Y);
 PlaceObj.Z:=TryToConvert(Form1.seAZ,BufObj.Z);
 SetLength(PlaceObj.Map,PlaceObj.X,PlaceObj.Y,PlaceObj.Z);
 If Invert[0] then d:=BufObj.X-(PlaceObj.X mod BufObj.X) else d:=0;
 If Invert[1] then e:=BufObj.Y-(PlaceObj.Y mod BufObj.Y) else e:=0;
 If Invert[2] then f:=BufObj.Z-(PlaceObj.Z mod BufObj.Z) else f:=0;
 for a:=0 to PlaceObj.X-1 do
  for b:=0 to PlaceObj.Y-1 do
   for c:=0 to PlaceObj.Z-1 do
    PlaceObj.Map[a,b,c]:=BufObj.Map[(a+d) mod BufObj.X,(b+e) mod BufObj.Y,(c+f) mod BufObj.Z];
 DrawPieceBrk(PlacePos.x,PlacePos.y,PlacePos.z,PlaceObj.X,PlaceObj.Y,PlaceObj.Z,dmMerge,True);
end;

end.
