//******************************************************************************
// Little Big Architect: Builder - editing grid files containing rooms in
//                                 Little Big Adventure 1 & 2
//
// Hints unit.
// Contains routines used for displaying hints and coordinates.
//
// Copyright Zink
// e-mail: zink@poczta.onet.pl
// See the GNU General Public License (License.txt) for details.
//******************************************************************************

unit Hints;

interface

uses ExtCtrls, Graphics, SysUtils, StrUtils, Math;

const HintArray: array[-1..79] of String =
   ('',
    'To open a grid file click File->Open (simple or advanced)',
{1} 'Hand - use for panning image',
    'Placer - use for placing layouts on the grid',
    'Selector - use for selecting bricks',
    'LEFT click to place layout on the grid at current layer'#13'LEFT HOLD and MOVE up/down to place at another layer'#13'RIGHT HOLD and MOVE up/down to change layer (without placing)',
{5} 'Left hold and move to pan image',
    'Select layout you want to place on the grid',
    'Select by single bricks',
    'Select by columns (cells of the grid)',
    'Select by layouts (bricks belonging to one layout)'#13'WARNING: Doesn''t work well for some layouts! (depends on arrangement)',
{10}'Shows frame(s) around brick(s) being moved',
    'Shows frames around layout that is to be placed',
    'Shows frames around layouts in the palette',
    'Shows frames below the moved layout/fragment,'#13'that help you to adjust its vertical position',
    'Adjusts vertical position of layout being placed',
{15}'LEFT click to select'#13'LEFT HOLD and MOVE to select area (doesn''t work for layout selecting)',
    'Drag with LEFT mouse button to move horizonatally (X and Z axes) (CTRL to copy)'#13'Drag with RIGHT mouse button to move vertically (Y axis)'#13'Press DEL to delete selected fragment',
    'Draws edges around bricks on the map',
    'Draws flat net behind the grid',
    'Draw only to specified layer'#13'Disables drawing of layers above specified',
{20}'RELEASE mouse button to drop the fragment',
    'Creates new empty grid',
    'Opens an existing grid so that you can edit it',
    'Saves current grid to a file that can be later used in LBA',
    'Exports current grid to a bitmap (WARNING: This function doesn''t work under Windows 98 and older)',
{25}'Exits the program',
    'Opens settings dialog box',
    'Shows/hides hint box',
    'Grid file successfully saved',
    'Image sucessfully exported',
{30}'Files successfully loaded',
    'Select by First Non-Transparent'#13'Selects: a brick that the pixel pointed by the mouse cursor belongs to',
    'Select by First Non-Empty'#13'Selects: a brick that is geometrically in front of the image and is under the mouse cursor',
    'Minimize/expand limits panel',
    'Lock at top right corner',
{35}'Lock at top left corner',
    'Lock at bottom left corner',
    'Lock at bottom right corner',
    'Toggle reset limits after placing',
    'Click on measure cells to delimit part of the layout that will be placed'#13'Click and move to select range'#13'Click on blue triangles to select full axes',
{40}'Invisible Bricks Mode - use for editing invisible bricks',
    'Shows frame(s) around brick pointed by the mouse, indicating which one it will be',
    'Undo last action',
    'Redo last undone action',
    'Coordinates panel - click to hide.',
{45}'Displays grid coordinates.',
    'Delete specified layer'#13'Deletes all contents of the layer which number is in the box on the left',
    'Show/hide Advanced panel.'#13'Advanced panel allows you to expand current layout to specified numbers of bricks in all axes.'#13'Layout will be cloned to fit the desired dimensions.',
    'Adjust X dimension',
    'Adjust Y dimension',
{50}'Adjust Z dimension',
    'Change alignment in X axis',
    'Change alignment in Y axis',
    'Change alignment in Z axis',
    'Shows frames in 3 dimensions coming from the moved layout/fragment,'#13'that help to adjust its position in all 3 dimensions',
{55}'Left hold and move to pan image'#13'When program is in Backward Communication Mode, then pressing <Shift> will switch to Track adding mode, and pressing <Shift>+<Ctrl> will switch to Actor adding mode',
    'Thumbnail - shows overview of the grid or fragment'#13'Click to jump to the area pointed by cursor',
    'Edit mode - allows you to move, delete scene elements, and add new ones',
    'Add Track mode - allows you to add new Tracks',
    'Program is in the Backward Communication Mode. It means that another program (a scene editor) can receive commands from Builder. Thus you can edit scene elements (Tracks, Zones and Actors) by dragging them with your mouse.',
{60}'Displays scene coordinates and information about selected scene elements',
    'Draws frames around invisible bricks',
    'Show Tracks',
    'Show Zones',
    'Show Actors',
{65}'Show clipping. Draws clipping rectangle around actors the use clipping',
    'Select all types of Zones to be displayed',
    'Select all types of Zones NOT to be displayed',
    'Show/hide Cube Zones (type 0)',
    'Show/hide Camera Zones (type 1)',
{70}'Show/hide Sceneric Zones (type 2)',
    'Show/hide Grid Zones (type 3)',
    'Show/hide Object Zones (type 4)',
    'Show/hide Text Zones (type 5)',
    'Show/hide Ladder Zones (type 6)',
{75}'LEFT hold and move to move an element in X and Z axes, RIGHT hold and move to move element in Y axis'#13'<Shift> - switch to Track adding mode. <Shift>+<Ctrl> - switch to Actor adding mode.'#13'<Ctrl> and LEFT click an Actor to duplicate it',
    'LEFT click to add a new Track at cursor position',
    'Creates a new wall made of invisible bricks',
    'Add Actor mode - allows you to add new Actors',
    'Scenario successfully saved');

 {CpatSingle = '[%d, %d, %d]';
 CpatRange: array[0..1] of String =
  ('[%d, %d, %d]  [%d, %d, %d]', '[%d; }

var
 HintsOn: Boolean = False;
 LastHint: Integer = -1;
 CurCoords, SelCoords, BrkInfo: String;

procedure PutHint(Index: Integer = -1);
procedure PutMessage(Index: Integer = -1);
procedure SetCoordsPos;
Function MouseToScene(X, Y: Integer; out sX, sY, sZ: Integer): Boolean;
procedure UpdateCoords(X: Integer = 0; Y: Integer = 0);

implementation

uses Main, Grids, BEngine, Engine, Sett, Scene, Open;

procedure PutHint(Index: Integer = -1);
begin
 If Form1.Timer.Enabled then Exit;
 If not HintsOn then Index:=0;
 If Index<>LastHint then begin
  Form1.Label8.Font.Color:= clBlack;
  Form1.Label8.Font.Size:= 8;
  Form1.Label8.Caption:= HintArray[Index];
  Form1.Label8.Repaint;
  LastHint:= Index;
 end;
end;

procedure PutMessage(Index: Integer = -1);
begin
 If Form1.Timer.Enabled then Exit;
 Form1.Label8.Font.Color:= clBlue;
 Form1.Label8.Font.Size:= 16;
 Form1.Label8.Caption:= HintArray[Index];
 Form1.Label8.Repaint;
 LastHint:= Index;
 Form1.Timer.Enabled:= True;
end;

procedure SetCoordsPos;
begin
 With Form1 do begin
  paCoords.Left:= pbGrid.Width - paCoords.Width + 1;
  paCoords.Top:= pbGrid.Height - paCoords.Height + 1;
 end;
end;

Function CoordsString(B: TBox): String;
begin
 If BoxIsPoint(B) then
  Result:= Format(' [%d, %d, %d] ',[B.x1,B.y1,B.z1])
 else if SetForm.rbRangeSep.Checked then
  Result:= Format(' [%d, %d, %d]  [%d, %d, %d] ',[B.x1,B.y1,B.z1,B.x2,B.y2,B.z2])
 else if SetForm.cbRangeHide.Checked then begin
  Result:= ' [' + IntToStr(B.x1);
  If B.x2 <> B.x1 then Result:= Result + ':' + IntToStr(B.x2);
  Result:= Result + ', ' + IntToStr(B.y1);
  If B.y2 <> B.y1 then Result:= Result + ':' + IntToStr(B.y2);
  Result:= Result + ', ' + IntToStr(B.z1);
  If B.z2 <> B.z1 then Result:= Result + ':' + IntToStr(B.z2);
  Result:= Result + ' ] ';
 end
 else Result:= Format(' [%d:%d, %d:%d, %d:%d] ',[B.x1,B.x2,B.y1,B.y2,B.z1,B.z2]);
end;

//uwzgldnia przyciganie (snap)
Function MouseToScene(X, Y: Integer; out sX, sY, sZ: Integer): Boolean;
var oX, oY, pX, pZ: Integer;
begin
 oX:= X - (PCursor.x1-PCursor.z1) * 24;
 oY:= Y + PCursor.y1*15 - (PCursor.x1+PCursor.z1) * 12;
 pX:= (oX div 2) + oY + 1;
 pZ:= Trunc(-(oX/2) + oY + 0.5);

 Result:= (pX >= 0) and (pX <= 24) and (pZ >= 0) and (pZ <= 24);

 If Result then begin 
  //If SetForm.cbSceneSnap.Checked then begin
  // sX:= PCursor.x1*512 + (Trunc((((oX/2)+oY+1) * (512/24))) div 256) * 256;
  // sZ:= PCursor.z1*512 + (Trunc(((-(oX/2)+oY+0.5) * (512/24))) div 256) * 256;
  //end
  //else begin
   //rX:=(PCursor.x1+1)*512;
   sX:= PCursor.x1*512 + Trunc(((oX/2)+oY+1) * (512/24));
   //rZ:=(FneCoords[2]+1)*512
   sZ:= PCursor.z1*512 + Trunc((-(oX/2)+oY+0.5) * (512/24));
  //end;
  sY:= (PCursor.y1+IfThen(Grid.Lba2,0,1)) * 256;
 end;
end;
//{$o-}
procedure UpdateCoords(X: Integer = 0; Y: Integer = 0);
var mi: TMapItem;
    CToDisp, ScenePix, SceneBrk, SceneSel: String;
    rX, rY, rZ: Integer;
begin
 If SceneMode then begin
  If (PCursor.x1 > -1) and BoxIsPoint(PCursor) then begin
   If SetForm.cbSceneBrk.Checked then
    SceneBrk:= Format(' [%d*512, %d*256, %d*512] ',
     [PCursor.x1, PCursor.y1+1-IfThen(Grid.Lba2,1), PCursor.z1]);
   If SetForm.cbScenePix.Checked and MouseToScene(X, Y, rX, rY, rZ) then
    ScenePix:= Format(' [%d, %d, %d] ',[rX,rY,rZ]);

   CToDisp:= ScenePix;
   If SceneBrk<>''  then CToDisp:= IfThen(CToDisp<>'',CToDisp+#13'          = ') + SceneBrk;
   //If SceneCom<>'' then SceneText:= IfThen(SceneText<>'',SceneText+#13'          = ')+SceneCom;
   If CToDisp<>'' then CToDisp:= ' Scene: ' + CToDisp;
    //Form1.pbGrid.Canvas.Ellipse(pX-5,pZ-5,pX+6,pZ+6);
  end;
  If SetForm.cbSceneSel.Checked and (SelType >= 1) and (SelType <= 3) then begin
   SceneSel:= ' Selected: ';
   case SelType of
    1: begin SceneSel:= SceneSel + 'Track';
             rX:= Tracks[SelId].x; rY:= Tracks[SelId].y; rZ:= Tracks[SelId].z; end;
    2: SceneSel:= SceneSel + 'Zone';
    3: begin SceneSel:= SceneSel + 'Actor';
             rX:= Actors[SelId].x; rY:= Actors[SelId].y; rZ:= Actors[SelId].z; end;
   end;
   SceneSel:= SceneSel + Format(' %d [%d, %d, %d]',[SelId,rX,rY,rZ]);
   CToDisp:= IfThen(CToDisp<>'',CToDisp+#13) + SceneSel;
  end;
  If SetForm.cbSceneClip.Checked then
   CToDisp:= IfThen(CToDisp<>'',CToDisp+#13) + Format(' Clip position: [%d, %d] ',[X, Y-24]);
 end
 else begin
  If Form1.btSelect.Down or Form1.btInv.Down then begin

   If SetForm.cbDispCur.Checked and (PCursor.x1>-1) then
    CurCoords:=' Cursor: '+CoordsString(PCursor)
   else CurCoords:='';

   If SetForm.cbDispSel.Checked and (Select.x1>-1) then
    SelCoords:=' Selection: '+CoordsString(Select)
   else SelCoords:='';

   BrkInfo:='';
   If SetForm.cbDispBrk.Checked then begin
    mi.BrkNr:=-1000;
    If SetForm.rbSelected.Checked and (Select.x1>-1) and BoxIsPoint(Select) then
     mi:= Map[Select.x1,Select.y1,Select.z1]
    else if SetForm.rbAtCursor.Checked and (PCursor.x1>-1) and BoxIsPoint(PCursor) then
     mi:= Map[PCursor.x1,PCursor.y1,PCursor.z1];
    If mi.BrkNr>-1000 then BrkInfo:= Format(' Layout: %d, Piece: %d, Brick: %d ',[mi.Idx.Lt,mi.Idx.Brk,mi.BrkNr]);
   end;
  end
  else if Form1.btPlace.Down and (PlacePos.x>-1) then
   CurCoords:=' Place: '+CoordsString(Box(PlacePos.x,PlacePos.y,PlacePos.z,
    PlacePos.x+PlaceObj.X-1,PlacePos.y+PlaceObj.Y-1,PlacePos.z+PlaceObj.Z-1));

  CToDisp:= CurCoords;
  If SelCoords <> '' then CToDisp:= IfThen(CToDisp<>'',CToDisp+#13) + SelCoords;
  If BrkInfo <> ''   then CToDisp:= IfThen(CToDisp<>'',CToDisp+#13) + BrkInfo;
 end;

 Form1.lbCoords.Caption:= CToDisp;
 //Form1.paCoords.Visible:=Form1.lbCoords.Caption<>'';
 SetCoordsPos;
end;

end.
