//******************************************************************************
// Little Big Architect: Builder - editing grid files containing rooms in
//                                 Little Big Adventure 1 & 2
//
// Open unit.
// Contains room opening dialog (advanced) routines.
//
// Copyright Zink
// e-mail: zink@poczta.onet.pl
// See the GNU General Public License (License.txt) for details.
//******************************************************************************

unit Open;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, DePack, Engine, Grids, Libraries, ExtCtrls, ComCtrls,
  ListForm;

type
  TOpenForm = class(TForm)
    fsferrrrrtg: TGroupBox;
    rb01: TRadioButton;
    rb02: TRadioButton;
    rb03: TRadioButton;
    paLib: TGroupBox;
    rb11: TRadioButton;
    rb12: TRadioButton;
    rb13: TRadioButton;
    laCombo: TComboBox;
    brBtn: TButton;
    laBtn: TButton;
    OpenBtn: TButton;
    Button1: TButton;
    DlgOpen: TOpenDialog;
    brText: TStaticText;
    laText: TStaticText;
    lbInfo: TLabel;
    dfgfggd: TGroupBox;
    rb31: TRadioButton;
    rb32: TRadioButton;
    rb33: TRadioButton;
    paBtn: TButton;
    paText: TStaticText;
    GridPage: TPageControl;
    GrOpen: TTabSheet;
    GrOpts: TTabSheet;
    gbGrid: TGroupBox;
    grBtn: TButton;
    grText: TStaticText;
    grCombo: TComboBox;
    rb21: TRadioButton;
    rb22: TRadioButton;
    rb23: TRadioButton;
    GroupBox1: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    eLibIndex: TEdit;
    eFragIndex: TEdit;
    cbAutoLib: TCheckBox;
    procedure rb21Click(Sender: TObject);
    procedure rb11Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure rb01Click(Sender: TObject);
    procedure grComboChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure brBtnClick(Sender: TObject);
    procedure laBtnClick(Sender: TObject);
    procedure grBtnClick(Sender: TObject);
    procedure rb31Click(Sender: TObject);
    procedure paBtnClick(Sender: TObject);
    procedure eLibIndexChange(Sender: TObject);
    procedure cbAutoLibClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  TPalType = (ptFile, ptLba, ptScen);

{const GriToBll1: array[0..133] of Byte = (0,1,1,1,1,2,1,3,4,5,3,1,6,1,3,5,2,7,
       1,7,2,4,1,0,1,1,3,3,2,2,3,2,3,3,8,1,9,1,8,9,4,4,6,3,6,6,6,6,2,0,3,8,2,2,2,
       8,8,4,2,10,10,2,5,5,0,5,0,0,0,5,0,5,5,5,8,8,8,8,6,8,8,5,5,0,6,8,8,8,8,0,4,
       5,5,11,6,0,5,6,0,0,6,8,2,2,1,0,12,12,12,12,12,12,12,12,12,12,13,13,1,3,
       0,0,0,0,2,3,8,4,8,8,5,0,0,9);
      GriToBll2: array[0..177] of Byte = (0,0,1,2,2,2,2,0,2,0,3,3,3,4,2,0,2,1,1,
       1,1,1,2,4,5,5,1,1,1,5,5,4,3,1,1,5,5,0,5,5,5,6,1,4,4,4,7,8,9,8,7,7,7,7,7,
       10,11,11,12,12,11,11,3,6,6,11,11,11,11,11,11,7,7,7,7,3,12,11,13,13,13,13,
       13,7,14,14,14,14,14,14,14,13,13,12,7,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,4,4,
       8,8,15,15,15,15,15,12,16,17,17,17,17,6,3,3,10,10,10,10,6,10,6,10,0,0,1,3,
       13,11,12,9,10,3,17,  //grids
       3,0,5,6,9,9,7,6,6,7,7,7,7,7,12,13,15,17,6,10,10,10,10,10,10,10,10,3,10,10); //fragments
      BllToGri1: array[0..13] of Byte = (0,1,5,7,8,9,12,17,34,36,59,93,106,116);
}
var
  OpenForm: TOpenForm;

 VBricks: TPackEntries;
 VLibrary: TLibrary;
 Grid: TGrid;
 Frag: TFragment;
 GridNow: Boolean; // false means that a fragment is loaded
 OriginalComp: Word;
 Buffer: TPackEntry;
 Palette, InvertPal: TPalette;
 PaletteType: TPalType;
 ScenarioOpen: Boolean;

 LibPath: String = '';
 LibIndex: Integer;
 GridPath: String = '';
 GridIndex: Integer;
 CurrentFile: String = '';
 CurrentIndex: Integer = 0;
 CurrentLibIndex: Integer = 0;

procedure SetModeOpen(Scenario: Boolean = False);
procedure SetModeNew(Scenario: Boolean = False);
Function FindRadio(Num1, Num2: Integer): TRadioButton;
Procedure CheckEnabled;
procedure OpenBricks(path: String);
procedure OpenLibrary(path: String; Index: Integer = 0);
procedure OpenGrid(path: String; Index: Integer = 0);
Procedure OpenFiles(New: Boolean = False);

implementation

uses StrUtils, Sett, Main, ProgBar, BEngine, Hints, OpenSim, ListDialog,
     Scenario, OpScenGrid;

{$R *.dfm}

Procedure ErrorFileNotExists(path, name: String);
begin
 MessageBox(Form1.Handle,PChar(Format('%s file doesn''t exist!'#13'The file was not found on path "%s".',[name,path])),ProgramName,MB_ICONERROR+MB_OK);
 Screen.Cursor:=crDefault;
 Abort;
end;

Function AutoLibrary: Boolean;
begin
 Result:=OpenForm.cbAutoLib.Enabled and OpenForm.cbAutoLib.Visible and OpenForm.cbAutoLib.Checked;
end;

Procedure EnableOpen;
var a: Integer;
begin
 with OpenForm do
  OpenBtn.Enabled:=
   ((not rb13.Checked and (laCombo.ItemIndex>-1)) or (rb13.Checked and (laText.Caption<>'')) or AutoLibrary)
   and ((GridPage.ActivePage=grOpen) and ((grCombo.ItemIndex>-1) or (rb23.Checked and (grText.Caption<>'')))
    or ((GridPage.ActivePage=GrOpts) and TryStrToInt(eLibIndex.Text,a) and TryStrToInt(eFragIndex.Text,a)))
   and ((not rb03.Checked) or (brText.Caption<>''))
   and ((not rb33.Checked) or (paText.Caption<>''));
end;

Function FindRadio(Num1, Num2: Integer): TRadioButton;
begin
 Result:=OpenForm.FindComponent(Format('rb%d%d',[Num1,Num2])) as TRadioButton;
end;

Procedure CheckAutoLib;
begin
 OpenForm.cbAutoLib.Enabled:=(BkgSpec and (IsBkg(GridPath) or ExtIs(GridPath,'.gr2'))) or (BllSpec and ExtIs(GridPath,'.hqr') and not IsBkg(GridPath));
 If not OpenForm.cbAutoLib.Enabled then OpenForm.cbAutoLib.Checked:=False;
 OpenForm.cbAutoLibClick(Form1);
end;

Procedure CheckEnabled;
var a: Integer;
begin
 For a:= 0 to 3 do begin
  If (a = 1) and AutoLibrary then Continue;
  If (FindRadio(a,1).Checked and not FindRadio(a,1).Enabled)
  or (FindRadio(a,2).Checked and not FindRadio(a,2).Enabled)
   then FindRadio(a,3).Checked:= True;
 end;
 EnableOpen;
end;

Procedure SelectLba(v: Integer);
var a: Integer;
begin
 For a:= 0 to 3 do
  FindRadio(a,v).Checked:= not FindRadio(a,3).Checked;
end;

procedure TOpenForm.rb21Click(Sender: TObject);
var a: Integer;
begin
 for a:= 1 to 2 do
  If FindRadio(2,a).Checked then begin
   SelectLba(a);
   If ScenarioOpen then begin
    LoadCombo(grCombo,-a,'GRI');
    If a = 2 then
     while Copy(grCombo.Items.Strings[grCombo.Items.Count-1],1,10) = '[fragment]' do
      grCombo.Items.Delete(grCombo.Items.Count - 1);
   end
   else LoadCombo(grCombo,a,'GRI');
  end;
 cbAutoLib.Visible:= rb23.Checked;
 CheckEnabled;
 laCombo.Enabled:= not (rb21.Checked or rb22.Checked or AutoLibrary);
 laCombo.Visible:= not rb13.Checked;
 laText.Visible:= rb13.Checked;
 laBtn.Visible:= rb13.Checked;
 grCombo.Visible:= not rb23.Checked;
 grText.Visible:= rb23.Checked;
 grBtn.Visible:= rb23.Checked;
end;

procedure TOpenForm.rb11Click(Sender: TObject);
var a: Integer;
begin
 For a:= 1 to 2 do
  If FindRadio(1,a).Checked then begin
   SelectLba(a);
   LoadCombo(laCombo, a, 'BLL');
  end;
 CheckEnabled;
 laCombo.Enabled:= not (rb21.Checked or rb22.Checked);
 laCombo.Visible:= not rb13.Checked;
 laText.Visible:= rb13.Checked;
 laBtn.Visible:= rb13.Checked;
end;

procedure TOpenForm.rb01Click(Sender: TObject);
begin
 If rb01.Checked then SelectLba(1);
 If rb02.Checked then SelectLba(2);
 CheckEnabled;
 laCombo.Enabled:= not (rb21.Checked or rb22.Checked);
 laCombo.Visible:= not rb13.Checked;
end;

procedure TOpenForm.rb31Click(Sender: TObject);
begin
 If rb31.Checked then SelectLba(1);
 If rb32.Checked then SelectLba(2);
 CheckEnabled;
 laCombo.Visible:= not rb13.Checked;
end;

procedure TOpenForm.FormCreate(Sender: TObject);
begin
 //rb21Click(Self);
 //rb11Click(Self);
end;

procedure TOpenForm.grComboChange(Sender: TObject);
var a, b: Integer;
begin
 If rb21.Checked then begin
  b:= GriToBll1[grCombo.ItemIndex];
  for a:= 0 to High(BllToGri1) do
   If BllToGri1[a] = b then begin
    laCombo.ItemIndex:= a;
    Break;
   end;
 end
 else if rb22.Checked then
  laCombo.ItemIndex:= GriToBll2[grCombo.ItemIndex] - GriToBll2[0];
 EnableOpen;
end;

procedure SetModeOpen(Scenario: Boolean = False);
begin
 OpenForm.Caption:= 'Open room';
 If Scenario then OpenForm.lbInfo.Caption:= 'For Scenario you can open only files from compatible LBA version.'
 else OpenForm.lbInfo.Caption:= 'If some choices are disabled, it''s because appropriate LBA files are not specified (path settings).';
 OpenForm.GridPage.ActivePage:= OpenForm.GrOpen;
 OpenForm.OpenBtn.Caption:= 'Open';
 ScenarioOpen:= Scenario;
 OpenForm.rb21Click(OpenForm);
end;

procedure SetModeNew(Scenario: Boolean = False);
begin
 OpenForm.Caption:= 'New room';
 If Scenario then OpenForm.lbInfo.Caption:= 'For Scenario you can open only files from compatible LBA version.'
 else OpenForm.lbInfo.Caption:= 'If some choices are disabled, it''s because appropriate LBA files are not specified (path settings).';
 OpenForm.GridPage.ActivePage:= OpenForm.GrOpts;
 OpenForm.OpenBtn.Caption:= 'New';
 OpenForm.rb23.Checked:= True;
 OpenForm.cbAutoLib.Checked:= False;
 ScenarioOpen:= Scenario;
end;

procedure TOpenForm.FormShow(Sender: TObject);
begin
 //LoadGriToBllTables();
 rb01.Enabled:= BrkSpec and (not ScenarioOpen or not HQSInfo.Lba2);
 rb11.Enabled:= BllSpec and (not ScenarioOpen or not HQSInfo.Lba2);
 rb21.Enabled:= GriSpec and (not ScenarioOpen or not HQSInfo.Lba2);
 rb31.Enabled:= (not ScenarioOpen or not HQSInfo.Lba2);
 rb02.Enabled:= BkgSpec and (not ScenarioOpen or HQSInfo.Lba2);
 rb12.Enabled:= BkgSpec and (not ScenarioOpen or HQSInfo.Lba2);
 rb22.Enabled:= BkgSpec and (not ScenarioOpen or HQSInfo.Lba2);
 rb32.Enabled:= (not ScenarioOpen or HQSInfo.Lba2);
 If GridPath <> '' then begin
  If not ExtIs(GridPath,'.hqr') then
   OpenForm.grText.Caption:= GridPath
  else if GridIndex >= 0 then
   OpenForm.grText.Caption:= GridPath + ', entry ' + IntToStr(GridIndex + 1);
 end;
 CheckAutoLib;
 CheckEnabled;
 rb21Click(Self);
 rb11Click(Self);
end;

procedure TOpenForm.brBtnClick(Sender: TObject);
begin
 DlgOpen.Title:= 'Open Brick package';
 DlgOpen.FileName:= brText.Caption;
 If ScenarioOpen then begin
  If HQSInfo.Lba2 then DlgOpen.Filter:= 'LBA 2 Bricks (lba_bkg.hqr)|*lba_bkg*.hqr'
  else DlgOpen.Filter:= 'LBA 1 Bricks (lba_brk.hqr)|*lba_brk*.hqr';
 end
 else DlgOpen.Filter:= 'LBA Bricks (lba_brk.hqr or lba_bkg.hqr)|*lba_brk*.hqr;*lba_bkg*.hqr';
 If DlgOpen.Execute then begin
  If not ScenarioOpen
  or CheckGridVersion(IsBkg(DlgOpen.FileName),'Bricks') then begin
   brText.Caption:= DlgOpen.FileName;
   rb03.Checked:= True;
  end; 
 end;
 EnableOpen;
end;

procedure TOpenForm.laBtnClick(Sender: TObject);
var p: TSmallPoint;
    a, lba: Integer;
    ext: String;
begin
 DlgOpen.Title:= 'Open Layout library or package';
 DlgOpen.FileName:= LibPath;
 If ScenarioOpen then begin
  If HQSInfo.Lba2 then DlgOpen.Filter:= 'LBA 2 Libraries (*.bl2, lba_bkg.hqr)|*.bl2;*lba_bkg*.hqr'
  else DlgOpen.Filter:= 'LBA 1 Libraries (*.bl1, lba_bll.hqr)|*.bl1;*lba_bll*.hqr';
 end
 else DlgOpen.Filter:= 'All supported (*.bl1, *.bl2, lba_bll.hqr, lba_brk.hqr)|*.bl1;*.bl2;*lba_bll*.hqr;*lba_bkg*.hqr|'+
                       'Layout libraries (*.bl1, *.bl2)|*.bl1;*.bl2|'+
                       'lba_bll.hqr or lba_bkg.hqr|*lba_bll*.hqr;*lba_bkg*.hqr';
 DlgOpen.FilterIndex:= 1;
 If DlgOpen.Execute then begin
  ext:= LowerCase(ExtractFileExt(DlgOpen.FileName));
  If ext = '.hqr' then begin
   //p.x:= 1;
   If IsBkg(DlgOpen.FileName) then lba:= 2 else lba:= 1;
   If not ScenarioOpen or CheckGridVersion(lba = 2,'Library') then begin
    //If lba = 2 then p:= BkgEntriesCount(DlgOpen.FileName,weLibs)
    //else p.y:= PackEntriesCount(DlgOpen.FileName);
    //If fmListForm.ShowDialog(Format('LBA_%d_BLL',[lba]),p.y-p.x+1,a) then begin
    If AnsiSameText(DlgOpen.FileName,LibPath) then a:= LibIndex
                                              else a:= -1;
     a:= HQRListDialog(DlgOpen.FileName, weLibs, lba = 1,
       'Please select a Library from the package:'#13'(only normal entries are shown)',a);
    If a > -1 then begin
     LibPath:= DlgOpen.FileName;
     //If lba = 1 then LibIndex:= BllToGri1[a+p.x-1]+1 else LibIndex:= a+p.x;
     LibIndex:= a;
     laText.Caption:= Format('%s, entry %d',[LibPath,LibIndex + 1]);
     rb13.Checked:= True;
    end;
   end;
  end
  else if (ext = '.bl1') or (ext = '.bl2') then begin
   If not ScenarioOpen or CheckGridVersion(ext = '.bl2','Library') then begin
    LibPath:= DlgOpen.FileName;
    laText.Caption:= LibPath;
    rb13.Checked:= True;
   end;
  end
  else
   MessageBox(OpenForm.Handle,'Unknown extension!',ProgramName,MB_ICONERROR+MB_OK);
 end;
 EnableOpen;
end;

procedure TOpenForm.grBtnClick(Sender: TObject);
var p: TSmallPoint;
    a, lba: Integer;
    ext: String;
begin
 DlgOpen.Title:='Open Grid, Fragment or package';
 DlgOpen.FileName:= GridPath;
 If ScenarioOpen then begin
  If HQSInfo.Lba2 then DlgOpen.Filter:= 'LBA 2 Grids (*.gr2, lba_bkg.hqr)|*.gr2;*lba_bkg*.hqr'
  else DlgOpen.Filter:= 'LBA 1 Grids (*.gr1, lba_gri.hqr)|*.gr1;*lba_gri*.hqr';
 end
 else DlgOpen.Filter:= 'All supported (*.gr1, *.gr2, *.grf, lba_gri.hqr, lba_bkg.hqr)|*.gr1;*.gr2;*.grf;*lba_gri*.hqr;*lba_bkg*.hqr|' +
                       'Grid files (*.gr1, *.gr2)|*.gr1;*.gr2|' +
                       'Grid fragments (*.grf)|*.grf|' +
                       'lba_gri.hqr or lba_bkg.hqr|*lba_gri*.hqr;*lba_bkg*.hqr';
 DlgOpen.FilterIndex:= 1;
 If DlgOpen.Execute then begin
  ext:= LowerCase(ExtractFileExt(DlgOpen.FileName));
  If ext= '.hqr' then begin
   //p.x:= 1;
   If IsBkg(DlgOpen.FileName) then lba:= 2 else lba:= 1;
   If not ScenarioOpen or CheckGridVersion(lba = 2,'Grid') then begin
    //If (lba = 2) then p:= BkgEntriesCount(DlgOpen.FileName,weGrids)
    //else p.y:= PackEntriesCount(DlgOpen.FileName);
    //If fmListForm.ShowDialog(Format('LBA_%d_GRI',[lba]),p.y-p.x+1,a) then begin
    If AnsiSameText(DlgOpen.FileName,GridPath) then a:= GridIndex
                                               else a:= -1;
     a:= HQRListDialog(DlgOpen.FileName, weGridFrag, lba = 1,
       'Please select a Grid from the package:'#13'(only normal entries are shown)',a);
    If a > -1 then begin
     GridPath:= DlgOpen.FileName;
     GridIndex:= a; // + p.x;
     grText.Caption:= Format('%s, entry %d',[GridPath,GridIndex + 1]);
     rb23.Checked:= True;
    end;
   end;
  end
  else if (ext = '.gr1') or (ext = '.gr2') or (ext = '.grf') then begin
   If not ScenarioOpen
   or (CheckGridVersion(ext = '.gr2','Grid')
       and CheckGridFragment(ext = '.grf')) then begin
    GridPath:= DlgOpen.FileName;
    grText.Caption:= GridPath;
    rb23.Checked:= True;
   end;
  end
  else
   MessageBox(OpenForm.Handle,'Unknown extension!',ProgramName,MB_ICONERROR+MB_OK);
 end;
 //EnableOpen;
 CheckAutoLib;
end;

procedure TOpenForm.paBtnClick(Sender: TObject);
begin
 DlgOpen.Title:='Open palette';
 DlgOpen.FileName:=paText.Caption;
 DlgOpen.Filter:='LBA palette files (*.pal)|*.pal';
 If DlgOpen.Execute then begin
  paText.Caption:=DlgOpen.FileName;
  rb33.Checked:=True;
 end;
 EnableOpen;
end;

procedure OpenPalette(path: String);
begin
 If not FileExists(path) then ErrorFileNotExists(path,'Palette');
 Palette:= LoadPaletteFromFile(path);
 //InvertPal:= InvertPalette(Palette);
 PaletteType:= ptFile;
end;

procedure OpenBricks(path: String);
var FStr: TFileStream;
    p: TSmallPoint;
begin
 If not FileExists(path) then ErrorFileNotExists(path,'Brick');
 FStr:= TFileStream.Create(path,fmOpenRead,fmShareDenyWrite);
 If AnsiContainsText(path,'lba_bkg') then begin
  TransparentBrick:= BkgEntriesCount(FStr,weTransparent).y + 1;
  p:= BkgEntriesCount(FStr,weBricks);
  VBricks:= OpenPack(FStr,p.x-1,p.x+p.y);
 end
 else begin
  TransparentBrick:= 0;
  VBricks:= OpenPack(FStr);
 end;
 FStr.Free;
end;

procedure OpenLibrary(path: String; Index: Integer = 0);
var FStr: TFileStream;
    ext: String;
begin
 If not FileExists(path) then ErrorFileNotExists(path,'Library');
 FStr:= TFileStream.Create(path,fmOpenRead,fmShareDenyWrite);
 ext:= LowerCase(ExtractFileExt(path));
 If ext= '.bll' then
  VLibrary:= LoadLibraryFromStream(FStr)
 else if ext= '.hqr' then
  VLibrary:= LoadLibraryFromStream(UnpackToStream(OpenSingleEntry(FStr,Index)));
 FStr.Free;
 CurrentLibIndex:= Index;
end;

procedure OpenGrid(path: String; Index: Integer = 0);
var FStr: TFileStream;
    ext: String;
    VPack: TPackEntry;
    p: TSmallPoint;
begin
 If not FileExists(path) then ErrorFileNotExists(path,'Grid');
 FStr:= TFileStream.Create(path,fmOpenRead,fmShareDenyWrite);
 ext:= LowerCase(ExtractFileExt(path));
 If (ext = '.gr1') or (ext = '.gr2') then begin
  Grid:= LoadGridFromStream(FStr,ext='.gr2');
  OriginalComp:= 0;
  GridNow:= True;
 end
 else if ext = '.grf' then begin
  Frag:= LoadFragFromStream(FStr);
  OriginalComp:= 0;
  GridNow:= False;
 end
 else if ext = '.hqr' then begin
  VPack:= OpenSingleEntry(FStr,Index);
  GridNow:= True;
  If IsBkg(path) then begin
   //TransparentBrick:= BkgEntriesCountS(FStr,weTransparent).y + 1;
   p:= BkgEntriesCount(FStr,weFrags);
   If Index + 1 < p.x then
    Grid:= LoadGridFromStream(UnpackToStream(VPack),True)
   else begin
    Frag:= LoadFragFromStream(UnpackToStream(VPack));
    GridNow:= False;
   end;
  end
  else Grid:= LoadGridFromStream(UnpackToStream(VPack),False);
  OriginalComp:= VPack.Comp;
 end;
 CurrentFile:= path;
 CurrentIndex:= Index;
 FStr.Free;
end;

Procedure OpenFiles(New: Boolean = False);
var p: TSmallPoint;
begin
 TransparentBrick:= 0;

 With OpenForm do begin
  PaletteType:= ptLba;
  If rb31.Checked then Palette:= LoadPaletteFromResource(1)
  else if rb32.Checked then Palette:= LoadPaletteFromResource(2)
  else OpenPalette(paText.Caption);

  If New then
   GridNow:= True
  else begin
   If rb21.Checked then OpenGrid(SetForm.peGri.Path,grCombo.ItemIndex)
   else if rb22.Checked then begin
    p:= BkgEntriesCount(SetForm.peBkg.Path,weGrids);
    OpenGrid(SetForm.peBkg.Path,grCombo.ItemIndex+p.x-1);
   end
   else OpenGrid(GridPath,GridIndex);
  end;

  If AutoLibrary then begin
   If ExtIs(GridPath,'.gr2') or IsBkg(GridPath) then begin
    p:= BkgEntriesCount(SetForm.peBkg.Path,weLibs);
    OpenLibrary(SetForm.peBkg.Path,Grid.LibIndex+p.x-1);
   end
   else if ExtIs(GridPath,'.hqr') then
    OpenLibrary(SetForm.peBll.Path,GridIndex);
  end
  else begin
   If rb11.Checked then OpenLibrary(SetForm.peBll.Path,BllToGri1[laCombo.ItemIndex])
   else if rb12.Checked then begin
    p:= BkgEntriesCount(SetForm.peBkg.Path,weLibs);
    OpenLibrary(SetForm.peBkg.Path,laCombo.ItemIndex + p.x - 1);
   end
   else OpenLibrary(LibPath,LibIndex);
  end;

  If rb01.Checked then OpenBricks(SetForm.peBrk.Path)
  else if rb02.Checked then OpenBricks(SetForm.peBkg.Path)
  else OpenBricks(brText.Caption);
 end;
end;

procedure TOpenForm.eLibIndexChange(Sender: TObject);
begin
 If (Sender is TComboBox) and rb12.Checked then
  eLibIndex.Text:= IntToStr(laCombo.ItemIndex);
 EnableOpen;
end;

procedure TOpenForm.cbAutoLibClick(Sender: TObject);
begin
 rb11.Enabled:= BllSpec and not AutoLibrary and (not ScenarioOpen or not HQSInfo.Lba2);
 rb12.Enabled:= BkgSpec and not AutoLibrary and (not ScenarioOpen or HQSInfo.Lba2);
 rb13.Enabled:= not AutoLibrary;
 laCombo.Enabled:= not (rb21.Checked or rb22.Checked or AutoLibrary);
 laBtn.Enabled:= not AutoLibrary;
 EnableOpen;
end;

end.
