//******************************************************************************
// Little Big Architect: Builder - editing grid files containing rooms in
//                                 Little Big Adventure 1 & 2
//
// OpenSim unit.
// Contains room opening dialog (simple) routines.
//
// Copyright Zink
// e-mail: zink@poczta.onet.pl
// See the GNU General Public License (License.txt) for details.
//******************************************************************************

unit OpenSim;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, StrUtils, ExtCtrls, DePack, ListForm, HQDesc;

type
  TSimpleForm = class(TForm)
    OpenBtn: TButton;
    Button1: TButton;
    grSimCombo: TComboBox;
    Label1: TLabel;
    rb21: TRadioButton;
    rb22: TRadioButton;
    Label2: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure rb21Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SimpleForm: TSimpleForm;

  GridIndexList, LibIndexList: TIndexList;
  GriToBll1, BllToGri1, GriToBll2: TIndexList;


Procedure EnableControls(Enable: Boolean = True; New: Boolean = False);
Procedure ResetControls(Full: Boolean = True);
procedure OpenFinalize(New: Boolean = False);
procedure SetMapsLengths(hX, hY, hZ: Integer);
procedure LoadTexts(Combo: TComboBox; Name: String);
Procedure LoadCombo(Dest: TComboBox; Tag: Integer; What: String);
Procedure CheckModified();
procedure OpenSimpleFiles();
procedure LoadGriToBllTables();

implementation

uses Main, Open, Hints, BEngine, Sett, Engine, ProgBar, Scene, Scenario;

{$R *.dfm}

Procedure EnableControls(Enable: Boolean = True; New: Boolean = False);
begin
 Form1.paSplash.Visible:= not Enable;
 Form1.paTools.Visible:= Enable;
 Form1.paLayout.Visible:= Enable;
 Form1.Splitter1.Visible:= Enable;
 If Enable then Form1.paLayout.Left:= 0;
 Form1.pbGrid.Visible:= Enable;
 Form1.pbThumb.Visible:= Enable;
 Form1.pbLts.Visible:= Enable;
 Form1.aExport.Enabled:= Enable;
 Form1.HScr.Enabled:= Enable;
 Form1.VScr.Enabled:= Enable;
 Form1.LScr.Enabled:= Enable;
 Form1.aSave.Enabled:= not New and Enable;
 Form1.aSaveAs.Enabled:= Enable;
 Form1.aExportScen.Enabled:= Enable;
 HintsOn:= Enable;
 Form1.FormResize(Form1);
 If not Enable then CloseScenario;
end;

Procedure ResetControls(Full: Boolean = True);
begin
 If Full then begin
  LtSel:=1;
  Form1.pbLtsMouseDown(Form1,mbLeft,[],0,0);
  If Form1.LScr.Enabled then Form1.LScr.Position:=0;
  If Form1.HScr.Enabled then Form1.HScr.Position:=(Form1.HScr.Max-Form1.HScr.PageSize) div 2;
  If Form1.VScr.Enabled then Form1.VScr.Position:=(Form1.VScr.Max-Form1.VScr.PageSize) div 5;
  LastUndo:=0;
  FirstRedo:=0;
 end;
 Select:=BoxPoint(-1,-1,-1);
 LastSelect:=Select;
 SelStart:=Select;
 PCursor:=Select;
 LastPCursor:=Select;
 PlacePos:=Point3d(-1000,-1000,-1000);
 LastPlacePos:=PlacePos;
 Placing:=False;
 VMoving:=False;
 Selecting:=False;
 MoveAllowed:=False;
 FHMoving:=False;
 FVMoving:=False;
 InvPlacing:=False;
 ObjCopied:=False;
end;

procedure OpenFinalize(New: Boolean = False);
begin
 Form1.pcControls.ActivePage:= Form1.tsNormal;
 BufferBricks(VLibrary,VBricks);
 CreateThumbnail;
 MakeLayoutMap;
 PaintLayouts;
 EnableControls(True,New);
 ResetControls;
 Modified:= False;
 DrawMapA;
 ProgBarForm.CloseSpecial;
 PutMessage(30);
end;

procedure SetMapsLengths(hX, hY, hZ: Integer);
begin
 HighX:= hX;
 HighY:= hY;
 HighZ:= hZ;
 SetLength(Map,hX+1,hY+1,hZ+1);
 SetLength(RedoMap,hX+1,hY+1,hZ+1);
 ImageW:= (hX+hZ+2)*24 + 40;
 ImageH:= (hX+hZ+2)*12 + (hY+1)*15 + 40;
 Off_X:= (hZ)*24 + 20;
 Off_Y:= (hY+1)*15 + 5;
 Form1.seToLayer.MaxValue:= hY;
 Form1.seScToLayer.MaxValue:= hY;
 Form1.sePlace.MaxValue:= hY;
 Form1.seX.MaxValue:= hX + 1;
 Form1.seY.MaxValue:= hY + 1;
 Form1.seZ.MaxValue:= hZ + 1;
 Form1.seAX.MaxValue:= hX + 1;
 Form1.seAY.MaxValue:= hY + 1;
 Form1.seAZ.MaxValue:= hZ + 1;
end;

{procedure LoadTexts(Combo: TComboBox; Tag: Integer; What: String);
var f: TextFile;
    temp, ext, desc: String;
begin
 If (Tag=2) then desc:='all' else desc:=What;
 temp:=ExtractFilePath(Application.ExeName)+Format('Lba%d%s.hqd',[Tag,desc]);
 If FileExists(temp) then begin
  Combo.Items.Clear;
  AssignFile(f,temp);
  Reset(f);
  ReadLn(f,temp); //file description
  ReadLn(f,temp); //first entry
  repeat
   ReadLn(f,temp);
   ext:=Copy(temp,1,3);
   desc:=Copy(temp,5,Length(temp)-4);
   If Trim(desc)='' then desc:='unknown';
   If (Tag=2) then begin
    If (What='grids') then begin
     If ext='gr2' then Combo.Items.Add('[grid] '+desc)
     else if ext='grf' then Combo.Items.Add('[fragment] '+desc);
    end
    else if ext='bl2' then Combo.Items.Add(desc);
   end
   else Combo.Items.Add(desc);
  until Eof(f) or ((Tag=2) and ((ext<>'gr2') or (ext<>'grf')));
  CloseFile(f);
 end;
end;}

procedure LoadTexts(Combo: TComboBox; Name: String);
var FRes: TResourceStream;
begin
 FRes:= TResourceStream.Create(0,Name,'TEXT');
 Combo.Items.LoadFromStream(FRes);
 FRes.Free;
end;

{Procedure LoadCombo(Dest: TComboBox; Tag: Integer; What: String);
begin
 If Dest.Tag <> Tag then begin
  LoadTexts(Dest,Format('LBA_%d_%s',[Abs(Tag),What]));
  Dest.Tag:= Tag;
  If Dest.Name= 'grCombo' then
   OpenForm.laCombo.ItemIndex:= -1;
 end;
end;}

Procedure LoadCombo(Dest: TComboBox; Tag: Integer; What: String);
var a: Integer;
    Names: TStrArray;
    path: String;
begin
 If Dest.Tag <> Tag then begin
  If Tag = 1 then begin
   If What = 'GRI' then path:= SetForm.peGri.Path
                   else path:= SetForm.peBll.Path;
  end
  else path:= SetForm.peBkg.Path;
  If What = 'GRI' then
   Names:= MakeDescriptionList(path, weGridFrag, Tag = 1, GridIndexList)
  else
   Names:= MakeDescriptionList(path, weLibs, Tag = 1, LibIndexList);

  Dest.Clear;
  for a:= 0 to High(Names) do
   Dest.Items.Add(Names[a]);

  //LoadTexts(Dest,Format('LBA_%d_%s',[Abs(Tag),What]));
  Dest.Tag:= Tag;
  If Dest.Name= 'grCombo' then
   OpenForm.laCombo.ItemIndex:= -1;
 end;
end;

procedure TSimpleForm.FormCreate(Sender: TObject);
begin
 //rb21Click(Self);
end;

procedure TSimpleForm.rb21Click(Sender: TObject);
begin
 If rb21.Checked then LoadCombo(grSimCombo,1,'GRI')
 else LoadCombo(grSimCombo,2,'GRI');
 OpenBtn.Enabled:= grSimCombo.ItemIndex > -1;
end;

Procedure CheckModified;
begin
 If Modified then
  case MessageBox(Form1.handle,'Current grid/fragment has been changed. Save?'#13#13'Note that it will save the Grid only, even if a Scenario is opened.'#13'If you want to save the Scenario, click "Cancel" and choose File -> Export to a Scenario.',ProgramName,MB_ICONQUESTION+MB_YESNOCANCEL) of
   ID_YES: begin
    Form1.aSaveExecute(Form1);
    If Modified then Abort;
   end;
   ID_CANCEL: Abort;
  end;
end;

procedure TSimpleForm.FormShow(Sender: TObject);
begin
 rb21.Enabled:= BrkSpec and BllSpec and GriSpec;
 rb22.Enabled:= BkgSpec;
 If rb21.Checked and not rb21.Enabled then rb22.Checked:= True;
 If rb22.Checked and not rb22.Enabled then rb21.Checked:= True;
 grSimCombo.Enabled:= rb21.Enabled or rb22.Enabled;
 If not grSimCombo.Enabled then begin
  Label2.Caption:= 'No LBA 1 or 2 files specified. If you want to open a grid from a single file or with different settings, choose File->Open (advanced).';
  grSimCombo.ItemIndex:= -1;
 end else
  Label2.Caption:= 'This way you can open only standard LBA grids. If you want to open grids from single files or with different settings, please choose File->Open (advanced).';
 rb21Click(Self);
end;

procedure OpenSimpleFiles;
var p: TSmallPoint;
begin
 TransparentBrick:= 0;
 SetLength(VScen,0);

 With SimpleForm do begin
  If rb21.Checked then Palette:= LoadPaletteFromResource(1)
  else Palette:= LoadPaletteFromResource(2);
  InvertPal:= InvertPalette(Palette);

  If rb21.Checked then OpenGrid(SetForm.peGri.Path,grSimCombo.ItemIndex)
  else begin
   p:= BkgEntriesCount(SetForm.peBkg.Path,weGrids);
   OpenGrid(SetForm.peBkg.Path,grSimCombo.ItemIndex+p.x-1);
  end;

  If rb21.Checked then OpenLibrary(SetForm.peBll.Path,grSimCombo.ItemIndex)
  else begin
   //p:= BkgEntriesCount(SetForm.peBkg.Path,weLibs);
   //If GridNow then OpenLibrary(SetForm.peBkg.Path,Grid.LibIndex+p.x-1)
   //else OpenLibrary(SetForm.peBkg.Path,GriToBll2[grSimCombo.ItemIndex]+p.x-1);
   OpenLibrary(SetForm.peBkg.Path,GriToBll2[grSimCombo.ItemIndex]);
  end;

  If rb21.Checked then OpenBricks(SetForm.peBrk.Path)
  else OpenBricks(SetForm.peBkg.Path);
 end;
end;

procedure LoadGriToBllTables();
var a, b: Integer;
    temp: TPackEntries;
    p1, p2: TSmallPoint;
    FragIdx, LibIdx, LastFrag, LastLib: Byte;
begin
 If FileExists(SetForm.peBll.Path) then begin
  GriToBll1:= GetRepeatedRefList(SetForm.peBll.Path);
 // for a:= 0 to High(GriToBll1) do
 //  If GriToBll1[a] = -1 then GriToBll1[a]:= a;
  BllToGri1:= GetNormalEntriesList(SetForm.peBll.Path);
 end
 else
  SetLength(GriToBll1, 0);
 If FileExists(SetForm.peBkg.Path) then begin
  p1:= BkgEntriesCount0(SetForm.peBkg.Path, weGrids);
  p2:= BkgEntriesCount0(SetForm.peBkg.Path, weFrags);
  SetLength(GriToBll2, p2.y - p1.x);
  temp:= OpenPack(SetForm.peBkg.Path, p1.x, p1.y - 1);
  UnpackAll(temp);
  for a:= 0 to High(temp) do begin
   LibIdx:=  Byte(temp[a].Data[1]);
   FragIdx:= Byte(temp[a].Data[2]);
   GriToBll2[a]:= LibIdx + p2.y;
   If (a > 0) and (FragIdx <> LastFrag) then begin
    for b:= 0 to FragIdx - LastFrag - 1 do
     GriToBll2[LastFrag + p2.x - p1.x + b]:= LastLib + p2.y;
   end;
   LastLib:=  LibIdx;
   LastFrag:= FragIdx;
  end;
 end;
end;

end.
