unit Building;

interface

uses Windows, Projects, Editing, DePack, SysUtils, Libraries, ProgBar;

var
  PBricks: TPackEntries;
  PLibs: TPackEntries;
  PGrids: TPackEntries;
  PScenes: TPackEntries;

  TBricks: TPackEntries;   // temporary bricks
  TScenario: TPackEntries; // temporary scenario
  TLibData: String;        // temporary library data
  TempLib: TLibrary;       // temporary library
  TempComp: TPackEntry;    // temporary compressed pack

  RepCount: Integer;
  BlankCount: Integer;
  Comp1Count: Integer;
  Comp2Count: Integer;


Procedure BuildProject();

implementation

uses Main, Settings;

Function CheckFiles(): Boolean;
var a: Integer;
begin
 Result:= True;
 //do zrobienia: zmodyfikowa to eby dziaao zalenie od typu projektu (LBA 1 czy 2)
 for a:= 0 to High(TheList) do
  If not CheckExistingLine(a) then Result:= False;
 If not Result then
  MessageBox(Form1.Handle,'Some of the reqiured files the list don''t exist, have invalid extensions, or invalid paths. Compilation cannot be performed unless all the files are valid.'#13#13
                        + 'Invalid cells have been marked in red.','Little Stage Designer',MB_ICONWARNING+MB_OK);
end;

Function LoadFileToString(path: String; var data: String): Boolean;
var f: File;
begin
 Result:= False;
 AssignFile(f, path);
 FileMode:= fmOpenRead;
 Reset(f, 1);
 try
  SetLength(data, FileSize(f));
  BlockRead(f, data[1], FileSize(f));
  Result:= True;
 finally
  CloseFile(f);
 end;
end;

Function ScenarioIsLba1(sc: TPackEntries): Boolean;
begin
 UnpackSelf(sc[0]);
 Result:= Byte(sc[0].Data[1]) = 1;
end;

//Checks if there is already an entry in Pack identical to the data
//All pack entries must be uncompressed!
Function FindMatchingEntry(Pack: TPackEntries; data: String): Integer;
var a: Integer;
begin
 for a:= 0 to High(Pack) do
  if AnsiSameStr(Pack[a].Data,data) then begin
   Result:= a;
   Exit;
  end;
 Result:= -1; //not found  
end;

//Adds a TPackEntry trying to add it as a repeated entry (if option checked)
Procedure AddEntry(var Pack: TPackEntries; data: String);
var a: Integer;
begin
 If ProjectOptions.Optimizations.UseRepeated then a:= FindMatchingEntry(Pack, data)
                                             else a:= -1;
 SetLength(Pack, Length(Pack) + 1);
 Pack[High(Pack)]:= PackEntry(data,a);
 If a > -1 then Inc(RepCount);
end;

Procedure AddBlankEntry(var Pack: TPackEntries);
begin
 SetLength(Pack, Length(Pack) + 1);
 Pack[High(Pack)]:= PackEntry('',-2);
 Inc(BlankCount);
end;

//Compresses the entry according to the options set
// Entry must not be comressed!
procedure CompressEntry(var Entry: TPackEntry);
begin
 If ProjectOptions.Compression.Lba1 = 1 then begin
  Entry:= PackEntry(Entry.Data,-1,1);
  Inc(Comp1Count);
 end
 else if ProjectOptions.Compression.Lba1 = 3 then begin
  TempComp:= PackEntry(Entry.Data,-1,1);
  If TempComp.CpSize > 0 then begin   //just in case
   If ((ProjectOptions.Compression.MinSizeBenUnit = 0) // %
       and ((1 - (TempComp.CpSize / TempComp.RlSize)) * 100 >=
            ProjectOptions.Compression.MinSizeBenVal))
   or ((ProjectOptions.Compression.MinSizeBenUnit = 1) // kB
       and (Integer(TempComp.RlSize - TempComp.CpSize) >=
            ProjectOptions.Compression.MinSizeBenVal * 1024)) then begin
    Entry:= TempComp;
    Inc(Comp1Count);
   end; 
  end;  
 end;
end;

Procedure BuildError(Index: Integer; Line: Integer = -1; path: String = '');
var s: String;
begin
 case Index of
   1: s:= 'File not found or invalid path!'#13#13'The path is: ' + path;
   2: s:= 'Cannot access file for reading!'#13#13'The file is: ' + path;
   3: s:= 'Output Grid HQR file path is empty!';
   4: s:= 'Output Library HQR file path is empty!';
   5: s:= 'Output Brick HQR file path is empty!';
   6: s:= 'Output Scene HQR file path is empty!';
  10: s:= 'Grid file has invalid extension!'#13#13'Valid Grid extensions are .gr1 and .hqs.';
  11: s:= 'Library file has invalid extension!'#13#13'Valid Library extensions are .bl1 and .hqs.';
  12: s:= 'Brick file has invalid extension!'#13#13'Valid Brick extensions are .hqr and .hqs.';
  13: s:= 'Scene file has invalid extension!'#13#13'Valid Scene extensions are .ls1 and .hqs.';
  20: s:= 'Scenario file does not contain any Grid!'#13#13'The Scenario path is: ' + path;
  21: s:= 'Scenario file does not contain any Library!'#13#13'The Scenario path is: ' + path;
  22: s:= 'Scenario file contains no Bricks!'#13#13'The Scenario path is: ' + path;
  23: s:= 'Scenario file does not contain any Scene!'#13#13'The Scenario path is: ' + path;
  30: s:= 'Scenario file is not of LBA 1 type!'#13#13'The Scneario path is: ' + path;
  31: s:= 'Scenario file is not of LBA 2 type!'#13#13'The Scneario path is: ' + path;
  40: s:= 'Library is not consistent with the Bricks!'#13'(Library references non-existing Bricks)';
  50: s:= 'Error during writing to the Grid HQR file!'#13#13'File path is: ' + path;
  51: s:= 'Error during writing to the Library HQR file!'#13#13'File path is: ' + path;
  52: s:= 'Error during writing to the Brick HQR file!'#13#13'File path is: ' + path;
  53: s:= 'Error during writing to the Scene HQR file!'#13#13'File path is: ' + path;
  60: s:= 'There are no rows defined!';
  else s:= 'Unknown error';
 end;
 If Line > -1 then s:= 'Error at row ' + IntToStr(Line+1) + #13#13 + s;
 MessageBox(Form1.Handle,PChar(s),'Build error',MB_ICONERROR+MB_OK);
 ProgBarForm.CloseSpecial;
 Abort;
end;

Procedure BuildProject();
var a, b, c, bh, pbl, bi, bm: Integer;
    data: String;
begin
 SetLength(PBricks, 0);
 SetLength(PLibs, 0);
 SetLength(PGrids, 0);
 SetLength(PScenes, 0);
 SetLength(TBricks, 0);
 SetLength(TScenario, 0);

 RepCount:= 0;
 BlankCount:= 0;
 Comp1Count:= 0;
 Comp2Count:= 0;

 If CheckFiles() then begin
  If Length(TheList) <= 0 then BuildError(6);
  If (ProjectOptions.Output.Lba1OutputGrid
   and (ProjectOptions.Output.Lba1GridPath = '')) then BuildError(3);
  If ProjectOptions.Output.Lba1OutputLibBrk then begin
   if ProjectOptions.Output.Lba1LibraryPath = '' then BuildError(4);
   if ProjectOptions.Output.Lba1BrickPath = ''then BuildError(5);
  end;
  If (ProjectOptions.Output.OutputScene
   and (ProjectOptions.Output.ScenePath = '')) then BuildError(6);


  a:= Length(TheList);
  //SetLength(PLibs, a);
  //SetLength(PGrids, a);
  //SetLength(PScenes, a);

  //Grids
  If ProjectOptions.Output.Lba1OutputGrid then begin
   ProgBarForm.ShowSpecialBar('Building Grids...',Form1,False,0,High(TheList));
   for a:= 0 to High(TheList) do begin
    If AnsiSameText(TheList[a].GridPath,'<B>') then
     AddBlankEntry(PGrids)
    else begin
     If FileExists(TheList[a].GridPath) then begin
      If ExtIs(TheList[a].GridPath,'.gr1') then begin
       If LoadFileToString(TheList[a].GridPath, data) then
        AddEntry(PGrids,data) //PGrids[a]:= PackEntry(data)
       else BuildError(2,a,TheList[a].GridPath);
      end
      else if ExtIs(TheList[a].GridPath,'.hqs') then begin
       If OpenPack(TheList[a].GridPath, TScenario) then
        If ScenarioIsLba1(TScenario) then
         If (TScenario[3].FType = -1) then
          AddEntry(PGrids,UnpackToString(TScenario[3])) //PGrids[a]:= PackEntry(UnpackToString(TScenario[3]))
         else BuildError(20,a,TheList[a].GridPath)
        else BuildError(30,a,TheList[a].GridPath)
       else BuildError(2,a,TheList[a].GridPath);
      end
      else BuildError(10,a);
     end
     else BuildError(1,a,TheList[a].GridPath);
    end;
    ProgBarForm.UpdateBar(a);
   end;
   ProgBarForm.CloseSpecial;
  end;

  //Libraries and Bricks
  If ProjectOptions.Output.Lba1OutputLibBrk then begin
   ProgBarForm.ShowSpecialBar('Building Libraries and Bricks...',Form1,False,0,High(TheList));
   for a:= 0 to High(TheList) do begin

    If AnsiSameText(TheList[a].LibPath,'<B>') then
     AddBlankEntry(PLibs)
    else begin
     //Library
     If FileExists(TheList[a].LibPath) then begin
      If ExtIs(TheList[a].LibPath,'.bl1') then begin
       If not LoadFileToString(TheList[a].LibPath, TLibData) then
        BuildError(2,a,TheList[a].LibPath);
      end
      else if ExtIs(TheList[a].LibPath,'.hqs') then begin
       If OpenPack(TheList[a].LibPath, TScenario) then
        If ScenarioIsLba1(TScenario) then
         If (TScenario[2].FType = -1) then
          TLibData:= UnpackToString(TScenario[2])
         else BuildError(21,a,TheList[a].LibPath)
        else BuildError(30,a,TheList[a].LibPath)
       else BuildError(2,a,TheList[a].LibPath);
      end
      else BuildError(11,a);
     end
     else BuildError(1,a,TheList[a].LibPath);

     //Bricks
     If FileExists(TheList[a].BrickPath) then begin
      If ExtIs(TheList[a].BrickPath,'.hqr') then b:= -1
      else if ExtIs(TheList[a].BrickPath,'.hqs') then b:= 20
      else BuildError(12,a);
      If OpenPack(TheList[a].BrickPath, TBricks, b, -1) then begin
       If ExtIs(TheList[a].BrickPath,'.hqs') then begin
        SetLength(TScenario,1);
        TScenario[0]:= OpenSingleEntry(TheList[a].BrickPath,0);
        If not ScenarioIsLba1(TScenario) then BuildError(30,a,TheList[a].BrickPath);
        If Length(TBricks) < 1 then BuildError(22,a,TheList[a].BrickPath);
       end;
      end
      else BuildError(2,a,TheList[a].BrickPath);
     end
     else BuildError(1,a,TheList[a].BrickPath);

     //Matching Lib and Brk (copying used Brk from TBricks to PBricks)
     TempLib:= LoadLibraryFromString2(TLibData);
     bh:= High(TBricks);
     pbl:= Length(PBricks);
     for b:= 0 to High(TempLib) do begin
      for c:= 0 to High(TempLib[b].Map) do begin
       bi:= TempLib[b].Map[c].Index - 1; //Brick indexes in Layouts start with 1 !
       if (bi >= 0) and (bi <= bh) then begin
        bm:= -1;
        UnpackSelf(TBricks[bi]);
        if ProjectOptions.Optimizations.BricksRemoveDoubled then
         bm:= FindMatchingEntry(PBricks, TBricks[bi].Data);
        if bm < 0 then begin //bm = -1
         bm:= Length(PBricks); //pbl;
         //Inc(pbl);
         //SetLength(PBricks, pbl);
         if ProjectOptions.Optimizations.BricksRemoveDoubled then begin
          SetLength(PBricks, Length(PBricks) + 1);
          PBricks[High(PBricks)]:= PackEntry(TBricks[bi].Data);
         end
         else
          AddEntry(PBricks, TBricks[bi].Data); //PBricks[bm]:= PackEntry(TBricks[bi].Data);
        end;
        TempLib[b].Map[c].Index:= bm + 1;
       end
       else if (bi > bh) then
        BuildError(40,a);
      end;
     end;
     AddEntry(PLibs, LibraryToString(TempLib)); //PLibs[a]:= PackEntry(LibraryToString(TempLib));
    end;


    ProgBarForm.UpdateBar(a);
   end;
   ProgBarForm.CloseSpecial;
  end;

  //Scenes
  If ProjectOptions.Output.OutputScene then begin
   ProgBarForm.ShowSpecialBar('Building Scenes...',Form1,False,0,High(TheList));
   for a:= 0 to High(TheList) do begin
    If AnsiSameText(TheList[a].ScenePath,'<B>') then
     AddBlankEntry(PScenes)
    else begin
     If FileExists(TheList[a].ScenePath) then begin
      If ExtIs(TheList[a].ScenePath,'.ls1') then begin
       If LoadFileToString(TheList[a].ScenePath, data) then
        AddEntry(PScenes, data) //PScenes[a]:= PackEntry(data)
       else BuildError(2,a,TheList[a].ScenePath);
      end
      else if ExtIs(TheList[a].ScenePath,'.hqs') then begin
       If OpenPack(TheList[a].ScenePath, TScenario) then
        If ScenarioIsLba1(TScenario) then
         If (TScenario[8].FType = -1) then
          AddEntry(PScenes, UnpackToString(TScenario[8])) //PScenes[a]:= PackEntry(UnpackToString(TScenario[8]))
         else BuildError(23,a,TheList[a].ScenePath)
        else BuildError(30,a,TheList[a].ScenePath)
       else BuildError(2,a,TheList[a].ScenePath);
      end
      else BuildError(13,a);
     end
     else BuildError(1,a,TheList[a].ScenePath);
    end; 
    ProgBarForm.UpdateBar(a);
   end;
   ProgBarForm.CloseSpecial;
  end;

  c:= Length(PGrids) + Length(PLibs) + Length(PBricks) + Length(PScenes);

  //Compressing
  If ProjectOptions.Compression.Lba1 > 0 then begin
   ProgBarForm.ShowSpecialBar('Compressing entries...',Form1,False,0, c - 1);
   for a:= 0 to High(PGrids) do begin
    If PGrids[a].FType = -1 then CompressEntry(PGrids[a]);
    ProgBarForm.UpdateBar(a);
   end;
   b:= Length(PGrids);
   for a:= 0 to High(PLibs) do begin
    If PLibs[a].FType = -1 then CompressEntry(PLibs[a]);
    ProgBarForm.UpdateBar(b + a);
   end;
   Inc(b, Length(PLibs));
   for a:= 0 to High(PBricks) do begin
    If PBricks[a].FType = -1 then CompressEntry(PBricks[a]);
    ProgBarForm.UpdateBar(b + a);
   end;
   Inc(b, Length(PBricks));
   for a:= 0 to High(PScenes) do begin
    If PScenes[a].FType = -1 then CompressEntry(PScenes[a]);
    ProgBarForm.UpdateBar(b + a);
   end;
   ProgBarForm.CloseSpecial;
  end;

  //Saving everything
  If ProjectOptions.Output.Lba1OutputGrid then begin
   try
    SavePackToFile(PGrids,ProjectOptions.Output.Lba1GridPath);
   except
    BuildError(50,-1,ProjectOptions.Output.Lba1GridPath);
   end;
  end;

  If ProjectOptions.Output.Lba1OutputLibBrk then begin
   try
    SavePackToFile(PLibs,ProjectOptions.Output.Lba1LibraryPath);
   except
    BuildError(51,-1,ProjectOptions.Output.Lba1LibraryPath);
   end;
   try
    SavePackToFile(PBricks,ProjectOptions.Output.Lba1BrickPath);
   except
    BuildError(52,-1,ProjectOptions.Output.Lba1BrickPath);
   end;
  end;

  If ProjectOptions.Output.OutputScene then begin
   try
    SavePackToFile(PScenes,ProjectOptions.Output.ScenePath);
   except
    BuildError(53,-1,ProjectOptions.Output.ScenePath);
   end;
  end;

  If MainSettings.BuildSummary then
   MessageBox(Form1.Handle,PChar(
    Format('Project built successfully!'#13#13
         + 'Processed lines: %d'#13#13
         + 'Total Bricks: %d'#13#13
         + 'Total entries: %d'#13
         + 'Blank entries: %d'#13
         + 'Repeated entries: %d'#13#13
         + 'Entries with no compression: %d'#13
         + 'Entries with compression 1: %d'#13
         + 'Entries with compression 2: %d',
     [Length(TheList), Length(PBricks), c,
      BlankCount, RepCount, c - Comp1Count - Comp2Count, Comp1Count, Comp2Count])
    ),'Little Stage Designer', MB_ICONINFORMATION + MB_OK);    

 end;
end;

end.
