//******************************************************************************
// Little Big Architect: Factory - editing brick and layout files from
//                                 Little Big Adventure 1 & 2
//
// Main unit.
// Main program unit. Contains main form's events.
//
// Copyright Zink
// e-mail: zink@poczta.onet.pl
// See the GNU General Public License (License.txt) for details.
//******************************************************************************

unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Spin, IniFiles, StrUtils, Engine, DePack,
  ComCtrls, Buttons, ImgList, Menus, ActnList, Math, filectrl, Libraries,
  Scenario;

type
  TForm1 = class(TForm)
    paMain: TPanel;
    Label3: TLabel;
    Label14: TLabel;
    PageControl: TPageControl;
    BrkTab: TTabSheet;
    Label5: TLabel;
    Bevel2: TBevel;
    pbBrick: TPaintBox;
    sbBricks: TScrollBar;
    LibTab: TTabSheet;
    Label1: TLabel;
    Bevel1: TBevel;
    pbLayout: TPaintBox;
    Button1: TButton;
    sbLayouts: TScrollBar;
    Edit2: TEdit;
    DlgOpen: TOpenDialog;
    DlgSave: TSaveDialog;
    pmBricks: TPopupMenu;
    mEditBrk: TMenuItem;
    N1: TMenuItem;
    mExportBrk: TMenuItem;
    mExportBrkBit: TMenuItem;
    N12: TMenuItem;
    mImportBrk: TMenuItem;
    N2: TMenuItem;
    mInsBefore: TMenuItem;
    mInsAfter: TMenuItem;
    N4: TMenuItem;
    mMoveForw: TMenuItem;
    mMoveBack: TMenuItem;
    N3: TMenuItem;
    mDelete: TMenuItem;
    N5: TMenuItem;
    mLockBrick: TMenuItem;
    pmLayouts: TPopupMenu;
    mLtEditStr: TMenuItem;
    mLtEditImg: TMenuItem;
    N6: TMenuItem;
    mExportLay: TMenuItem;
    mExportLayBit: TMenuItem;
    N7: TMenuItem;
    mNewLt: TMenuItem;
    mCopyLt: TMenuItem;
    mDeleteLt: TMenuItem;
    N8: TMenuItem;
    mLockLib: TMenuItem;
    MainMenu1: TMainMenu;
    mFile: TMenuItem;
    mOpenBrk: TMenuItem;
    mSaveBrk: TMenuItem;
    mSaveBrkAs: TMenuItem;
    N10: TMenuItem;
    mOpenLib: TMenuItem;
    mSaveLib: TMenuItem;
    mSaveLibAs: TMenuItem;
    N11: TMenuItem;
    mSaveBoth: TMenuItem;
    mSaveBothAs: TMenuItem;
    N13: TMenuItem;
    mExit: TMenuItem;
    View1: TMenuItem;
    mFrames: TMenuItem;
    mIndexes: TMenuItem;
    mShapes: TMenuItem;
    Palette1: TMenuItem;
    mLba1: TMenuItem;
    mLba2: TMenuItem;
    N9: TMenuItem;
    mAutoPal: TMenuItem;
    paSplash: TPanel;
    Shape1: TShape;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label2: TLabel;
    Label12: TLabel;
    mRemSharing: TMenuItem;
    btSortSize: TSpeedButton;
    btSortIndex: TSpeedButton;
    N14: TMenuItem;
    NewBrick1: TMenuItem;
    mNewBrk: TMenuItem;
    mNewBrkHqr: TMenuItem;
    mNewLib1: TMenuItem;
    mNewBkg: TMenuItem;
    N15: TMenuItem;
    mNewLt1: TMenuItem;
    mNewLt2: TMenuItem;
    N16: TMenuItem;
    mNewLib2: TMenuItem;
    N18: TMenuItem;
    mOpenScen: TMenuItem;
    mExportScen: TMenuItem;
    mScenProp: TMenuItem;
    N17: TMenuItem;
    mChooseEntry: TMenuItem;
    procedure pbLayoutPaint(Sender: TObject);
    procedure mOpenBrkClick(Sender: TObject);
    procedure mFramesClick(Sender: TObject);
    procedure mLba1Click(Sender: TObject);
    procedure mOpenLibClick(Sender: TObject);
    procedure pbBrickPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure sbBricksChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure pbBrickMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure mEditBrkClick(Sender: TObject);
    procedure mExportBrkBitClick(Sender: TObject);
    procedure mInsBeforeClick(Sender: TObject);
    procedure mMoveForwClick(Sender: TObject);
    procedure mDeleteClick(Sender: TObject);
    procedure mLockBrickClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button1Click(Sender: TObject);
    procedure sbLayoutsChange(Sender: TObject);
    procedure pbLayoutMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure mLtEditImgClick(Sender: TObject);
    procedure Edit2KeyPress(Sender: TObject; var Key: Char);
    procedure mLtEditStrClick(Sender: TObject);
    procedure mSaveBrkClick(Sender: TObject);
    procedure PageControlDrawTab(Control: TCustomTabControl;
      TabIndex: Integer; const Rect: TRect; Active: Boolean);
    procedure mSaveLibClick(Sender: TObject);
    procedure mSaveBothClick(Sender: TObject);
    procedure mSaveBothAsClick(Sender: TObject);
    procedure mImportBrkClick(Sender: TObject);
    procedure mExportLayBitClick(Sender: TObject);
    procedure mExportLayClick(Sender: TObject);
    procedure mExitClick(Sender: TObject);
    procedure mLockLibClick(Sender: TObject);
    procedure mNewLtClick(Sender: TObject);
    procedure mCopyLtClick(Sender: TObject);
    procedure mDeleteLtClick(Sender: TObject);
    procedure PageControlChange(Sender: TObject);
    procedure mRemSharingClick(Sender: TObject);
    procedure btSortSizeClick(Sender: TObject);
    procedure mExportBrkClick(Sender: TObject);
    procedure mNewClick(Sender: TObject);
    procedure pmBricksPopup(Sender: TObject);
    procedure mFileClick(Sender: TObject);
    procedure pmLayoutsPopup(Sender: TObject);
    procedure mOpenScenClick(Sender: TObject);
    procedure mExportScenClick(Sender: TObject);
    procedure mScenPropClick(Sender: TObject);
    procedure mChooseEntryClick(Sender: TObject);
  private
    { Private declarations }
  public

  end;

var
  Form1: TForm1;

  bufLayout, bufBrick: TBitmap;

procedure EnableSaveMenu;
Procedure CheckSaved(Bricks, Layouts: Boolean);
Procedure OpenParam;
procedure SetTabCaptions;

implementation

uses ProgBar, Bricks, Layouts, Editor, OptPanel, StructEd, DimDialog,
  ScenProp;

{$R *.dfm}

procedure EnableSaveMenu;
begin
 Form1.mSaveBoth.Enabled:= SameText(BrkPath,LibPath) and IsBkg(BrkPath);
 Form1.mSaveBothAs.Enabled:= Form1.mSaveBoth.Enabled;
 Form1.mSaveBrk.Enabled:= not Form1.mSaveBoth.Enabled and (BrkCount>0);
 Form1.mSaveBrkAs.Enabled:= Form1.mSaveBrk.Enabled;
 Form1.mSaveLib.Enabled:= not Form1.mSaveBoth.Enabled and (Length(Lib)>0);
 Form1.mSaveLibAs.Enabled:= Form1.mSaveLib.Enabled;
 Form1.mExportScen.Enabled:= BricksOpened and not SingleBrick
                         and (Length(Lib) > 0) and not SingleLayout;
 Form1.mScenProp.Enabled:= Form1.mExportScen.Enabled;
end;

function Smaller(v1, v2: Integer): Integer;
begin
 If v1<v2 then Result:=v1 else Result:=v2;
end;

procedure TForm1.pbLayoutPaint(Sender: TObject);
begin
 UpdateImage(bufLayout,pbLayout);
end;

procedure TForm1.mFramesClick(Sender: TObject);
begin
 PaintBricks;
 PaintLayouts;
end;

procedure TForm1.mLba1Click(Sender: TObject);
begin
 ChangePalette(mLba1.Checked);
end;

procedure TForm1.mOpenBrkClick(Sender: TObject);
begin
 With DlgOpen do begin
  Title:= 'Open Bricks';
  FileName:= '';
  Filter:= 'Bricks (*.brk, lba_brk.hqr, lba_bkg.hqr)|*.brk;*lba_brk*.hqr;*lba_bkg*.hqr|';
  InitialDir:= LastHqrPath;
  If Execute then begin
   LastHqrPath:= ExtractFilePath(FileName);
   OpenBricks(FileName);
  end;
 end;
end;

procedure TForm1.mSaveBrkClick(Sender: TObject);
var ext: String;
begin
 If BrkCount < 1 then Exit;
 If ((Sender as TMenuItem).Name = 'mSaveBrk') and (BrkPath <> '') then
  SaveBricks(BrkPath)
 else with DlgSave do begin
  If SingleBrick then Filter:= 'LBA Brick files (*.brk)|*.brk'
  else Filter:= 'High Quality Resources (*.hqr)|*.hqr';
  FilterIndex:= 1;
  FileName:= ExtractFileName(BrkPath);
  InitialDir:= LastHqrPath;
  If Execute then begin
   FileName:= ChangeFileExt(FileName,IfThen(FilterIndex=1,'.brk','.hqr'));
   LastHqrPath:= ExtractFilePath(FileName);
   SaveBricks(FileName);
  end;
 end; 
end;

procedure TForm1.mOpenLibClick(Sender: TObject);
begin
 DlgOpen.Title:= 'Open Layout or Library';
 DlgOpen.FileName:= '';
 DlgOpen.Filter:= 'All supported (lt*, bl*, lba_bll, lba_bkg)|*.lt1;*.lt2;*.bl1;*.bl2;*lba_bll*.hqr;*lba_bkg*.hqr'
               + '|Layouts (*.lt1, *.lt2)|*.lt1;*.lt2'
               + '|Libraries (*.bl1, *.bl2, lba_bll.hqr, lba_bkg.hqr)|*.bl1;*.bl2;*lba_bll*.hqr;*lba_bkg*.hqr';
 DlgOpen.InitialDir:= LastHqrPath;
 If DlgOpen.Execute then begin
  LastHqrPath:= ExtractFilePath(DlgOpen.FileName);
  LoadLibrary(DlgOpen.FileName);
 end;
end;

procedure TForm1.mSaveLibClick(Sender: TObject);
begin
 If Length(Lib)<1 then Exit;
 If ((Sender as TMenuItem).Name='mSaveLib') and (LibPath<>'') then
  SaveLayouts(LibPath,LibIndex)
 else with DlgSave do begin
  DefaultExt:='';
  FileName:=ExtractFileName(LibPath);
  If SingleLayout then
   Filter:=IfThen(LLba1,'LBA 1 Layouts (*.lt1)|*.lt1','LBA 2 Layouts (*.lt2)|*.lt2')
  else begin
   Filter:=IfThen(LLba1,'LBA 1 Layout Libraries (*.bl1)|*.bl1','LBA 2 Layout Libraries (*.bl2)|*.bl2');
   FileName:=ChangeFileExt(FileName,IfThen(LLBa1,'.bl1','.bl2'));
  end;
  FilterIndex:=1;
  InitialDir:=LibPath;
  If Execute then begin
   LibPath:=ExtractFilePath(FileName);
   FileName:=ChangeFileExt(FileName,IfThen(SingleLayout,IfThen(LLBa1,'.lt1','.lt2'),IfThen(LLBa1,'.bl1','.bl2')));
   SaveLayouts(FileName,-1);
  end;
 end;
end;

procedure TForm1.mOpenScenClick(Sender: TObject);
begin
 With DlgOpen do begin
  Title:= 'Open Scenario';
  FileName:= '';
  Filter:= 'High Quality Scenarios (*.hqs)|*.hqs';
  InitialDir:= LastScenPath;
  If Execute then begin
   LastScenPath:= ExtractFilePath(FileName);
   OpenScenario(FileName);
  end;
 end;
end;

procedure TForm1.mExportScenClick(Sender: TObject);
begin
 If (Length(Lib) < 1) or (BrkCount < 1) then Exit;
 With DlgSave do begin
  Title:= 'Export to a Scenario...';
  Filter:= 'High Quality Scenario (*.hqs)|*.hqs';
  DefaultExt:= 'hqs';
  FilterIndex:= 1;
  FileName:= ExtractFileName(ScenPath);
  InitialDir:= LastScenPath;
  If Execute then begin
   LastScenPath:= ExtractFilePath(FileName);
   SaveScenario(FileName);
  end;
 end;
end;

procedure TForm1.mSaveBothClick(Sender: TObject);
begin
 SaveBoth(BrkPath,LibIndex);
end;

procedure TForm1.mSaveBothAsClick(Sender: TObject);
begin
 If (Length(Lib)<1) or (BrkCount<1) then Exit;
 With DlgSave do begin
  Filter:= 'LBA 2 Background (lba_bkg.hqr)|*lba_bkg*.hqr';
  DefaultExt:= 'hqr';
  FilterIndex:= 1;
  FileName:= ExtractFileName(BrkPath);
  InitialDir:= LastHqrPath;
  If Execute then begin
   LastHqrPath:= ExtractFilePath(FileName);
   SaveBoth(FileName,LibIndex);
  end;
 end;
end;

procedure TForm1.pbBrickPaint(Sender: TObject);
begin
 UpdateImage(bufBrick,pbBrick);
end;

procedure OpenParam;
var a: Integer;
    ext, name: String;
begin
 for a:= 1 to Smaller(ParamCount,2) do
  If FileExists(ParamStr(a)) then begin
   name:= LowerCase(ExtractFileName(ParamStr(a)));
   ext:= ExtractFileExt(name);
   If (ext = '.brk') or ((ext = '.hqr') and (IsBkg(name)
   or AnsiContainsText(name,'lba_brk'))) then
    OpenBricks(ParamStr(a))
   else if (ext = '.bl1') or (ext = '.bl2') or (ext = '.lt1') or (ext = '.lt2')
   or ((ext = '.hqr') and (IsBkg(name) or AnsiContainsText(name,'lba_bll'))) then
    LoadLibrary(ParamStr(a))
   else if (ext = '.hqs') and (a = 1) then begin
    OpenScenario(ParamStr(1));
    Exit;
   end
   else begin
    MessageBox(Form1.Handle,'Invalid parameter(s)','Little Big Factory',MB_ICONERROR+MB_OK);
    Exit;
   end; 
  end;
end;

procedure TForm1.FormResize(Sender: TObject);
var temp: Integer;
begin
 SetTabCaptions;
 SetDimensions(bufBrick,pbBrick.Width,pbBrick.Height);
 SetDimensions(bufLayout,pbLayout.Width,pbLayout.Height);
 temp:=sbBricks.Position*BrkPerRow;
 //If {BrkPerRow<>pbBrick.Width div 51 then} PageControl.ActivePageIndex=0 then
  PaintBricks;
 //else
 SetScrollBrk;
 MapLayouts;
 CalcPositions;
 SetScrollLt(True);
 PaintLayouts;
 sbBricks.Position:=temp div BrkPerRow;
end;

procedure TForm1.sbBricksChange(Sender: TObject);
begin
 PaintBricks;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 BrkTab.DoubleBuffered:=True;
 LibTab.DoubleBuffered:=True;
 SetDimensions(bufLayout,pbLayout.Width,pbLayout.Height);
end;

procedure TForm1.pbBrickMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var NewSel: Integer;
begin
 If X>BrkPerRow*51-1 then Exit;
 NewSel:=((Y div 41)+sbBricks.Position)*BrkPerRow+(X div 51);
 If NewSel>BrkCount-1 then Exit;
 Bricks.PaintBrick((BrkSelect mod BrkPerRow)*51,((BrkSelect div BrkPerRow)-sbBricks.Position)*41,
  BrkSelect,bufBrick,False,mIndexes.Checked,mFrames.Checked);
 BrkSelect:=NewSel;
 Bricks.PaintBrick((NewSel mod BrkPerRow)*51,((NewSel div BrkPerRow)-sbBricks.Position)*41,
  NewSel,bufBrick,True,mIndexes.Checked,mFrames.Checked);
 UpdateInfo;
 UpdateImage(bufBrick,pbBrick);
end;

procedure TForm1.mEditBrkClick(Sender: TObject);
begin
 If BrkCount >= 1 then
  ShowBrickEditor(BrkSelect);
end;

procedure TForm1.mExportBrkClick(Sender: TObject);
begin
 If BrkCount >= 1 then
  ExportBrick(bitBuffers[BrkSelect]);
end;

procedure TForm1.mImportBrkClick(Sender: TObject);
begin
 {With EditForm.dlOpen do begin
  InitialDir:=LastExportPath;
  If Execute then begin
   LastExportPath:=ExtractFilePath(FileName);
   S:=BitBrickToBrick(Brick);
   AssignFile(f,FileName);
   FileMode:=fmOpenWrite;
   Rewrite(f,1);
   BlockWrite(f,S[1],Length(S));
   CloseFile(f);
   Beep;
  end;
 end; }
end;

procedure TForm1.mExportBrkBitClick(Sender: TObject);
begin
 If BrkCount < 1 then Exit;
 With DlgSave do begin
  DefaultExt:='bmp';
  Filter:='Bitmaps (*.bmp)|*.bmp';
  FilterIndex:=1;
  InitialDir:=LastExportPath;
  If Execute then begin
   LastExportPath:=ExtractFilePath(FileName);
   Buffer.Width:=48;
   Buffer.Height:=38;
   Buffer.Canvas.Brush.Color:=clWhite;
   Buffer.Canvas.FillRect(Rect(0,0,48,38));
   DrawBitBrick(bitBuffers[BrkSelect],0,0,Buffer);
   Buffer.SaveToFile(FileName);
  end;
 end;
end;

procedure TForm1.mExportLayClick(Sender: TObject);
begin
 If Length(Lib)<1 then Exit;
 ExportLayout(Lib[LtSelect]);
end;

procedure TForm1.mExportLayBitClick(Sender: TObject);
begin
 If Length(Lib) < 1 then Exit;
 With DlgSave do begin
  DefaultExt:= 'bmp';
  Filter:= 'Bitmaps (*.bmp)|*.bmp';
  FilterIndex:= 1;
  InitialDir:= LastExportPath;
  If Execute then begin
   LastExportPath:= ExtractFilePath(FileName);
   Buffer.Width:= GetLtWidth(Lib[LtSelect]);
   Buffer.Height:= GetLtHeight(Lib[LtSelect]);
   Buffer.Canvas.Brush.Color:= clWhite;
   DrawLayout(0,0,LtSelect,Buffer,mFrames.Checked,false);
   Buffer.SaveToFile(FileName);
  end;
 end;
end;

procedure TForm1.mInsBeforeClick(Sender: TObject);
var a: Integer;
begin
 If ((Sender as TMenuItem).Name='mInsAfter') and (Length(VBricks)>0) then Inc(BrkSelect);
 SetLength(VBricks,Length(VBricks)+1);
 Inc(BrkCount);
 Screen.Cursor:=crHourGlass;
 for a:=High(VBricks)-1 downto BrkSelect+BrkOffset do
  VBricks[a+1]:=VBricks[a];
 VBricks[BrkSelect+BrkOffset]:=PackEntry(#01#01#23#18#01#00);
 SetLength(Buffered,BrkCount);
 SetLength(bitBuffers,BrkCount);
 for a:=0 to High(Buffered) do Buffered[a]:=False;
 Allocated:=0;
 UpdateInfo;
 SetScrollBrk;
 EnableSaveMenu;
 Form1.LibTab.TabVisible:= (Length(Lib)>0) and (BrkCount>0);
 PaintBricks;
 PaintLayouts;
 Screen.Cursor:=crDefault;
end;

procedure TForm1.mMoveForwClick(Sender: TObject);
var temp: TPackEntry;
    a: Integer;
begin
 If BrkCount < 2 then Exit;
 If (Sender as TMenuItem).Name='mMoveForw' then begin
  If BrkSelect >= BrkCount then Exit;
  a:=1;
 end
 else begin
  If BrkSelect <= 0 then Exit;
  a:=-1;
 end;
 temp:=VBricks[BrkSelect+BrkOffset];
 VBricks[BrkSelect+BrkOffset]:=VBricks[BrkSelect+BrkOffset+a];
 VBricks[BrkSelect+BrkOffset+a]:=temp;
 Buffered[BrkSelect]:=False;
 Buffered[BrkSelect+a]:=False;
 Dec(Allocated,2);
 BrkSelect:=BrkSelect+a;
 UpdateInfo;
 PaintBricks;
 PaintLayouts;
end;

procedure TForm1.mDeleteClick(Sender: TObject);
var a: Integer;
begin
 If BrkCount < 1 then Exit;
 Screen.Cursor:=crHourGlass;
 for a:=BrkSelect+BrkOffset to High(VBricks)-1 do
  VBricks[a]:=VBricks[a+1];
 SetLength(VBricks,Length(VBricks)-1);
 Dec(BrkCount);
 SetLength(Buffered,BrkCount);
 SetLength(bitBuffers,BrkCount);
 for a:=0 to High(Buffered) do Buffered[a]:=False;
 Allocated:=0;
 If BrkSelect>BrkCount-1 then BrkSelect:=BrkCount-1;
 If BrkSelect < 0 then BrkSelect:= 0;
 UpdateInfo;
 If BrkCount=0 then Form1.LibTab.TabVisible:=False;
 SetScrollBrk;
 PaintBricks;
 PaintLayouts;
 Screen.Cursor:=crDefault;
end;

procedure TForm1.mLockBrickClick(Sender: TObject);
begin
 If Assigned(Sender) and not mLockBrick.Checked
 and (MessageBox(Handle,'Modifying structure of Bricks can mess all Layouts and Grids up.'#13'Especially when you delete or insert a Brick. All Bricks that are after it move, thus their indexes change. '+
 'Since Layouts refer to Bricks by their indexes, the ones that use Bricks after the deleted/inserted one will be messed up.'#13#13'Are you aware of that?','Little Big Factory',MB_ICONWARNING+MB_YESNO)=ID_NO) then
  mLockBrick.Checked:=True
 else begin
  mInsBefore.Enabled:=not mLockBrick.Checked;
  mInsAfter.Enabled:=not mLockBrick.Checked;
  mMoveForw.Enabled:=not mLockBrick.Checked;
  mMoveBack.Enabled:=not mLockBrick.Checked;
  mDelete.Enabled:=not mLockBrick.Checked;
 end;
end;

Procedure CheckSaved(Bricks, Layouts: Boolean);
begin
 If Bricks and Layouts and Form1.mSaveBoth.Enabled
 and (BricksModified or LayoutsModified) then
  Case MessageBox(Form1.Handle,'Some Bricks and/or Layouts have been modified. Save the whole BKG file?','Little Big Factory',MB_ICONQUESTION+MB_YESNOCANCEL) of
   ID_YES: Form1.mSaveBothClick(Form1);
   ID_CANCEL: Abort;
  end
 else begin
  If Bricks and BricksModified then
   Case MessageBox(Form1.Handle,'Some Bricks have been modified. Save the whole Hqr file?','Little Big Factory',MB_ICONQUESTION+MB_YESNOCANCEL) of
    ID_YES: If Form1.mSaveBrk.Enabled then Form1.mSaveBrkClick(Form1.mSaveBrk)
            else Form1.mSaveBothClick(Form1);
    ID_CANCEL: Abort;
   end;
  If Layouts and LayoutsModified then
   Case MessageBox(Form1.Handle,'Some Layouts have been modified. Save the Library?','Little Big Factory',MB_ICONQUESTION+MB_YESNOCANCEL) of
    ID_YES: If Form1.mSaveLib.Enabled then Form1.mSaveLibClick(Form1)
            else Form1.mSaveBothClick(Form1);
    ID_CANCEL: Abort;
   end;
 end;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 CheckSaved(True,True);
end;

{$o-}
procedure TForm1.Button1Click(Sender: TObject);
var a, b, c, d, pX, pY, pZ: integer;
    e: array of Integer;
    jest: boolean;
begin
 Label14.Caption:='';
 SetLength(e,0);
 //for a:=0 to 255 do
 // c[a]:=0;

 pZ:=0;
 for d:=1 to High(Lib) do
  for c:=0 to Lib[d].Z-1 do
   for b:=0 to Lib[d].Y-1 do
    for a:=0 to Lib[d].X-1 do begin
     jest:=false;
     for pX:=0 to High(e) do
      If Lib[d].Map[a,b,c].Index=e[pX] then begin
       jest:=true;
       break;
      end;
     If not jest and (Lib[d].Map[a,b,c].Index>0) then begin
      Inc(pZ,VBricks[Lib[d].Map[a,b,c].Index+BrkOffset].RlSize);
      SetLength(e,Length(e)+1);
      e[High(e)]:=Lib[d].Map[a,b,c].Index;
     end;
   end;

  Label14.Caption:=IntToStr(pZ);
 //for a:=1 to High(Lib) do
 // for b:=0 to High(Lib[a].Map) do
 //  Inc(c[Lib[a].Map[b].Sound]);

 //for a:=0 to High(e) do
  //If e[a]>0 then Memo1.Lines.Add(IntToStr(a))
  //else Memo1.Lines.Add('-----------------');

 //for a:=0 to 255 do
 // If c[a]>0 then Label14.Caption:=Label14.Caption+IntToHex(a,2)+': '+IntToStr(c[a])+#13;

 //Label14.Hint:=Label14.Caption;

 {for a:=1 to High(LLibrary) do
  for b:=0 to High(LLibrary[a].Map) do
   If LLibrary[a].Map[b].Sound=$67 then begin
    Label14.Caption:='Jest!';
   end;}
end;
{$o+}

procedure TForm1.sbLayoutsChange(Sender: TObject);
begin
 PaintLayouts;
end;

procedure TForm1.pbLayoutMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var a, NewSel: Integer;
begin
 If ssDouble in Shift then Exit; 
 NewSel:=-1;
 for a:=0 to High(LtPos) do
  if PointInRect(Bounds(LtPos[a].X,LtPos[a].Y-sbLayouts.Position,LtDim[a].X,LtDim[a].Y),X,Y) then begin
   NewSel:=a;
   Break;
  end;

 If (NewSel<0) or (NewSel>High(Lib)) then Exit;
 PaintLayout(LtPos[LtSelect].X,LtPos[LtSelect].Y-sbLayouts.Position,
  LtSelect,bufLayout,False,mFrames.Checked);
 LtSelect:=NewSel;
 PaintLayout(LtPos[NewSel].X,LtPos[NewSel].Y-sbLayouts.Position,
  NewSel,bufLayout,True,mFrames.Checked);
 UpdateInfo;
 UpdateImage(bufLayout,pbLayout);
end;

procedure TForm1.mLtEditImgClick(Sender: TObject);
begin
 If Length(Lib)<1 then Exit;
 ShowLayoutEditor(LtSelect);
end;

procedure TForm1.Edit2KeyPress(Sender: TObject; var Key: Char);
var a: Integer;
begin
 If (Key=#13) and TryStrToInt(Edit2.Text,a) then begin
  If (a>=1) and (a<=Length(Lib)) then begin
   LtSelect:=a-1;
   sbLayouts.Position:=LtPos[a-1].Y;
   UpdateInfo;
  end;
 end;
end;

procedure TForm1.mLtEditStrClick(Sender: TObject);
begin
 StrForm.ShowStructEditor(LtSelect);
end;

procedure SetTabCaptions;
var wb, wbm, wbt, wl, wlt, ww: Integer;
    sIndex, sBrk, sLib, sB, sL: String;
begin
 If SingleBrick then sB:='Brick' else sB:='Bricks';
 If SingleLayout then sL:='Layout' else sL:='Library';
 With Form1.PageControl do begin
  sIndex:=IfThen(LibIndex>-1,', '+IntToStr(LibIndex+1));
  If BrkPath='' then sBrk:='Unsaved '+sB else sBrk:=BrkPath;
  If LibPath='' then sLib:='Unsaved '+sL else sLib:=LibPath+sIndex;
  If Form1.BrkTab.TabVisible and Form1.LibTab.TabVisible then begin
   wbt:=Canvas.TextWidth(sB+' - ');
   wlt:=Canvas.TextWidth(sL+' - '+sIndex);
   wb:=Canvas.TextWidth(BrkPath)+wbt;
   wbm:=Canvas.TextWidth(MinimizeName(BrkPath,Canvas,0))+wbt;
   wl:=Canvas.TextWidth(LibPath)+wlt;
   ww:=Width-28;

   If wb+wl>ww then begin
    if wl>ww-wbm then begin
     sBrk:=MinimizeName(BrkPath,Canvas,0);
     sLib:=MinimizeName(LibPath,Canvas,ww-wbm-wlt)+sIndex;
    end
    else
     sBrk:=MinimizeName(BrkPath,Canvas,ww-wl-wbt);
   end;
  end;
  Form1.BrkTab.Caption:=sB+' - '+sBrk;
  Form1.LibTab.Caption:=sL+' - '+sLib;
 end;
end;

procedure TForm1.PageControlDrawTab(Control: TCustomTabControl;
  TabIndex: Integer; const Rect: TRect; Active: Boolean);
var TextW, x: Integer;
begin
 Control.Canvas.Brush.Color:=clBtnFace;
 Control.Canvas.FillRect(Rect);
 TextW:=Control.Canvas.TextWidth(PageControl.Pages[TabIndex].Caption);
 x:=(Rect.Left+Rect.Right-TextW) div 2;
 Control.Canvas.TextOut(x,Rect.Top+4,PageControl.Pages[TabIndex].Caption);
 Control.Canvas.Font.Color:=clPurple;
 If TabIndex=0 then
  Control.Canvas.TextOut(x,Rect.Top+4,IfThen(SingleBrick,'Brick - ','Bricks - '))
 else
  Control.Canvas.TextOut(x,Rect.Top+4,IfThen(SingleLayout,'Layout - ','Library - '));
end;

procedure TForm1.mExitClick(Sender: TObject);
begin
 Close;
end;

procedure TForm1.mLockLibClick(Sender: TObject);
var ext: String;
begin
 If Assigned(Sender) and not mLockLib.Checked
 and (MessageBox(Handle,'You are about to enable deleting Layouts and editing their images. Before you do it, please read what these features do, which might be different from what you think they do.'#13#13' Edit image - brings '+
 'Editor window, in which you can edit BRICKS (not Layout itself) that this Layout is made of. For your convenience this feature puts the Bricks together as one Layout for editing, and splits them back after editing is done. Layout itself is NOT modified '+
 'during this operation.'#13#13' Delete - removes selected Layout from the Library, but DOES NOT REMOVE IT''S BRICKS, because some other Layouts may be using them as well. In adddition, deleting a Layout can mess all Grids that use it up. All Layouts that are '+
 'after it will move, thus their indexes will change. Since Grids refer to Layouts by their indexes, all Layouts after the deleted one will have different indexes, which will cause the Grid to put them in worng places.'#13#13'Are you aware of all that things?','Little Big Factory',MB_ICONWARNING+MB_YESNO)=ID_NO) then
  mLockLib.Checked:=True
 else begin
  ext:=LowerCase(ExtractFileExt(LibPath));
  mDeleteLt.Enabled:=not (mLockLib.Checked or SingleLayout);
  mLtEditImg.Enabled:=not mLockLib.Checked;  
 end;
end;

procedure TForm1.mNewLtClick(Sender: TObject);
var temp: TCubeLt;
begin
 If Length(Lib)>=255 then
  MessageBox(Handle,'This Library already has 255 Layouts. It is the maximum number of Layouts that a Library may hold. Delete one of the existing Layouts to be able to create a new one.','Little Big Factory',MB_ICONINFORMATION+MB_OK)
 else begin
  If DimForm.ShowModal<>mrOK then Exit;
  NewLayoutEditor(TryToConvert(DimForm.seX),TryToConvert(DimForm.seY),TryToConvert(DimForm.seZ));
 end;
end;

procedure TForm1.mCopyLtClick(Sender: TObject);
var id, a, b, c, brk: Integer;
begin
 If Length(Lib)>=255 then
  MessageBox(Handle,'This Library already has 255 Layouts. It is the maximum number of Layouts that a Library may hold. Delete one of the existing Layouts to be able to copy one.','Little Big Factory',MB_ICONINFORMATION+MB_OK)
 else begin
  Screen.Cursor:=crHourGlass;
  id:=CreateLayout(Lib[LtSelect].x,Lib[LtSelect].y,Lib[LtSelect].z);
  for c:=0 to Lib[id].z-1 do
   for b:=0 to Lib[id].y-1 do
    for a:=0 to Lib[id].x-1 do
     If (a=Lib[id].x-1) or (b=Lib[id].y-1) or (c=Lib[id].z-1) then begin
      If Lib[LtSelect].Map[a,b,c].Index<=0 then
       VBricks[Lib[id].Map[a,b,c].Index+BrkOffset-1]:=PackEntry(#01#01#23#18#01#00)
      else
       VBricks[Lib[id].Map[a,b,c].Index+BrkOffset-1]:=VBricks[Lib[LtSelect].Map[a,b,c].Index+BrkOffset-1];
     end;
  RefreshLayouts(id);
  Screen.Cursor:=crDefault;
 end;
end;

procedure TForm1.mRemSharingClick(Sender: TObject);
var a, b, c, brk: Integer;
    temp: TCubeLt;
begin
 Screen.Cursor:=crHourGlass;
 temp:=CopyLayout(Lib[LtSelect]);
 CreateLayout(Lib[LtSelect].x,Lib[LtSelect].y,Lib[LtSelect].z,LtSelect);
 for c:=0 to Lib[LtSelect].z-1 do
  for b:=0 to Lib[LtSelect].y-1 do
   for a:=0 to Lib[LtSelect].x-1 do
    If (a=Lib[LtSelect].x-1) or (b=Lib[LtSelect].y-1) or (c=Lib[LtSelect].z-1) then begin
     If Lib[LtSelect].Map[a,b,c].Index<=0 then
      VBricks[Lib[LtSelect].Map[a,b,c].Index+BrkOffset-1]:=PackEntry(#01#01#23#18#01#00)
     else
      VBricks[Lib[LtSelect].Map[a,b,c].Index+BrkOffset-1]:=VBricks[temp.Map[a,b,c].Index+BrkOffset-1];
    end;
 RefreshLayouts(-1);
 Screen.Cursor:=crDefault;
end;

procedure TForm1.mDeleteLtClick(Sender: TObject);
var a, b, c: Integer;
begin
 If Length(Lib)>=1 then begin
  for b:=0 to High(LtMap) do begin
   for c:=0 to High(LtMap[b]) do
    If LtMap[b,c]=LtSelect then Break;
   If LtMap[b,c]=LtSelect then Break;
  end;

  for a:=LtSelect to High(Lib)-1 do
   Lib[a]:=Lib[a+1];
  SetLength(Lib,Length(Lib)-1);
  AnalyzeLayouts;

  If b<=High(LtMap) then begin
   If c<=High(LtMap[b]) then LtSelect:=LtMap[b,c]
   else if Length(LtMap[b])>0 then LtSelect:=LtMap[b,High(LtMap[b])];
  end
  else LtSelect:=LtMap[High(LtMap),High(LtMap[High(LtMap)])];
  SetScrollLt(True);
  UpdateInfo;
  PaintLayouts;
  LayoutsModified:=True;
 end
 else MessageBox(handle,'Library must contain at least one Layout','Little Big Factory',MB_ICONINFORMATION+MB_OK);
end;

procedure TForm1.PageControlChange(Sender: TObject);
begin
 UpdateInfo;
end;

procedure TForm1.btSortSizeClick(Sender: TObject);
begin
 If Length(Lib)<1 then Exit;
 AnalyzeLayouts;
 SetScrollLt(True);
 PaintLayouts;
end;

procedure TForm1.mNewClick(Sender: TObject);
var name: String;
begin
 name:= (Sender as TMenuItem).Name;
 If name = 'mNewBrk' then NewBrick(True)
 else if name = 'mNewBrkHqr' then NewBrick(False)
 else if name = 'mNewLt1' then NewLayout(True,True)
 else if name = 'mNewLt2' then NewLayout(True,False)
 else if name = 'mNewLib1' then NewLayout(False,True)
 else if name = 'mNewLib2' then NewLayout(False,False)
 //else if name='mNewBkg' then NewBkg;
end;

procedure TForm1.pmBricksPopup(Sender: TObject);
var ena: Boolean;
begin
 ena:= BrkCount > 0;
 mEditBrk.Enabled:= ena;
 mExportBrk.Enabled:= ena;
 mExportBrkBit.Enabled:= ena;
 mImportBrk.Enabled:= ena;
 mMoveForw.Enabled:= BrkCount > 1;
 mMoveBack.Enabled:= BrkCount > 1;
 mDelete.Enabled:= ena and not SingleBrick;
end;

procedure TForm1.mFileClick(Sender: TObject);
var ena: Boolean;
begin
 ena:= BricksOpened and not SingleBrick;
 mNewLt1.Enabled:= ena;
 mNewLt2.Enabled:= ena;
 mNewLib1.Enabled:= ena;
 mNewLib2.Enabled:= ena;
end;

procedure TForm1.pmLayoutsPopup(Sender: TObject);
 var ena: Boolean;
begin
 ena:= Length(Lib) > 0;
 mLtEditStr.Enabled:= ena;
 mLtEditImg.Enabled:= ena;
 mExportLay.Enabled:= ena;
 mExportLayBit.Enabled:= ena;
 mCopyLt.Enabled:= ena;
 mRemSharing.Enabled:= ena;
 mDeleteLt.Enabled:= ena and not SingleLayout;
end;

procedure TForm1.mScenPropClick(Sender: TObject);
begin
 fmScenProp.SetInfo(not LLba1, VScen, HQSInfo.InfoText, ScenDescription);
 fmScenProp.ShowModal;
 HQSInfo.InfoText:= fmScenProp.eShortDesc.Text;
 ScenDescription:= fmScenProp.mLongDesc.Lines.Text;
end;

procedure TForm1.mChooseEntryClick(Sender: TObject);
begin
 LoadLibrary(LibPath);
end;

initialization
 bufLayout:= TBitmap.Create;
 bufLayout.pixelformat:= pf32bit;
 bufLayout.Transparent:= False;
 bufBrick:= TBitmap.Create;
 bufBrick.pixelformat:= pf32bit;
 bufBrick.Transparent:= False;

finalization
 If Assigned(bufLayout) then bufLayout.Free;
 If Assigned(bufBrick) then bufBrick.Free;

end.
