unit Editing;

interface

uses Windows, SysUtils, Settings;

type
 TListEntry = record
  GridPath: String;
  LibPath: String;
  BrickPath: String;
  ScenePath: String;
  GridEx, LibEx, BrickEx, SceneEx: Boolean;
 end;

 TFileList = array of TListEntry;

const
 MaxUndo = 30;

var
 TheList: TFileList;

 IndexTemp, XTemp: Integer;
 PathTemp: String;

 UndoArray: array[1..MaxUndo] of TFileList;
 RedoImage: TFileList;
 LastUndo: Integer = 0;
 FirstRedo: Integer = 0;

procedure SetUndo();
procedure DoUndo();
procedure DoRedo();
function GetColumn(x: Integer): Integer;
procedure SetListItem(Index, Column: Integer; Path: String;
 SetUndoItem: Boolean = False);
procedure AddFileAuto(Index, x: Integer; Path: String);
procedure DeleteSelectedFiles();
procedure MoveSelectedToTop();
procedure MoveSelectedToBottom();
procedure MoveSelectedUp();
procedure MoveSelectedDown();

implementation

uses Main, ComCtrls, Projects;

procedure SetUndo();
var a: Integer;
begin
 If LastUndo < MaxUndo then
  Inc(LastUndo)
 else
  for a:= 1 to MaxUndo - 1 do
   UndoArray[a]:= UndoArray[a+1];
 UndoArray[LastUndo]:= Copy(TheList);
 Form1.aRedo.Enabled:= False;
 Form1.aUndo.Enabled:= True;
end;

procedure DoUndo();
begin
 If not Form1.aRedo.Enabled then begin
  RedoImage:= Copy(TheList);
  FirstRedo:= LastUndo;
 end;
 TheList:= Copy(UndoArray[LastUndo]);
 If LastUndo > 0 then Dec(LastUndo);
 If LastUndo < 1 then Form1.aUndo.Enabled:= False;
 Form1.aRedo.Enabled:= True;
 Form1.lvList.Items.Count:= Length(TheList);
 Form1.lvList.Repaint;
end;

procedure DoRedo();
begin
 Inc(LastUndo);
 If LastUndo < FirstRedo then
  TheList:= Copy(UndoArray[LastUndo+1])
 else begin
  TheList:= RedoImage;
  Form1.aRedo.Enabled:= False;
 end;
 Form1.aUndo.Enabled:= True;
 Form1.lvList.Items.Count:= Length(TheList);
 Form1.lvList.Repaint;
end;

function GetColumn(x: Integer): Integer;
var a, w: Integer;
begin
 Result:= -1;
 w:= 0;
 for a:= 0 to Form1.lvList.Columns.Count - 1 do begin
  w:= w + Form1.lvList.Columns.Items[a].Width;
  If x < w then begin
   Result:= a;
   Break;
  end;
 end;
end;

procedure SetListItem(Index, Column: Integer; Path: String;
 SetUndoItem: Boolean = False);
var fe: Boolean;
begin
 If SetUndoItem then SetUndo();
 case Column of
  0: begin
      TheList[Index].GridPath:= Path;
      TheList[Index].LibPath:= Path;
      TheList[Index].BrickPath:= Path;
      TheList[Index].ScenePath:= Path;
      //Form1.lvList.Items.Item[Index].SubItems.Strings[0]:= Path;
      //Form1.lvList.Items.Item[Index].SubItems.Strings[1]:= Path;
      //Form1.lvList.Items.Item[Index].SubItems.Strings[2]:= Path;
      //Form1.lvList.Items.Item[Index].SubItems.Strings[3]:= Path;
     end;
  1: TheList[Index].GridPath:= Path;
  2: begin
      TheList[Index].LibPath:= Path;
      If AnsiSameText(Path,'<B>') then
       TheList[Index].BrickPath:= '<B>'
      else if AnsiSameText(TheList[Index].BrickPath,'<B>') then
       TheList[Index].BrickPath:= '';
     end;
  3: begin
      TheList[Index].BrickPath:= Path;
      If AnsiSameText(Path,'<B>') then
       TheList[Index].LibPath:= '<B>'
      else if AnsiSameText(TheList[Index].LibPath,'<B>') then
       TheList[Index].LibPath:= '';
     end;
  4: TheList[Index].ScenePath:= Path;
 end;
 //If Column > 0 then
 // Form1.lvList.Items.Item[Index].SubItems.Strings[Column-1]:= Path;
 CheckExistingLine(Index);
 Form1.lvList.Repaint();
 SetProjectModified(True);
end;

procedure DeleteListItem(Index: Integer);
var a: Integer;
begin
 If (Index >= 0) and (Index < Length(TheList)) then begin
  for a:= Index to High(TheList) - 1 do
   TheList[a]:= TheList[a + 1];
  SetLength(TheList, High(TheList));
  SetProjectModified(True);
 end;
end;

procedure AddFile(Column: Integer; Path: String);
//var Temp: TListItem;
begin
 SetUndo();
 SetLength(TheList, Length(TheList) + 1);
 //Temp:=
 //Form1.lvList.Items.Add();
 Form1.lvList.Items.Count:= Length(TheList);
 //Temp.Caption:= IntToStr(Length(TheList));
 //Temp.SubItems.Add('');
 //Temp.SubItems.Add('');
 //Temp.SubItems.Add('');
 //Temp.SubItems.Add('');
 SetListItem(High(TheList),Column,Path);
end;

procedure InsertFile(Index, Column: Integer; Path: String);
var a: Integer;
    Temp: TListItem;
begin
 SetUndo();
 SetLength(TheList, Length(TheList) + 1);
 for a:= High(TheList) downto Index + 1 do
  TheList[a]:= TheList[a - 1];
 TheList[Index].GridPath:= '';
 TheList[Index].LibPath:= '';
 TheList[Index].BrickPath:= '';
 TheList[Index].ScenePath:= ''; 
// Temp:= Form1.lvList.Items.Insert(Index);
 Form1.lvList.Items.Count:= Length(TheList);
 //Temp.Caption:= IntToStr(Index + 1);
 //Temp.SubItems.Add('');
 //Temp.SubItems.Add('');
 //Temp.SubItems.Add('');
 //Temp.SubItems.Add('');
 SetListItem(Index,Column,Path);
end;

//index jest liczony od zera!
procedure AddFileAuto(Index, x: Integer; Path: String);
var a: Integer;
begin
 a:= GetColumn(x);
 If a > -1 then begin
  If (Index >= 0) and (Index < Length(TheList)) then
   InsertFile(Index, a, Path)
  else
   AddFile(a, Path);
 end;
end;

procedure DeleteSelectedFiles();
var a: Integer;
begin
 If Form1.lvList.SelCount > 0 then begin
  If not MainSettings.AskDeletingRow
  or (MessageBox(Form1.Handle,'Delete selected rows?','Little Stage Designer',MB_ICONQUESTION+MB_YESNO) = ID_Yes)
  then begin
   SetUndo();
   for a:= Form1.lvList.Items.Count - 1 downto 0 do
    If Form1.lvList.Items.Item[a].Selected then
     DeleteListItem(a);
   //Form1.lvList.DeleteSelected();
   Form1.lvList.Items.Count:= Length(TheList);
   Form1.lvList.Repaint;
  end;
 end;
end;

procedure MoveSelectedToTop();
var a, b, c: Integer;
    Temp: TlistEntry;
begin
 If Form1.lvList.SelCount > 0 then begin
  SetUndo();
  c:= 0;
  for a:= 0 to Form1.lvList.Items.Count - 1 do
   If Form1.lvList.Items.Item[a].Selected then begin
    Temp:= TheList[a];
    for b:= a downto c + 1 do
     TheList[b]:= TheList[b - 1];
    TheList[c]:= Temp;
    Form1.lvList.Items.Item[a].Selected:= False;
    Form1.lvList.Items.Item[c].Selected:= True;
    Inc(c);
   end;
  SetProjectModified(True);
 end;
end;

procedure MoveSelectedToBottom();
var a, b, c: Integer;
    Temp: TlistEntry;
begin
 If Form1.lvList.SelCount > 0 then begin
  SetUndo();
  c:= Form1.lvList.Items.Count - 1;
  for a:= c downto 0 do
   If Form1.lvList.Items.Item[a].Selected then begin
    Temp:= TheList[a];
    for b:= a to c - 1 do
     TheList[b]:= TheList[b + 1];
    TheList[c]:= Temp;
    Form1.lvList.Items.Item[a].Selected:= False;
    Form1.lvList.Items.Item[c].Selected:= True;
    Dec(c);
   end;
  SetProjectModified(True);
 end;
end;

procedure MoveSelectedUp();
var a: Integer;
    Temp: TlistEntry;
begin
 If Form1.lvList.SelCount > 0 then begin
  SetUndo();
  for a:= 0 to Form1.lvList.Items.Count - 1 do
   If Form1.lvList.Items.Item[a].Selected
   and (a > 0) and not Form1.lvList.Items.Item[a - 1].Selected then begin
    Temp:= TheList[a];
    TheList[a]:= TheList[a - 1];
    TheList[a - 1]:= Temp;
    Form1.lvList.Items.Item[a].Selected:= False;
    Form1.lvList.Items.Item[a - 1].Selected:= True;
   end;
  SetProjectModified(True);
 end;
end;

procedure MoveSelectedDown();
var a, c: Integer;
    Temp: TlistEntry;
begin
 If Form1.lvList.SelCount > 0 then begin
  SetUndo();
  c:= Form1.lvList.Items.Count - 1;
  for a:= c downto 0 do
   If Form1.lvList.Items.Item[a].Selected
   and (a < c) and not Form1.lvList.Items.Item[a + 1].Selected then begin
    Temp:= TheList[a];
    TheList[a]:= TheList[a + 1];
    TheList[a + 1]:= Temp;
    Form1.lvList.Items.Item[a].Selected:= False;
    Form1.lvList.Items.Item[a + 1].Selected:= True;
   end;
  SetProjectModified(True);
 end;
end;

end.
