unit ScenProp;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, StrUtils, DePack;

type
  TfmScenProp = class(TForm)
    Label1: TLabel;
    eShortDesc: TEdit;
    Label2: TLabel;
    mLongDesc: TMemo;
    btOK: TBitBtn;
    lbInfo: TLabel;
    Label3: TLabel;
    procedure btOKClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    procedure SetInfo(Lba2: Boolean; Scenario: TPackEntries;
     ShortDesc, LongDesc: String);
  end;

var
  fmScenProp: TfmScenProp;

implementation

{$R *.dfm}

procedure TfmScenProp.btOKClick(Sender: TObject);
begin
 Close;
end;

procedure TfmScenProp.SetInfo(Lba2: Boolean; Scenario: TPackEntries;
     ShortDesc, LongDesc: String);
var GridEx, SceneEx: Boolean;
begin
 If Length(Scenario) > 8 then begin
  GridEx:= Scenario[3].FType = -1;
  SceneEx:= (Scenario[7].FType = -1) or (Scenario[8].FType = -1);
 end
 else begin
  GridEx:= False;
  SceneEx:= False;
 end;

 lbInfo.Caption:= 'Scenario type: ' + IfThen(Lba2,'LBA 2','LBA 1')
  + ',   Grid is present: ' + IfThen(GridEx,'Yes','No')
  + ',   Scene script is present: ' + IfThen(SceneEx,'Yes','No');

 eShortDesc.Text:= Trim(ShortDesc);
 mLongDesc.Lines.Text:= LongDesc;
end;

procedure TfmScenProp.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 If Length(eShortDesc.Text) > 255 then
  eShortDesc.Text:= Copy(eShortDesc.Text,1,255);
end;

end.
